/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.cli;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.HexDump;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericObject;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.cli.AbstractCmd;
import org.apache.pulsar.client.cli.PulsarClientTool;
import org.apache.pulsar.client.internal.PulsarClientImplementationBinding;
import org.apache.pulsar.common.api.EncryptionContext;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.util.DateFormatter;
import org.apache.pulsar.common.util.collections.GrowableArrayBlockingQueue;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCmdConsume
extends AbstractCmd {
    protected static final Logger LOG = LoggerFactory.getLogger(PulsarClientTool.class);
    protected static final String MESSAGE_BOUNDARY = "----- got message -----";
    protected ClientBuilder clientBuilder;
    protected Authentication authentication;
    protected String serviceURL;

    public void updateConfig(ClientBuilder clientBuilder, Authentication authentication, String serviceURL) {
        this.clientBuilder = clientBuilder;
        this.authentication = authentication;
        this.serviceURL = serviceURL;
    }

    protected String interpretMessage(Message<?> message, boolean displayHex, boolean printMetadata) throws IOException {
        String data;
        StringBuilder sb = new StringBuilder();
        String properties = Arrays.toString(message.getProperties().entrySet().toArray());
        Object value = message.getValue();
        if (value == null) {
            data = "null";
        } else if (value instanceof byte[]) {
            byte[] msgData = (byte[])value;
            data = AbstractCmdConsume.interpretByteArray(displayHex, msgData);
        } else if (value instanceof GenericObject) {
            Map<String, Object> asMap = AbstractCmdConsume.genericObjectToMap((GenericObject)value, displayHex);
            data = asMap.toString();
        } else {
            data = value instanceof ByteBuffer ? new String(PulsarClientImplementationBinding.getBytes((ByteBuffer)((ByteBuffer)value))) : value.toString();
        }
        sb.append("publishTime:[").append(message.getPublishTime()).append("], ");
        sb.append("eventTime:[").append(message.getEventTime()).append("], ");
        String key = null;
        if (message.hasKey()) {
            key = message.getKey();
        }
        sb.append("key:[").append(key).append("], ");
        if (!properties.isEmpty()) {
            sb.append("properties:").append(properties).append(", ");
        }
        sb.append("content:").append(data);
        if (printMetadata) {
            EncryptionContext encContext;
            if (message.getEncryptionCtx().isPresent() && (encContext = (EncryptionContext)message.getEncryptionCtx().get()).getKeys() != null && !encContext.getKeys().isEmpty()) {
                sb.append(", ");
                sb.append("encryption-keys:").append(", ");
                encContext.getKeys().forEach((keyName, keyInfo) -> {
                    String metadata = Arrays.toString(keyInfo.getMetadata().entrySet().toArray());
                    sb.append("name:").append((String)keyName).append(", ").append("key-value:").append(Base64.getEncoder().encode(keyInfo.getKeyValue())).append(", ").append("metadata:").append(metadata).append(", ");
                });
                sb.append(", ").append("param:").append(Base64.getEncoder().encode(encContext.getParam())).append(", ").append("algorithm:").append(encContext.getAlgorithm()).append(", ").append("compression-type:").append(encContext.getCompressionType()).append(", ").append("uncompressed-size").append(encContext.getUncompressedMessageSize()).append(", ").append("batch-size").append(encContext.getBatchSize().isPresent() ? (Integer)encContext.getBatchSize().get() : 1);
            }
            if (message.hasBrokerPublishTime()) {
                sb.append(", ").append("publish-time:").append(DateFormatter.format((long)message.getPublishTime()));
            }
            sb.append(", ").append("event-time:").append(DateFormatter.format((long)message.getEventTime()));
            sb.append(", ").append("message-id:").append(message.getMessageId());
            sb.append(", ").append("producer-name:").append(message.getProducerName());
            sb.append(", ").append("sequence-id:").append(message.getSequenceId());
            sb.append(", ").append("replicated-from:").append(message.getReplicatedFrom());
            sb.append(", ").append("redelivery-count:").append(message.getRedeliveryCount());
            sb.append(", ").append("ordering-key:").append(message.getOrderingKey() != null ? new String(message.getOrderingKey()) : "");
            sb.append(", ").append("schema-version:").append(message.getSchemaVersion() != null ? new String(message.getSchemaVersion()) : "");
            if (message.hasIndex()) {
                sb.append(", ").append("index:").append(message.getIndex());
            }
        }
        return sb.toString();
    }

    protected static String interpretByteArray(boolean displayHex, byte[] msgData) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (!displayHex) {
            return new String(msgData);
        }
        HexDump.dump((byte[])msgData, (long)0L, (OutputStream)out, (int)0);
        return out.toString();
    }

    protected static Map<String, Object> genericObjectToMap(GenericObject value, boolean displayHex) throws IOException {
        switch (value.getSchemaType()) {
            case AVRO: 
            case JSON: 
            case PROTOBUF_NATIVE: {
                return AbstractCmdConsume.genericRecordToMap((GenericRecord)value, displayHex);
            }
            case KEY_VALUE: {
                return AbstractCmdConsume.keyValueToMap((KeyValue)value.getNativeObject(), displayHex);
            }
        }
        return AbstractCmdConsume.primitiveValueToMap(value.getNativeObject(), displayHex);
    }

    protected static Map<String, Object> keyValueToMap(KeyValue value, boolean displayHex) throws IOException {
        if (value == null) {
            return ImmutableMap.of((Object)"value", (Object)"NULL");
        }
        return ImmutableMap.of((Object)"key", AbstractCmdConsume.primitiveValueToMap(value.getKey(), displayHex), (Object)"value", AbstractCmdConsume.primitiveValueToMap(value.getValue(), displayHex));
    }

    protected static Map<String, Object> primitiveValueToMap(Object value, boolean displayHex) throws IOException {
        if (value == null) {
            return ImmutableMap.of((Object)"value", (Object)"NULL");
        }
        if (value instanceof GenericObject) {
            return AbstractCmdConsume.genericObjectToMap((GenericObject)value, displayHex);
        }
        if (value instanceof byte[]) {
            value = AbstractCmdConsume.interpretByteArray(displayHex, (byte[])value);
        }
        return ImmutableMap.of((Object)"value", (Object)value.toString(), (Object)"type", value.getClass());
    }

    protected static Map<String, Object> genericRecordToMap(GenericRecord value, boolean displayHex) throws IOException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Field f : value.getFields()) {
            Map<String, Object> fieldValue = value.getField(f);
            if (fieldValue instanceof GenericRecord) {
                fieldValue = AbstractCmdConsume.genericRecordToMap((GenericRecord)fieldValue, displayHex);
            } else if (fieldValue == null) {
                fieldValue = "NULL";
            } else if (fieldValue instanceof byte[]) {
                fieldValue = AbstractCmdConsume.interpretByteArray(displayHex, (byte[])fieldValue);
            }
            res.put(f.getName(), fieldValue);
        }
        return res;
    }

    @WebSocket(maxTextMessageSize=65536)
    public static class ConsumerSocket {
        private static final String X_PULSAR_MESSAGE_ID = "messageId";
        private final CountDownLatch closeLatch = new CountDownLatch(1);
        private Session session;
        private CompletableFuture<Void> connected;
        final BlockingQueue<String> incomingMessages;
        private static final Logger log = LoggerFactory.getLogger(ConsumerSocket.class);

        public ConsumerSocket(CompletableFuture<Void> connected) {
            this.connected = connected;
            this.incomingMessages = new GrowableArrayBlockingQueue();
        }

        public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
            return this.closeLatch.await(duration, unit);
        }

        @OnWebSocketClose
        public void onClose(int statusCode, String reason) {
            log.info("Connection closed: {} - {}", (Object)statusCode, (Object)reason);
            this.session = null;
            this.closeLatch.countDown();
        }

        @OnWebSocketConnect
        public void onConnect(Session session) throws InterruptedException {
            log.info("Got connect: {}", (Object)session);
            this.session = session;
            this.connected.complete(null);
        }

        @OnWebSocketMessage
        public synchronized void onMessage(String msg) throws Exception {
            JsonObject message = (JsonObject)new Gson().fromJson(msg, JsonObject.class);
            JsonObject ack = new JsonObject();
            String messageId = message.get(X_PULSAR_MESSAGE_ID).getAsString();
            ack.add(X_PULSAR_MESSAGE_ID, (JsonElement)new JsonPrimitive(messageId));
            this.getRemote().sendString(ack.toString());
            this.incomingMessages.put(msg);
        }

        public String receive(long timeout, TimeUnit unit) throws Exception {
            return this.incomingMessages.poll(timeout, unit);
        }

        public RemoteEndpoint getRemote() {
            return this.session.getRemote();
        }

        public Session getSession() {
            return this.session;
        }

        public void close() {
            this.session.close();
        }
    }
}

