/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.google.protobuf.Descriptors;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.client.impl.schema.ProtobufNativeSchemaUtils;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;

public class ProtobufNativeSchemaCompatibilityCheck
implements SchemaCompatibilityCheck {
    @Override
    public SchemaType getSchemaType() {
        return SchemaType.PROTOBUF_NATIVE;
    }

    @Override
    public void checkCompatible(SchemaData from, SchemaData to, SchemaCompatibilityStrategy strategy) throws IncompatibleSchemaException {
        Descriptors.Descriptor fromDescriptor = ProtobufNativeSchemaUtils.deserialize((byte[])from.getData());
        Descriptors.Descriptor toDescriptor = ProtobufNativeSchemaUtils.deserialize((byte[])to.getData());
        switch (strategy) {
            case BACKWARD_TRANSITIVE: 
            case BACKWARD: 
            case FORWARD_TRANSITIVE: 
            case FORWARD: 
            case FULL_TRANSITIVE: 
            case FULL: {
                this.checkRootMessageChange(fromDescriptor, toDescriptor, strategy);
                return;
            }
            case ALWAYS_COMPATIBLE: {
                return;
            }
        }
        throw new IncompatibleSchemaException("Unknown SchemaCompatibilityStrategy.");
    }

    @Override
    public void checkCompatible(Iterable<SchemaData> from, SchemaData to, SchemaCompatibilityStrategy strategy) throws IncompatibleSchemaException {
        for (SchemaData schemaData : from) {
            this.checkCompatible(schemaData, to, strategy);
        }
    }

    private void checkRootMessageChange(Descriptors.Descriptor fromDescriptor, Descriptors.Descriptor toDescriptor, SchemaCompatibilityStrategy strategy) throws IncompatibleSchemaException {
        if (!fromDescriptor.getFullName().equals(toDescriptor.getFullName())) {
            throw new IncompatibleSchemaException("Protobuf root message change is not allowed under the '" + String.valueOf(strategy) + "' strategy. Original message name: '" + fromDescriptor.getFullName() + "', new message name: '" + toDescriptor.getFullName() + "'.");
        }
    }
}

