/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.testclient.PerformanceBaseArguments;
import org.apache.pulsar.testclient.PositiveNumberParameterConvert;
import picocli.CommandLine;

public abstract class PerformanceTopicListArguments
extends PerformanceBaseArguments {
    @CommandLine.Parameters(description={"persistent://prop/ns/my-topic"}, arity="1")
    public List<String> topics;
    @CommandLine.Option(names={"-t", "--num-topics", "--num-topic"}, description={"Number of topics.  Must matchthe given number of topic arguments."}, converter={PositiveNumberParameterConvert.class})
    public int numTopics = 1;

    public PerformanceTopicListArguments(String cmdName) {
        super(cmdName);
    }

    @Override
    public void validate() throws Exception {
        super.validate();
        for (String arg : this.topics) {
            if (!arg.startsWith("-")) continue;
            String errMsg = String.format("invalid option: '%s', to use a topic with the name '%s', please use a fully qualified topic name", arg, arg);
            throw new Exception(errMsg);
        }
        if (this.topics.size() != this.numTopics) {
            if (this.topics.size() == 1) {
                String prefixTopicName = TopicName.get((String)this.topics.get(0)).toString().trim();
                ArrayList<String> defaultTopics = new ArrayList<String>();
                for (int i = 0; i < this.numTopics; ++i) {
                    defaultTopics.add(String.format("%s-%d", prefixTopicName, i));
                }
                this.topics = defaultTopics;
            } else {
                String errMsg = String.format("the number of topic names (%d) must be equal to --num-topics (%d)", this.topics.size(), this.numTopics);
                throw new Exception(errMsg);
            }
        }
    }
}

