/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public final class DaemonThreadFactory
implements ThreadFactory {
    private final String namePrefix;
    private final AtomicInteger counter = new AtomicInteger();
    private final ThreadFactory delegate;

    public DaemonThreadFactory(String namePrefix) {
        this(namePrefix, Executors.defaultThreadFactory());
    }

    public DaemonThreadFactory(String namePrefix, ThreadFactory delegate) {
        this.namePrefix = namePrefix;
        this.delegate = delegate;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t = this.delegate.newThread(runnable);
        t.setUncaughtExceptionHandler(new ManagedUncaughtExceptionHandler(t.getUncaughtExceptionHandler()));
        try {
            t.setDaemon(true);
            t.setName(this.namePrefix + "-" + this.counter.incrementAndGet());
            t.setContextClassLoader(null);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return t;
    }

    static class ManagedUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        @Nullable
        private final Thread.UncaughtExceptionHandler delegate;

        private ManagedUncaughtExceptionHandler(@Nullable Thread.UncaughtExceptionHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof InterruptedException) {
                t.interrupt();
            } else if (this.delegate != null) {
                this.delegate.uncaughtException(t, e);
            }
        }
    }
}

