/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.naming.AuthenticationException;
import javax.net.ssl.SSLSession;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.impl.AckSetStateUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.TransactionMetadataStoreService;
import org.apache.pulsar.broker.admin.impl.PersistentTopicsBase;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationDataSubscription;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.limiter.ConnectionController;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.lookup.TopicLookupBase;
import org.apache.pulsar.broker.namespace.LookupOptions;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.service.AbstractTopic;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.PulsarCommandSender;
import org.apache.pulsar.broker.service.PulsarCommandSenderImpl;
import org.apache.pulsar.broker.service.ServerCnxThrottleTracker;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.SubscriptionOption;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.TopicListService;
import org.apache.pulsar.broker.service.TransportCnx;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.service.schema.BookkeeperSchemaStorage;
import org.apache.pulsar.broker.service.schema.SchemaRegistryService;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.schema.SchemaInfoUtil;
import org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.common.api.proto.BaseCommand;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.api.proto.CommandAddPartitionToTxn;
import org.apache.pulsar.common.api.proto.CommandAddSubscriptionToTxn;
import org.apache.pulsar.common.api.proto.CommandAuthResponse;
import org.apache.pulsar.common.api.proto.CommandCloseConsumer;
import org.apache.pulsar.common.api.proto.CommandCloseProducer;
import org.apache.pulsar.common.api.proto.CommandConnect;
import org.apache.pulsar.common.api.proto.CommandConsumerStats;
import org.apache.pulsar.common.api.proto.CommandEndTxn;
import org.apache.pulsar.common.api.proto.CommandEndTxnOnPartition;
import org.apache.pulsar.common.api.proto.CommandEndTxnOnSubscription;
import org.apache.pulsar.common.api.proto.CommandFlow;
import org.apache.pulsar.common.api.proto.CommandGetLastMessageId;
import org.apache.pulsar.common.api.proto.CommandGetOrCreateSchema;
import org.apache.pulsar.common.api.proto.CommandGetSchema;
import org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.common.api.proto.CommandLookupTopic;
import org.apache.pulsar.common.api.proto.CommandNewTxn;
import org.apache.pulsar.common.api.proto.CommandPartitionedTopicMetadata;
import org.apache.pulsar.common.api.proto.CommandProducer;
import org.apache.pulsar.common.api.proto.CommandRedeliverUnacknowledgedMessages;
import org.apache.pulsar.common.api.proto.CommandSeek;
import org.apache.pulsar.common.api.proto.CommandSend;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.CommandTcClientConnectRequest;
import org.apache.pulsar.common.api.proto.CommandTopicMigrated;
import org.apache.pulsar.common.api.proto.CommandUnsubscribe;
import org.apache.pulsar.common.api.proto.CommandWatchTopicList;
import org.apache.pulsar.common.api.proto.CommandWatchTopicListClose;
import org.apache.pulsar.common.api.proto.FeatureFlags;
import org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.common.api.proto.KeySharedMode;
import org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.common.api.proto.MessageIdData;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.api.proto.ProducerAccessMode;
import org.apache.pulsar.common.api.proto.ProtocolVersion;
import org.apache.pulsar.common.api.proto.Schema;
import org.apache.pulsar.common.api.proto.ServerError;
import org.apache.pulsar.common.api.proto.TxnAction;
import org.apache.pulsar.common.configuration.anonymizer.DefaultAuthenticationRoleLoggingAnonymizer;
import org.apache.pulsar.common.intercept.InterceptException;
import org.apache.pulsar.common.lookup.data.LookupData;
import org.apache.pulsar.common.naming.Metadata;
import org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.ClusterPolicies;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.policies.data.TopicType;
import org.apache.pulsar.common.policies.data.stats.ConsumerStatsImpl;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.protocol.CommandUtils;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.protocol.PulsarHandler;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.topics.TopicList;
import org.apache.pulsar.common.topics.TopicsPattern;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.StringInterner;
import org.apache.pulsar.common.util.collections.ConcurrentLongHashMap;
import org.apache.pulsar.common.util.netty.NettyChannelUtil;
import org.apache.pulsar.common.util.netty.NettyFutureUtil;
import org.apache.pulsar.functions.utils.Exceptions;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.exceptions.CoordinatorException;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCnx
extends PulsarHandler
implements TransportCnx {
    private final BrokerService service;
    private final SchemaRegistryService schemaService;
    private final String listenerName;
    private final Map<Long, Long> recentlyClosedProducers;
    private final ConcurrentLongHashMap<CompletableFuture<Producer>> producers;
    private final ConcurrentLongHashMap<CompletableFuture<Consumer>> consumers;
    private final boolean enableSubscriptionPatternEvaluation;
    private final int maxSubscriptionPatternLength;
    private final TopicListService topicListService;
    private final BrokerInterceptor brokerInterceptor;
    private State state;
    private volatile boolean isActive = true;
    private String authRole = null;
    private volatile AuthenticationDataSource authenticationData;
    private AuthenticationProvider authenticationProvider;
    private AuthenticationState authState;
    private AuthenticationState originalAuthState;
    private volatile AuthenticationDataSource originalAuthData;
    private AuthData originalAuthDataCopy;
    private boolean pendingAuthChallengeResponse = false;
    private ScheduledFuture<?> authRefreshTask;
    private final DefaultAuthenticationRoleLoggingAnonymizer authenticationRoleLoggingAnonymizer;
    private final int maxPendingSendRequests;
    private final int resumeReadsThreshold;
    private int pendingSendRequest = 0;
    private final String replicatorPrefix;
    private String clientVersion = null;
    private String proxyVersion = null;
    private String clientSourceAddressAndPort;
    private int nonPersistentPendingMessages = 0;
    private final int maxNonPersistentPendingMessages;
    private String originalPrincipal = null;
    private final boolean schemaValidationEnforced;
    private String authMethod = "none";
    private final int maxMessageSize;
    private boolean preciseDispatcherFlowControl;
    private boolean encryptionRequireOnProducer;
    private FeatureFlags features;
    private PulsarCommandSender commandSender;
    private final ConnectionController connectionController;
    private static final KeySharedMeta emptyKeySharedMeta = new KeySharedMeta().setKeySharedMode(KeySharedMode.AUTO_SPLIT);
    private final long maxPendingBytesPerThread;
    private final long resumeThresholdPendingBytesPerThread;
    private final long connectionLivenessCheckTimeoutMillis;
    private final TopicsPattern.RegexImplementation topicsPatternImplementation;
    private static final FastThreadLocal<Set<ServerCnx>> cnxsPerThread = new FastThreadLocal<Set<ServerCnx>>(){

        protected Set<ServerCnx> initialValue() throws Exception {
            return Collections.newSetFromMap(new IdentityHashMap());
        }
    };
    private final ServerCnxThrottleTracker throttleTracker;
    private static final byte[] emptyArray = new byte[0];
    private static final Logger log = LoggerFactory.getLogger(ServerCnx.class);
    CompletableFuture<Optional<Boolean>> connectionCheckInProgress;

    public ServerCnx(PulsarService pulsar) {
        this(pulsar, null);
    }

    public ServerCnx(PulsarService pulsar, String listenerName) {
        super(pulsar.getBrokerService() != null ? pulsar.getBrokerService().getKeepAliveIntervalSeconds() : 0, TimeUnit.SECONDS);
        this.service = pulsar.getBrokerService();
        this.schemaService = pulsar.getSchemaRegistryService();
        this.listenerName = listenerName;
        this.state = State.Start;
        ServiceConfiguration conf = pulsar.getConfiguration();
        this.connectionLivenessCheckTimeoutMillis = conf.getConnectionLivenessCheckTimeoutMillis();
        this.producers = ConcurrentLongHashMap.newBuilder().expectedItems(8).concurrencyLevel(1).build();
        this.consumers = ConcurrentLongHashMap.newBuilder().expectedItems(8).concurrencyLevel(1).build();
        this.recentlyClosedProducers = new ConcurrentHashMap<Long, Long>();
        this.replicatorPrefix = conf.getReplicatorPrefix();
        this.maxNonPersistentPendingMessages = conf.getMaxConcurrentNonPersistentMessagePerConnection();
        this.schemaValidationEnforced = conf.isSchemaValidationEnforced();
        this.maxMessageSize = conf.getMaxMessageSize();
        this.maxPendingSendRequests = conf.getMaxPendingPublishRequestsPerConnection();
        this.resumeReadsThreshold = this.maxPendingSendRequests / 2;
        this.preciseDispatcherFlowControl = conf.isPreciseDispatcherFlowControl();
        this.encryptionRequireOnProducer = conf.isEncryptionRequireOnProducer();
        this.maxPendingBytesPerThread = (long)conf.getMaxMessagePublishBufferSizeInMB() * 1024L * 1024L / (long)conf.getNumIOThreads();
        this.resumeThresholdPendingBytesPerThread = this.maxPendingBytesPerThread / 2L;
        this.connectionController = new ConnectionController.DefaultConnectionController(conf.getBrokerMaxConnections(), conf.getBrokerMaxConnectionsPerIp());
        this.enableSubscriptionPatternEvaluation = conf.isEnableBrokerSideSubscriptionPatternEvaluation();
        this.maxSubscriptionPatternLength = conf.getSubscriptionPatternMaxLength();
        this.topicListService = new TopicListService(pulsar, this, this.enableSubscriptionPatternEvaluation, this.maxSubscriptionPatternLength);
        this.brokerInterceptor = this.service != null ? this.service.getInterceptor() : null;
        this.throttleTracker = new ServerCnxThrottleTracker(this);
        this.topicsPatternImplementation = conf.getTopicsPatternRegexImplementation();
        this.authenticationRoleLoggingAnonymizer = new DefaultAuthenticationRoleLoggingAnonymizer(conf.getAuthenticationRoleLoggingAnonymizer());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        ConnectionController.State state = this.connectionController.increaseConnection(this.remoteAddress);
        if (!state.equals((Object)ConnectionController.State.OK)) {
            ByteBuf msg = Commands.newError((long)-1L, (ServerError)ServerError.NotAllowedError, (String)(state.equals((Object)ConnectionController.State.REACH_MAX_CONNECTION) ? "Reached the maximum number of connections" : "Reached the maximum number of connections on address" + String.valueOf(this.remoteAddress)));
            NettyChannelUtil.writeAndFlushWithClosePromise((ChannelOutboundInvoker)ctx, (ByteBuf)msg);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("New connection from {}", (Object)this.remoteAddress);
        }
        this.ctx = ctx;
        this.commandSender = new PulsarCommandSenderImpl(this.brokerInterceptor, this);
        this.service.getPulsarStats().recordConnectionCreate();
        ((Set)cnxsPerThread.get()).add(this);
        this.service.getPulsar().runWhenReadyForIncomingRequests(() -> ctx.channel().config().setAutoRead(true));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.connectionController.decreaseConnection(ctx.channel().remoteAddress());
        this.isActive = false;
        log.info("Closed connection from {}", (Object)this.remoteAddress);
        if (this.brokerInterceptor != null) {
            this.brokerInterceptor.onConnectionClosed(this);
        }
        ((Set)cnxsPerThread.get()).remove(this);
        if (this.authRefreshTask != null) {
            this.authRefreshTask.cancel(false);
        }
        this.producers.forEach((__, producerFuture) -> {
            if (!producerFuture.isDone() && producerFuture.completeExceptionally(new IllegalStateException("Connection closed."))) {
                return;
            }
            if (producerFuture.isDone() && !producerFuture.isCompletedExceptionally()) {
                Producer producer = producerFuture.getNow(null);
                producer.closeNow(true);
                if (this.brokerInterceptor != null) {
                    this.brokerInterceptor.producerClosed(this, producer, producer.getMetadata());
                }
            }
        });
        this.consumers.forEach((__, consumerFuture) -> {
            if (!consumerFuture.isDone() && consumerFuture.completeExceptionally(new IllegalStateException("Connection closed."))) {
                return;
            }
            if (consumerFuture.isDone() && !consumerFuture.isCompletedExceptionally()) {
                Consumer consumer = consumerFuture.getNow(null);
                try {
                    consumer.close();
                    if (this.brokerInterceptor != null) {
                        this.brokerInterceptor.consumerClosed(this, consumer, consumer.getMetadata());
                    }
                }
                catch (BrokerServiceException e) {
                    log.warn("Consumer {} was already closed: {}", (Object)consumer, (Object)e);
                }
            }
        });
        this.topicListService.inactivate();
        this.service.getPulsarStats().recordConnectionClose();
        if (this.connectionCheckInProgress != null && !this.connectionCheckInProgress.isDone()) {
            this.connectionCheckInProgress.complete(Optional.of(false));
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Channel writability has changed to: {}", (Object)ctx.channel().isWritable());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.state != State.Failed) {
            log.warn("[{}] Got exception {}", (Object)this.remoteAddress, (Object)(ClientCnx.isKnownException((Throwable)cause) ? cause.toString() : ExceptionUtils.getStackTrace((Throwable)cause)));
            this.state = State.Failed;
            if (log.isDebugEnabled()) {
                log.debug("[{}] connect state change to : [{}]", (Object)this.remoteAddress, (Object)State.Failed.name());
            }
        } else if (log.isDebugEnabled()) {
            log.debug("[{}] Got exception {}", (Object)this.remoteAddress, (Object)(ClientCnx.isKnownException((Throwable)cause) ? cause.toString() : ExceptionUtils.getStackTrace((Throwable)cause)));
        }
        ctx.close();
    }

    private CompletableFuture<Boolean> isTopicOperationAllowed(TopicName topicName, TopicOperation operation, AuthenticationDataSource authDataSource, AuthenticationDataSource originalAuthDataSource) {
        if (!this.service.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        CompletableFuture result = this.service.getAuthorizationService().allowTopicOperationAsync(topicName, operation, this.originalPrincipal, this.authRole, originalAuthDataSource != null ? originalAuthDataSource : authDataSource, authDataSource);
        result.thenAccept(isAuthorized -> {
            if (!isAuthorized.booleanValue()) {
                log.warn("Role {} or OriginalRole {} is not authorized to perform operation {} on topic {}", new Object[]{this.authRole, this.originalPrincipal, operation, topicName});
            }
        });
        return result;
    }

    private CompletableFuture<Boolean> isTopicOperationAllowed(TopicName topicName, String subscriptionName, TopicOperation operation) {
        if (this.service.isAuthorizationEnabled()) {
            AuthenticationDataSubscription authDataSource = new AuthenticationDataSubscription(this.authenticationData, subscriptionName);
            AuthenticationDataSubscription originalAuthDataSource = null;
            if (this.originalAuthData != null) {
                originalAuthDataSource = new AuthenticationDataSubscription(this.originalAuthData, subscriptionName);
            }
            return this.isTopicOperationAllowed(topicName, operation, (AuthenticationDataSource)authDataSource, (AuthenticationDataSource)originalAuthDataSource);
        }
        return CompletableFuture.completedFuture(true);
    }

    protected void handleLookup(CommandLookupTopic lookup) {
        TopicName topicName;
        String advertisedListenerName;
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        long requestId = lookup.getRequestId();
        boolean authoritative = lookup.isAuthoritative();
        String string = advertisedListenerName = lookup.hasAdvertisedListenerName() && StringUtils.isNotBlank((CharSequence)lookup.getAdvertisedListenerName()) ? lookup.getAdvertisedListenerName() : this.listenerName;
        if (log.isDebugEnabled()) {
            log.debug("[{}] Received Lookup from {} for {} requesting listener {}", new Object[]{lookup.getTopic(), this.remoteAddress, requestId, StringUtils.isNotBlank((CharSequence)advertisedListenerName) ? advertisedListenerName : "(none)"});
        }
        if ((topicName = this.validateTopicName(lookup.getTopic(), requestId, lookup)) == null) {
            return;
        }
        if (!this.service.getPulsar().isRunning()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Failed lookup topic {} due to pulsar service is not ready: {} state", new Object[]{this.remoteAddress, topicName, this.service.getPulsar().getState().toString()});
            }
            this.writeAndFlush(Commands.newLookupErrorResponse((ServerError)ServerError.ServiceNotReady, (String)"Failed due to pulsar service is not ready", (long)requestId));
            return;
        }
        Semaphore lookupSemaphore = this.service.getLookupRequestSemaphore();
        if (lookupSemaphore.tryAcquire()) {
            ((CompletableFuture)this.isTopicOperationAllowed(topicName, TopicOperation.LOOKUP, this.authenticationData, this.originalAuthData).thenApply(isAuthorized -> {
                if (isAuthorized.booleanValue()) {
                    Map<String, String> properties;
                    if (lookup.getPropertiesCount() > 0) {
                        properties = new HashMap();
                        for (int i = 0; i < lookup.getPropertiesCount(); ++i) {
                            KeyValue keyValue = lookup.getPropertyAt(i);
                            properties.put(keyValue.getKey(), keyValue.getValue());
                        }
                    } else {
                        properties = Collections.emptyMap();
                    }
                    TopicLookupBase.lookupTopicAsync(this.getBrokerService().pulsar(), topicName, authoritative, this.authRole, this.originalPrincipal, this.authenticationData, this.originalAuthData != null ? this.originalAuthData : this.authenticationData, requestId, advertisedListenerName, properties).handle((lookupResponse, ex) -> {
                        if (ex == null) {
                            this.writeAndFlush((ByteBuf)lookupResponse);
                        } else {
                            log.warn("[{}] lookup failed with error {}, {}", new Object[]{this.remoteAddress, topicName, ex.getMessage(), ex});
                            this.writeAndFlush(Commands.newLookupErrorResponse((ServerError)ServerError.ServiceNotReady, (String)ex.getMessage(), (long)requestId));
                        }
                        lookupSemaphore.release();
                        return null;
                    });
                } else {
                    String msg = "Client is not authorized to Lookup";
                    log.warn("[{}] {} with role {} on topic {}", new Object[]{this.remoteAddress, "Client is not authorized to Lookup", this.getPrincipal(), topicName});
                    this.writeAndFlush(Commands.newLookupErrorResponse((ServerError)ServerError.AuthorizationError, (String)"Client is not authorized to Lookup", (long)requestId));
                    lookupSemaphore.release();
                }
                return null;
            })).exceptionally(ex -> {
                ServerCnx.logAuthException(this.remoteAddress, "lookup", this.getPrincipal(), Optional.of(topicName), ex);
                String msg = "Exception occurred while trying to authorize lookup";
                this.writeAndFlush(Commands.newLookupErrorResponse((ServerError)ServerError.AuthorizationError, (String)"Exception occurred while trying to authorize lookup", (long)requestId));
                lookupSemaphore.release();
                return null;
            });
        } else {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Failed lookup due to too many lookup-requests {}", (Object)this.remoteAddress, (Object)topicName);
            }
            this.writeAndFlush(Commands.newLookupErrorResponse((ServerError)ServerError.TooManyRequests, (String)"Failed due to too many pending lookup requests", (long)requestId));
        }
    }

    private void writeAndFlush(ByteBuf cmd) {
        NettyChannelUtil.writeAndFlushWithVoidPromise((ChannelOutboundInvoker)this.ctx, (ByteBuf)cmd);
    }

    protected void handlePartitionMetadataRequest(CommandPartitionedTopicMetadata partitionMetadata) {
        TopicName topicName;
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        long requestId = partitionMetadata.getRequestId();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Received PartitionMetadataLookup from {} for {}", new Object[]{partitionMetadata.getTopic(), this.remoteAddress, requestId});
        }
        if ((topicName = this.validateTopicName(partitionMetadata.getTopic(), requestId, partitionMetadata)) == null) {
            return;
        }
        if (!this.service.getPulsar().isRunning()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Failed PartitionMetadataLookup from {} for {} due to pulsar service is not ready: {} state", new Object[]{partitionMetadata.getTopic(), this.remoteAddress, requestId, this.service.getPulsar().getState().toString()});
            }
            this.writeAndFlush(Commands.newPartitionMetadataResponse((ServerError)ServerError.ServiceNotReady, (String)"Failed due to pulsar service is not ready", (long)requestId));
            return;
        }
        Semaphore lookupSemaphore = this.service.getLookupRequestSemaphore();
        if (lookupSemaphore.tryAcquire()) {
            ((CompletableFuture)this.isTopicOperationAllowed(topicName, TopicOperation.LOOKUP, this.authenticationData, this.originalAuthData).thenApply(isAuthorized -> {
                if (isAuthorized.booleanValue()) {
                    this.getBrokerService().isAllowAutoTopicCreationAsync(topicName).thenAccept(brokerAllowAutoCreate -> {
                        boolean autoCreateIfNotExist;
                        boolean bl = autoCreateIfNotExist = partitionMetadata.isMetadataAutoCreationEnabled() && brokerAllowAutoCreate != false;
                        if (!autoCreateIfNotExist) {
                            NamespaceService namespaceService = this.getBrokerService().getPulsar().getNamespaceService();
                            ((CompletableFuture)namespaceService.checkTopicExistsAsync(topicName).thenAccept(topicExistsInfo -> {
                                lookupSemaphore.release();
                                if (!topicExistsInfo.isExists()) {
                                    this.writeAndFlush(Commands.newPartitionMetadataResponse((ServerError)ServerError.TopicNotFound, (String)"", (long)requestId));
                                } else if (topicExistsInfo.getTopicType().equals((Object)TopicType.PARTITIONED)) {
                                    this.commandSender.sendPartitionMetadataResponse(topicExistsInfo.getPartitions(), requestId);
                                } else {
                                    this.commandSender.sendPartitionMetadataResponse(0, requestId);
                                }
                                topicExistsInfo.recycle();
                            })).exceptionally(ex -> {
                                lookupSemaphore.release();
                                log.error("{} {} Failed to get partition metadata", new Object[]{topicName, this.toString(), ex});
                                this.writeAndFlush(Commands.newPartitionMetadataResponse((ServerError)ServerError.MetadataError, (String)"Failed to get partition metadata", (long)requestId));
                                return null;
                            });
                        } else {
                            PersistentTopicsBase.unsafeGetPartitionedTopicMetadataAsync(this.getBrokerService().pulsar(), topicName).whenComplete((metadata, ex) -> {
                                lookupSemaphore.release();
                                if (ex == null) {
                                    int partitions = metadata.partitions;
                                    this.commandSender.sendPartitionMetadataResponse(partitions, requestId);
                                } else if (ex instanceof PulsarClientException) {
                                    log.warn("Failed to authorize {} at [{}] on topic {} : {}", new Object[]{this.getRole(), this.remoteAddress, topicName, ex.getMessage()});
                                    this.commandSender.sendPartitionMetadataResponse(ServerError.AuthorizationError, ex.getMessage(), requestId);
                                } else {
                                    ServerError error = ServerError.ServiceNotReady;
                                    if (ex instanceof MetadataStoreException) {
                                        error = ServerError.MetadataError;
                                    } else if (ex instanceof RestException) {
                                        RestException restException = (RestException)((Object)((Object)((Object)((Object)ex))));
                                        int responseCode = restException.getResponse().getStatus();
                                        if (responseCode == Response.Status.NOT_FOUND.getStatusCode()) {
                                            error = ServerError.TopicNotFound;
                                        } else if (responseCode < Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
                                            error = ServerError.MetadataError;
                                        }
                                    }
                                    if (error == ServerError.TopicNotFound) {
                                        log.info("Trying to get Partitioned Metadata for a resource not exist[{}] {}: {}", new Object[]{this.remoteAddress, topicName, ex.getMessage()});
                                    } else {
                                        log.warn("Failed to get Partitioned Metadata [{}] {}: {}", new Object[]{this.remoteAddress, topicName, ex.getMessage(), ex});
                                    }
                                    this.commandSender.sendPartitionMetadataResponse(error, ex.getMessage(), requestId);
                                }
                            });
                        }
                    });
                } else {
                    String msg = "Client is not authorized to Get Partition Metadata";
                    log.warn("[{}] {} with role {} on topic {}", new Object[]{this.remoteAddress, "Client is not authorized to Get Partition Metadata", this.getPrincipal(), topicName});
                    this.writeAndFlush(Commands.newPartitionMetadataResponse((ServerError)ServerError.AuthorizationError, (String)"Client is not authorized to Get Partition Metadata", (long)requestId));
                    lookupSemaphore.release();
                }
                return null;
            })).exceptionally(ex -> {
                WebApplicationException restException;
                ServerCnx.logAuthException(this.remoteAddress, "partition-metadata", this.getPrincipal(), Optional.of(topicName), ex);
                Throwable actEx = FutureUtil.unwrapCompletionException((Throwable)ex);
                if (actEx instanceof WebApplicationException && (restException = (WebApplicationException)actEx).getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                    this.writeAndFlush(Commands.newPartitionMetadataResponse((ServerError)ServerError.TopicNotFound, (String)("Tenant or namespace or topic does not exist: " + topicName.getNamespace()), (long)requestId));
                    lookupSemaphore.release();
                    return null;
                }
                String msg = "Exception occurred while trying to authorize get Partition Metadata";
                this.writeAndFlush(Commands.newPartitionMetadataResponse((ServerError)ServerError.AuthorizationError, (String)"Exception occurred while trying to authorize get Partition Metadata", (long)requestId));
                lookupSemaphore.release();
                return null;
            });
        } else {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Failed Partition-Metadata lookup due to too many lookup-requests {}", (Object)this.remoteAddress, (Object)topicName);
            }
            this.commandSender.sendPartitionMetadataResponse(ServerError.TooManyRequests, "Failed due to too many pending lookup requests", requestId);
        }
    }

    protected void handleConsumerStats(CommandConsumerStats commandConsumerStats) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        if (log.isDebugEnabled()) {
            log.debug("Received CommandConsumerStats call from {}", (Object)this.remoteAddress);
        }
        long requestId = commandConsumerStats.getRequestId();
        long consumerId = commandConsumerStats.getConsumerId();
        CompletableFuture consumerFuture = (CompletableFuture)this.consumers.get(consumerId);
        Consumer consumer = consumerFuture.getNow(null);
        ByteBuf msg = null;
        if (consumer == null) {
            log.error("Failed to get consumer-stats response - Consumer not found for CommandConsumerStats[remoteAddress = {}, requestId = {}, consumerId = {}]", new Object[]{this.remoteAddress, requestId, consumerId});
            msg = Commands.newConsumerStatsResponse((ServerError)ServerError.ConsumerNotFound, (String)("Consumer " + consumerId + " not found"), (long)requestId);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("CommandConsumerStats[requestId = {}, consumer = {}]", (Object)requestId, (Object)consumer);
            }
            msg = this.createConsumerStatsResponse(consumer, requestId);
        }
        this.writeAndFlush(msg);
    }

    ByteBuf createConsumerStatsResponse(Consumer consumer, long requestId) {
        ConsumerStatsImpl consumerStats = consumer.getStats();
        Subscription subscription = consumer.getSubscription();
        BaseCommand cmd = Commands.newConsumerStatsResponseCommand((ServerError)ServerError.UnknownError, null, (long)requestId);
        cmd.getConsumerStatsResponse().clearErrorCode().setRequestId(requestId).setMsgRateOut(consumerStats.msgRateOut).setMsgThroughputOut(consumerStats.msgThroughputOut).setMsgRateRedeliver(consumerStats.msgRateRedeliver).setConsumerName(consumerStats.consumerName).setAvailablePermits((long)consumerStats.availablePermits).setUnackedMessages((long)consumerStats.unackedMessages).setBlockedConsumerOnUnackedMsgs(consumerStats.blockedConsumerOnUnackedMsgs).setAddress(consumerStats.getAddress()).setConnectedSince(consumerStats.getConnectedSince()).setMsgBacklog(subscription.getNumberOfEntriesInBacklog(false)).setMsgRateExpired(subscription.getExpiredMessageRate()).setMessageAckRate(consumerStats.messageAckRate).setType(subscription.getTypeString());
        return Commands.serializeWithSize((BaseCommand)cmd);
    }

    private void completeConnect(int clientProtoVersion, String clientVersion) {
        if (this.service.isAuthenticationEnabled()) {
            if (this.service.isAuthorizationEnabled()) {
                if (!this.service.getAuthorizationService().isValidOriginalPrincipal(this.authRole, this.originalPrincipal, this.remoteAddress, false)) {
                    this.state = State.Failed;
                    this.service.getPulsarStats().recordConnectionCreateFail();
                    ByteBuf msg = Commands.newError((long)-1L, (ServerError)ServerError.AuthorizationError, (String)"Invalid roles.");
                    NettyChannelUtil.writeAndFlushWithClosePromise((ChannelOutboundInvoker)this.ctx, (ByteBuf)msg);
                    return;
                }
                if (this.proxyVersion != null && !this.service.getAuthorizationService().isProxyRole(this.authRole)) {
                    this.state = State.Failed;
                    this.service.getPulsarStats().recordConnectionCreateFail();
                    ByteBuf msg = Commands.newError((long)-1L, (ServerError)ServerError.AuthorizationError, (String)"Must not set proxyVersion without connecting as a ProxyRole.");
                    NettyChannelUtil.writeAndFlushWithClosePromise((ChannelOutboundInvoker)this.ctx, (ByteBuf)msg);
                    return;
                }
            }
            this.maybeScheduleAuthenticationCredentialsRefresh();
        }
        this.writeAndFlush(Commands.newConnected((int)clientProtoVersion, (int)this.maxMessageSize, (boolean)this.enableSubscriptionPatternEvaluation));
        this.state = State.Connected;
        this.service.getPulsarStats().recordConnectionCreateSuccess();
        if (log.isDebugEnabled()) {
            log.debug("[{}] connect state change to : [{}]", (Object)this.remoteAddress, (Object)State.Connected.name());
        }
        this.setRemoteEndpointProtocolVersion(clientProtoVersion);
        if (StringUtils.isNotBlank((CharSequence)clientVersion)) {
            this.clientVersion = StringInterner.intern((String)clientVersion);
        }
        if (!this.service.isAuthenticationEnabled()) {
            log.info("[{}] connected with clientVersion={}, clientProtocolVersion={}, proxyVersion={}", new Object[]{this.remoteAddress, clientVersion, clientProtoVersion, this.proxyVersion});
        } else if (this.originalPrincipal != null) {
            log.info("[{}] connected role={} and originalAuthRole={} using authMethod={}, clientVersion={}, clientProtocolVersion={}, proxyVersion={}", new Object[]{this.remoteAddress, this.authenticationRoleLoggingAnonymizer.anonymize(this.authRole), this.authenticationRoleLoggingAnonymizer.anonymize(this.originalPrincipal), this.authMethod, clientVersion, clientProtoVersion, this.proxyVersion});
        } else {
            log.info("[{}] connected with role={} using authMethod={}, clientVersion={}, clientProtocolVersion={}, proxyVersion={}", new Object[]{this.remoteAddress, this.authenticationRoleLoggingAnonymizer.anonymize(this.authRole), this.authMethod, clientVersion, clientProtoVersion, this.proxyVersion});
        }
        if (this.brokerInterceptor != null) {
            this.brokerInterceptor.onConnectionCreated(this);
        }
    }

    private void doAuthentication(AuthData clientData, boolean useOriginalAuthState, int clientProtocolVersion, String clientVersion) {
        String authRole;
        AuthenticationState authState = useOriginalAuthState ? this.originalAuthState : this.authState;
        String string = authRole = useOriginalAuthState ? this.originalPrincipal : this.authRole;
        if (log.isDebugEnabled()) {
            log.debug("Authenticate using original auth state : {}, role = {}", (Object)useOriginalAuthState, (Object)authRole);
        }
        authState.authenticateAsync(clientData).whenCompleteAsync((authChallenge, throwable) -> {
            if (throwable == null) {
                this.authChallengeSuccessCallback((AuthData)authChallenge, useOriginalAuthState, authRole, clientProtocolVersion, clientVersion);
            } else {
                this.authenticationFailed((Throwable)throwable);
            }
        }, (Executor)this.ctx.executor());
    }

    public void authChallengeSuccessCallback(AuthData authChallenge, boolean useOriginalAuthState, String authRole, int clientProtocolVersion, String clientVersion) {
        try {
            if (authChallenge == null) {
                AuthenticationState authState = useOriginalAuthState ? this.originalAuthState : this.authState;
                String newAuthRole = authState.getAuthRole();
                AuthenticationDataSource newAuthDataSource = authState.getAuthDataSource();
                if (this.state != State.Connected) {
                    if (!useOriginalAuthState) {
                        this.authRole = newAuthRole;
                        this.authenticationData = newAuthDataSource;
                    }
                    if (this.originalAuthState != null) {
                        this.authenticateOriginalData(clientProtocolVersion, clientVersion);
                    } else {
                        this.completeConnect(clientProtocolVersion, clientVersion);
                    }
                } else {
                    if (!useOriginalAuthState) {
                        this.authenticationData = newAuthDataSource;
                    } else {
                        this.originalAuthData = newAuthDataSource;
                    }
                    if (!StringUtils.isEmpty((CharSequence)authRole)) {
                        if (!authRole.equals(newAuthRole)) {
                            log.warn("[{}] Principal cannot change during an authentication refresh expected={} got={}", new Object[]{this.remoteAddress, authRole, newAuthRole});
                            this.ctx.close();
                        } else {
                            log.info("[{}] Refreshed authentication credentials for role {}", (Object)this.remoteAddress, (Object)authRole);
                        }
                    }
                }
            } else {
                this.ctx.writeAndFlush((Object)Commands.newAuthChallenge((String)this.authMethod, (AuthData)authChallenge, (int)clientProtocolVersion));
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Authentication in progress client by method {}.", (Object)this.remoteAddress, (Object)this.authMethod);
                }
            }
        }
        catch (AssertionError | Exception e) {
            this.authenticationFailed((Throwable)e);
        }
    }

    private void authenticateOriginalData(int clientProtoVersion, String clientVersion) {
        this.originalAuthState.authenticateAsync(this.originalAuthDataCopy).whenCompleteAsync((authChallenge, throwable) -> {
            if (throwable != null) {
                this.authenticationFailed((Throwable)throwable);
            } else if (authChallenge != null) {
                this.authenticationFailed(new AuthenticationException("Failed to authenticate original auth data due to unsupported authChallenge."));
            } else {
                try {
                    this.originalAuthDataCopy = null;
                    this.originalAuthData = this.originalAuthState.getAuthDataSource();
                    this.originalPrincipal = this.originalAuthState.getAuthRole();
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Authenticated original role (forwarded from proxy): {}", (Object)this.remoteAddress, (Object)this.originalPrincipal);
                    }
                    this.completeConnect(clientProtoVersion, clientVersion);
                }
                catch (AssertionError | Exception e) {
                    this.authenticationFailed((Throwable)e);
                }
            }
        }, (Executor)this.ctx.executor());
    }

    private void authenticationFailed(Throwable t) {
        String operation;
        if (this.state == State.Connecting) {
            this.service.getPulsarStats().recordConnectionCreateFail();
            operation = "connect";
        } else {
            operation = "authentication-refresh";
        }
        this.state = State.Failed;
        ServerCnx.logAuthException(this.remoteAddress, operation, this.getPrincipal(), Optional.empty(), t);
        ByteBuf msg = Commands.newError((long)-1L, (ServerError)ServerError.AuthenticationError, (String)"Failed to authenticate");
        NettyChannelUtil.writeAndFlushWithClosePromise((ChannelOutboundInvoker)this.ctx, (ByteBuf)msg);
    }

    private void maybeScheduleAuthenticationCredentialsRefresh() {
        assert (this.ctx.executor().inEventLoop());
        assert (this.authRefreshTask == null);
        if (this.authState == null) {
            return;
        }
        this.authRefreshTask = this.ctx.executor().scheduleAtFixedRate(this::refreshAuthenticationCredentials, (long)this.service.getPulsar().getConfig().getAuthenticationRefreshCheckSeconds(), (long)this.service.getPulsar().getConfig().getAuthenticationRefreshCheckSeconds(), TimeUnit.SECONDS);
    }

    private void refreshAuthenticationCredentials() {
        AuthenticationState authState;
        assert (this.ctx.executor().inEventLoop());
        AuthenticationState authenticationState = authState = this.originalAuthState != null ? this.originalAuthState : this.authState;
        if (this.getState() == State.Failed) {
            return;
        }
        if (!authState.isExpired()) {
            return;
        }
        if (this.originalPrincipal != null && this.originalAuthState == null) {
            log.info("[{}] Cannot revalidate user credential when using proxy and not forwarding the credentials. Closing connection", (Object)this.remoteAddress);
            this.ctx.close();
            return;
        }
        if (!this.supportsAuthenticationRefresh()) {
            log.warn("[{}] Closing connection because client doesn't support auth credentials refresh", (Object)this.remoteAddress);
            this.ctx.close();
            return;
        }
        if (this.pendingAuthChallengeResponse) {
            log.warn("[{}] Closing connection after timeout on refreshing auth credentials", (Object)this.remoteAddress);
            this.ctx.close();
            return;
        }
        log.info("[{}] Refreshing authentication credentials for originalPrincipal {} and authRole {}", new Object[]{this.remoteAddress, this.originalPrincipal, this.authRole});
        try {
            AuthData brokerData = authState.refreshAuthentication();
            this.writeAndFlush(Commands.newAuthChallenge((String)this.authMethod, (AuthData)brokerData, (int)this.getRemoteEndpointProtocolVersion()));
            if (log.isDebugEnabled()) {
                log.debug("[{}] Sent auth challenge to client to refresh credentials with method: {}.", (Object)this.remoteAddress, (Object)this.authMethod);
            }
            this.pendingAuthChallengeResponse = true;
        }
        catch (AuthenticationException e) {
            log.warn("[{}] Failed to refresh authentication: {}", (Object)this.remoteAddress, (Object)e);
            this.ctx.close();
        }
    }

    protected void handleConnect(CommandConnect connect) {
        Preconditions.checkArgument((this.state == State.Start ? 1 : 0) != 0);
        if (log.isDebugEnabled()) {
            log.debug("Received CONNECT from {}, auth enabled: {}: has original principal = {}, original principal = {}", new Object[]{this.remoteAddress, this.service.isAuthenticationEnabled(), connect.hasOriginalPrincipal(), connect.hasOriginalPrincipal() ? connect.getOriginalPrincipal() : null});
        }
        if (!this.service.getPulsar().isRunning()) {
            if (log.isDebugEnabled()) {
                log.debug("Failed CONNECT from {} due to pulsar service is not ready: {} state", (Object)this.remoteAddress, (Object)this.service.getPulsar().getState().toString());
            }
            this.writeAndFlush(Commands.newError((long)-1L, (ServerError)ServerError.ServiceNotReady, (String)"Failed due to pulsar service is not ready"));
            this.close();
            return;
        }
        String clientVersion = connect.getClientVersion();
        int clientProtocolVersion = connect.getProtocolVersion();
        this.features = new FeatureFlags();
        if (connect.hasFeatureFlags()) {
            this.features.copyFrom(connect.getFeatureFlags());
        }
        if (connect.hasProxyVersion()) {
            this.proxyVersion = connect.getProxyVersion();
        }
        if (!this.service.isAuthenticationEnabled()) {
            this.completeConnect(clientProtocolVersion, clientVersion);
            return;
        }
        this.state = State.Connecting;
        try {
            byte[] authData = connect.hasAuthData() ? connect.getAuthData() : emptyArray;
            AuthData clientData = AuthData.of((byte[])authData);
            this.authMethod = connect.hasAuthMethodName() ? connect.getAuthMethodName() : (connect.hasAuthMethod() ? connect.getAuthMethod().name().substring(10).toLowerCase() : "none");
            this.authenticationProvider = this.getBrokerService().getAuthenticationService().getAuthenticationProvider(this.authMethod);
            if (this.authenticationProvider == null) {
                this.authRole = (String)this.getBrokerService().getAuthenticationService().getAnonymousUserRole().orElseThrow(() -> new AuthenticationException("No anonymous role, and no authentication provider configured"));
                this.completeConnect(clientProtocolVersion, clientVersion);
                return;
            }
            ChannelHandler sslHandler = this.ctx.channel().pipeline().get("tls");
            SSLSession sslSession = null;
            if (sslHandler != null) {
                sslSession = ((SslHandler)sslHandler).engine().getSession();
            }
            this.authState = this.authenticationProvider.newAuthState(clientData, this.remoteAddress, sslSession);
            if (log.isDebugEnabled()) {
                String role = "";
                role = this.authState != null && this.authState.isComplete() ? this.authState.getAuthRole() : "authentication incomplete or null";
                log.debug("[{}] Authenticate role : {}", (Object)this.remoteAddress, (Object)role);
            }
            if (connect.hasOriginalPrincipal() && this.service.getPulsar().getConfig().isAuthenticateOriginalAuthData() && !"__websocket_dummy_original_principle".equals(connect.getOriginalPrincipal())) {
                String originalAuthMethod = connect.hasOriginalAuthMethod() ? connect.getOriginalAuthMethod() : "none";
                AuthenticationProvider originalAuthenticationProvider = this.getBrokerService().getAuthenticationService().getAuthenticationProvider(originalAuthMethod);
                if (originalAuthenticationProvider == null) {
                    this.originalPrincipal = this.authRole = (String)this.getBrokerService().getAuthenticationService().getAnonymousUserRole().orElseThrow(() -> new AuthenticationException("No anonymous role, and can't find AuthenticationProvider for original role using auth method [" + originalAuthMethod + "] is not available"));
                    this.completeConnect(clientProtocolVersion, clientVersion);
                    return;
                }
                this.originalAuthDataCopy = AuthData.of((byte[])connect.getOriginalAuthData().getBytes());
                this.originalAuthState = originalAuthenticationProvider.newAuthState(this.originalAuthDataCopy, this.remoteAddress, sslSession);
            } else if (connect.hasOriginalPrincipal()) {
                this.originalPrincipal = connect.getOriginalPrincipal();
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Setting original role (forwarded from proxy): {}", (Object)this.remoteAddress, (Object)this.originalPrincipal);
                }
            }
            this.doAuthentication(clientData, false, clientProtocolVersion, clientVersion);
        }
        catch (Exception e) {
            this.authenticationFailed(e);
        }
    }

    protected void handleAuthResponse(CommandAuthResponse authResponse) {
        Preconditions.checkArgument((boolean)authResponse.hasResponse());
        Preconditions.checkArgument((authResponse.getResponse().hasAuthData() && authResponse.getResponse().hasAuthMethodName() ? 1 : 0) != 0);
        this.pendingAuthChallengeResponse = false;
        if (log.isDebugEnabled()) {
            log.debug("Received AuthResponse from {}, auth method: {}", (Object)this.remoteAddress, (Object)authResponse.getResponse().getAuthMethodName());
        }
        try {
            AuthData clientData = AuthData.of((byte[])authResponse.getResponse().getAuthData());
            this.doAuthentication(clientData, this.originalAuthState != null, authResponse.getProtocolVersion(), authResponse.hasClientVersion() ? authResponse.getClientVersion() : "");
        }
        catch (Exception e) {
            this.authenticationFailed(e);
        }
    }

    protected void handleSubscribe(CommandSubscribe subscribe) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        long requestId = subscribe.getRequestId();
        long consumerId = subscribe.getConsumerId();
        TopicName topicName = this.validateTopicName(subscribe.getTopic(), requestId, subscribe);
        if (topicName == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Handle subscribe command: auth role = {}, original auth role = {}", new Object[]{this.remoteAddress, this.authenticationRoleLoggingAnonymizer.anonymize(this.authRole), this.authenticationRoleLoggingAnonymizer.anonymize(this.originalPrincipal)});
        }
        String subscriptionName = subscribe.getSubscription();
        CommandSubscribe.SubType subType = subscribe.getSubType();
        String consumerName = subscribe.hasConsumerName() ? subscribe.getConsumerName() : "";
        boolean isDurable = subscribe.isDurable();
        BatchMessageIdImpl startMessageId = subscribe.hasStartMessageId() ? new BatchMessageIdImpl(subscribe.getStartMessageId().getLedgerId(), subscribe.getStartMessageId().getEntryId(), subscribe.getStartMessageId().getPartition(), subscribe.getStartMessageId().getBatchIndex()) : null;
        int priorityLevel = subscribe.hasPriorityLevel() ? subscribe.getPriorityLevel() : 0;
        boolean readCompacted = subscribe.hasReadCompacted() && subscribe.isReadCompacted();
        Map metadata = CommandUtils.metadataFromCommand((CommandSubscribe)subscribe);
        CommandSubscribe.InitialPosition initialPosition = subscribe.getInitialPosition();
        long startMessageRollbackDurationSec = subscribe.hasStartMessageRollbackDurationSec() ? subscribe.getStartMessageRollbackDurationSec() : -1L;
        SchemaData schema = subscribe.hasSchema() ? this.getSchema(subscribe.getSchema()) : null;
        Boolean isReplicated = subscribe.hasReplicateSubscriptionState() ? Boolean.valueOf(subscribe.isReplicateSubscriptionState()) : null;
        boolean forceTopicCreation = subscribe.isForceTopicCreation();
        KeySharedMeta keySharedMeta = subscribe.hasKeySharedMeta() ? new KeySharedMeta().copyFrom(subscribe.getKeySharedMeta()) : emptyKeySharedMeta;
        long consumerEpoch = subscribe.hasConsumerEpoch() ? subscribe.getConsumerEpoch() : -1L;
        Optional<Map<String, String>> subscriptionProperties = SubscriptionOption.getPropertiesMap(subscribe.getSubscriptionPropertiesList());
        if (log.isDebugEnabled()) {
            log.debug("Topic name = {}, subscription name = {}, schema is {}", new Object[]{topicName, subscriptionName, schema == null ? "absent" : "present"});
        }
        CompletableFuture<Boolean> isAuthorizedFuture = this.isTopicOperationAllowed(topicName, subscriptionName, TopicOperation.CONSUME);
        CompletableFuture consumerFuture = new CompletableFuture();
        CompletableFuture existingConsumerFuture = (CompletableFuture)this.consumers.putIfAbsent(consumerId, consumerFuture);
        ((CompletableFuture)isAuthorizedFuture.thenApply(arg_0 -> this.lambda$handleSubscribe$24(topicName, subscriptionName, consumerId, metadata, consumerFuture, requestId, existingConsumerFuture, forceTopicCreation, isDurable, subType, priorityLevel, consumerName, (MessageIdImpl)startMessageId, readCompacted, initialPosition, startMessageRollbackDurationSec, isReplicated, keySharedMeta, subscriptionProperties, consumerEpoch, schema, arg_0))).exceptionally(ex -> {
            ServerCnx.logAuthException(this.remoteAddress, "subscribe", this.getPrincipal(), Optional.of(topicName), ex);
            this.consumers.remove(consumerId, (Object)consumerFuture);
            this.commandSender.sendErrorResponse(requestId, ServerError.AuthorizationError, ex.getMessage());
            return null;
        });
    }

    private SchemaData getSchema(Schema protocolSchema) {
        return SchemaData.builder().data(protocolSchema.getSchemaData()).isDeleted(false).timestamp(System.currentTimeMillis()).user(Strings.nullToEmpty((String)this.originalPrincipal)).type(Commands.getSchemaType((Schema.Type)protocolSchema.getType())).props(protocolSchema.getPropertiesList().stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue))).build();
    }

    protected void handleProducer(CommandProducer cmdProducer) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        long producerId = cmdProducer.getProducerId();
        long requestId = cmdProducer.getRequestId();
        String producerName = cmdProducer.hasProducerName() ? cmdProducer.getProducerName() : this.service.generateUniqueProducerName();
        long epoch = cmdProducer.getEpoch();
        boolean userProvidedProducerName = cmdProducer.isUserProvidedProducerName();
        boolean isEncrypted = cmdProducer.isEncrypted();
        Map metadata = CommandUtils.metadataFromCommand((CommandProducer)cmdProducer);
        SchemaData schema = cmdProducer.hasSchema() ? this.getSchema(cmdProducer.getSchema()) : null;
        ProducerAccessMode producerAccessMode = cmdProducer.getProducerAccessMode();
        Optional topicEpoch = cmdProducer.hasTopicEpoch() ? Optional.of(cmdProducer.getTopicEpoch()) : Optional.empty();
        boolean isTxnEnabled = cmdProducer.isTxnEnabled();
        String initialSubscriptionName = cmdProducer.hasInitialSubscriptionName() ? cmdProducer.getInitialSubscriptionName() : null;
        boolean supportsPartialProducer = this.supportsPartialProducer();
        TopicName topicName = this.validateTopicName(cmdProducer.getTopic(), requestId, cmdProducer);
        if (topicName == null) {
            return;
        }
        CompletionStage<Boolean> isAuthorizedFuture = this.isTopicOperationAllowed(topicName, TopicOperation.PRODUCE, this.authenticationData, this.originalAuthData);
        if (!Strings.isNullOrEmpty((String)initialSubscriptionName)) {
            isAuthorizedFuture = isAuthorizedFuture.thenCombine(this.isTopicOperationAllowed(topicName, initialSubscriptionName, TopicOperation.SUBSCRIBE), (canProduce, canSubscribe) -> canProduce != false && canSubscribe != false);
        }
        ((CompletableFuture)isAuthorizedFuture.thenApply(isAuthorized -> {
            CompletableFuture producerFuture;
            CompletableFuture existingProducerFuture;
            if (!isAuthorized.booleanValue()) {
                String msg = "Client is not authorized to Produce";
                log.warn("[{}] {} with role {}", new Object[]{this.remoteAddress, msg, this.getPrincipal()});
                this.writeAndFlush(Commands.newError((long)requestId, (ServerError)ServerError.AuthorizationError, (String)msg));
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] Client is authorized to Produce with role {}", (Object)this.remoteAddress, (Object)this.getPrincipal());
            }
            if ((existingProducerFuture = (CompletableFuture)this.producers.putIfAbsent(producerId, producerFuture = new CompletableFuture())) != null) {
                if (!existingProducerFuture.isDone()) {
                    log.warn("[{}][{}] Producer with id is already present on the connection, producerId={}", new Object[]{this.remoteAddress, topicName, producerId});
                    this.commandSender.sendErrorResponse(requestId, ServerError.ServiceNotReady, "Producer is already present on the connection");
                } else if (existingProducerFuture.isCompletedExceptionally()) {
                    log.warn("[{}][{}] Producer with id is failed to register present on the connection, producerId={}", new Object[]{this.remoteAddress, topicName, producerId});
                    ServerError error = this.getErrorCode(existingProducerFuture);
                    this.producers.remove(producerId, (Object)existingProducerFuture);
                    this.commandSender.sendErrorResponse(requestId, error, "Producer is already failed to register present on the connection");
                } else {
                    Producer producer = existingProducerFuture.getNow(null);
                    log.info("[{}] [{}] Producer with the same id is already created: producerId={}, producer={}", new Object[]{this.remoteAddress, topicName, producerId, producer});
                    this.commandSender.sendProducerSuccessResponse(requestId, producer.getProducerName(), producer.getSchemaVersion());
                }
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Creating producer. producerId={}, producerName={}, schema is {}", new Object[]{this.remoteAddress, topicName, producerId, producerName, schema == null ? "absent" : "present"});
            }
            ((CompletableFuture)this.service.getOrCreateTopic(topicName.toString()).thenCompose(topic -> {
                if (((AbstractTopic)topic).isProducersExceeded(producerName)) {
                    log.warn("[{}] Attempting to add producer to topic which reached max producers limit", topic);
                    String errorMsg = "Topic '" + topicName.toString() + "' reached max producers limit";
                    BrokerServiceException.ProducerBusyException t = new BrokerServiceException.ProducerBusyException(errorMsg);
                    return CompletableFuture.failedFuture(t);
                }
                CompletableFuture<Void> backlogQuotaCheckFuture = CompletableFuture.allOf(topic.checkBacklogQuotaExceeded(producerName, BacklogQuota.BacklogQuotaType.destination_storage), topic.checkBacklogQuotaExceeded(producerName, BacklogQuota.BacklogQuotaType.message_age));
                backlogQuotaCheckFuture.thenRun(() -> {
                    if ((topic.isEncryptionRequired() || this.encryptionRequireOnProducer) && !isEncrypted && !SystemTopicNames.isSystemTopic((TopicName)topicName)) {
                        String msg = String.format("Encryption is required in %s", topicName);
                        log.warn("[{}] {}", (Object)this.remoteAddress, (Object)msg);
                        if (producerFuture.completeExceptionally(new BrokerServiceException.ServerMetadataException(msg))) {
                            this.commandSender.sendErrorResponse(requestId, ServerError.MetadataError, msg);
                        }
                        this.producers.remove(producerId, (Object)producerFuture);
                        return;
                    }
                    this.disableTcpNoDelayIfNeeded(topicName.toString(), producerName);
                    CompletableFuture<SchemaVersion> schemaVersionFuture = this.tryAddSchema((Topic)topic, schema);
                    schemaVersionFuture.exceptionally(exception -> {
                        Throwable cause;
                        if (producerFuture.completeExceptionally((Throwable)exception)) {
                            Object message = exception.getMessage();
                            if (exception.getCause() != null) {
                                message = (String)message + " caused by " + String.valueOf(exception.getCause());
                            }
                            this.commandSender.sendErrorResponse(requestId, BrokerServiceException.getClientErrorCode(exception), (String)message);
                        }
                        if (!((cause = FutureUtil.unwrapCompletionException((Throwable)exception)) instanceof IncompatibleSchemaException)) {
                            log.error("Try add schema failed, remote address {}, topic {}, producerId {}", new Object[]{this.remoteAddress, topicName, producerId, exception});
                        }
                        this.producers.remove(producerId, (Object)producerFuture);
                        return null;
                    });
                    schemaVersionFuture.thenAccept(schemaVersion -> {
                        CompletionStage<Object> createInitSubFuture = !Strings.isNullOrEmpty((String)initialSubscriptionName) && topic.isPersistent() && !topic.getSubscriptions().containsKey(initialSubscriptionName) ? this.service.isAllowAutoSubscriptionCreationAsync(topicName).thenCompose(isAllowAutoSubscriptionCreation -> {
                            if (!isAllowAutoSubscriptionCreation.booleanValue()) {
                                return CompletableFuture.failedFuture(new BrokerServiceException.NotAllowedException("Could not create the initial subscription due to the auto subscription creation is not allowed."));
                            }
                            return topic.createSubscription(initialSubscriptionName, CommandSubscribe.InitialPosition.Earliest, false, null);
                        }) : CompletableFuture.completedFuture(null);
                        createInitSubFuture.whenComplete((sub, ex) -> {
                            if (ex != null) {
                                Throwable rc = FutureUtil.unwrapCompletionException((Throwable)ex);
                                if (rc instanceof BrokerServiceException.NotAllowedException) {
                                    log.warn("[{}] {} initialSubscriptionName: {}, topic: {}", new Object[]{this.remoteAddress, rc.getMessage(), initialSubscriptionName, topicName});
                                    if (producerFuture.completeExceptionally(rc)) {
                                        this.commandSender.sendErrorResponse(requestId, ServerError.NotAllowedError, rc.getMessage());
                                    }
                                    this.producers.remove(producerId, (Object)producerFuture);
                                    return;
                                }
                                String msg = "Failed to create the initial subscription: " + ex.getCause().getMessage();
                                log.warn("[{}] {} initialSubscriptionName: {}, topic: {}", new Object[]{this.remoteAddress, msg, initialSubscriptionName, topicName});
                                if (producerFuture.completeExceptionally((Throwable)ex)) {
                                    this.commandSender.sendErrorResponse(requestId, BrokerServiceException.getClientErrorCode(ex), msg);
                                }
                                this.producers.remove(producerId, (Object)producerFuture);
                                return;
                            }
                            this.buildProducerAndAddTopic((Topic)topic, producerId, producerName, requestId, isEncrypted, metadata, (SchemaVersion)schemaVersion, epoch, userProvidedProducerName, topicName, producerAccessMode, topicEpoch, supportsPartialProducer, producerFuture);
                        });
                    });
                });
                return backlogQuotaCheckFuture;
            })).exceptionally(exception -> {
                Optional<ClusterPolicies.ClusterUrl> clusterURL;
                Throwable cause = exception.getCause();
                if (cause instanceof BrokerServiceException.TopicBacklogQuotaExceededException) {
                    BrokerServiceException.TopicBacklogQuotaExceededException tbqe = (BrokerServiceException.TopicBacklogQuotaExceededException)cause;
                    IllegalStateException illegalStateException = new IllegalStateException(tbqe);
                    BacklogQuota.RetentionPolicy retentionPolicy = tbqe.getRetentionPolicy();
                    if (producerFuture.completeExceptionally(illegalStateException)) {
                        if (retentionPolicy == BacklogQuota.RetentionPolicy.producer_request_hold) {
                            this.commandSender.sendErrorResponse(requestId, ServerError.ProducerBlockedQuotaExceededError, illegalStateException.getMessage());
                        } else if (retentionPolicy == BacklogQuota.RetentionPolicy.producer_exception) {
                            this.commandSender.sendErrorResponse(requestId, ServerError.ProducerBlockedQuotaExceededException, illegalStateException.getMessage());
                        }
                    }
                    this.producers.remove(producerId, (Object)producerFuture);
                    return null;
                }
                if (cause instanceof BrokerServiceException.TopicMigratedException && (clusterURL = PersistentTopic.getMigratedClusterUrl(this.service.getPulsar(), topicName.toString())).isPresent()) {
                    log.info("[{}] redirect migrated producer to topic {}: producerId={}, producerName = {}, {}", new Object[]{this.remoteAddress, topicName, producerId, producerName, cause.getMessage()});
                    boolean msgSent = this.commandSender.sendTopicMigrated(CommandTopicMigrated.ResourceType.Producer, producerId, clusterURL.get().getBrokerServiceUrl(), clusterURL.get().getBrokerServiceUrlTls());
                    if (!msgSent) {
                        log.info("client doesn't support topic migration handling {}-{}-{}", new Object[]{topicName, this.remoteAddress, producerId});
                    }
                    this.producers.remove(producerId, (Object)producerFuture);
                    this.closeProducer(producerId, -1L, Optional.empty());
                    return null;
                }
                if (cause instanceof NoSuchElementException) {
                    cause = new BrokerServiceException.TopicNotFoundException(String.format("Topic not found %s", topicName.toString()));
                    log.warn("[{}] Failed to load topic {}, producerId={}: Topic not found", new Object[]{this.remoteAddress, topicName, producerId});
                } else if (!Exceptions.areExceptionsPresentInChain((Throwable)cause, (Class[])new Class[]{BrokerServiceException.ServiceUnitNotReadyException.class, ManagedLedgerException.class, BrokerServiceException.ProducerBusyException.class})) {
                    log.error("[{}] Failed to create topic {}, producerId={}", new Object[]{this.remoteAddress, topicName, producerId, exception});
                }
                if (producerFuture.completeExceptionally((Throwable)exception)) {
                    this.commandSender.sendErrorResponse(requestId, BrokerServiceException.getClientErrorCode(cause), cause.getMessage());
                }
                this.producers.remove(producerId, (Object)producerFuture);
                return null;
            });
            return null;
        })).exceptionally(ex -> {
            ServerCnx.logAuthException(this.remoteAddress, "producer", this.getPrincipal(), Optional.of(topicName), ex);
            this.commandSender.sendErrorResponse(requestId, ServerError.AuthorizationError, ex.getMessage());
            return null;
        });
    }

    private void buildProducerAndAddTopic(Topic topic, long producerId, String producerName, long requestId, boolean isEncrypted, Map<String, String> metadata, SchemaVersion schemaVersion, long epoch, boolean userProvidedProducerName, TopicName topicName, ProducerAccessMode producerAccessMode, Optional<Long> topicEpoch, boolean supportsPartialProducer, CompletableFuture<Producer> producerFuture) {
        CompletableFuture<Void> producerQueuedFuture = new CompletableFuture<Void>();
        Producer producer = new Producer(topic, this, producerId, producerName, this.getPrincipal(), isEncrypted, metadata, schemaVersion, epoch, userProvidedProducerName, producerAccessMode, topicEpoch, supportsPartialProducer);
        ((CompletableFuture)topic.addProducer(producer, producerQueuedFuture).thenAccept(newTopicEpoch -> {
            if (this.isActive()) {
                if (producerFuture.complete(producer)) {
                    log.info("[{}] Created new producer: {}, role: {}", new Object[]{this.remoteAddress, producer, this.getPrincipal()});
                    this.commandSender.sendProducerSuccessResponse(requestId, producerName, producer.getLastSequenceId(), producer.getSchemaVersion(), (Optional<Long>)newTopicEpoch, true);
                    if (this.brokerInterceptor != null) {
                        try {
                            this.brokerInterceptor.producerCreated(this, producer, metadata);
                        }
                        catch (Throwable t) {
                            log.error("Exception occur when intercept producer created.", t);
                        }
                    }
                    return;
                }
                producer.closeNow(true);
                log.info("[{}] Cleared producer created after timeout on client side {}", (Object)this.remoteAddress, (Object)producer);
            } else {
                producer.closeNow(true);
                log.info("[{}] Cleared producer created after connection was closed: {}", (Object)this.remoteAddress, (Object)producer);
                producerFuture.completeExceptionally(new IllegalStateException("Producer created after connection was closed"));
            }
            this.producers.remove(producerId, (Object)producerFuture);
        })).exceptionallyAsync(ex -> {
            block10: {
                if (ex.getCause() instanceof BrokerServiceException.TopicMigratedException) {
                    Optional<ClusterPolicies.ClusterUrl> clusterURL = PersistentTopic.getMigratedClusterUrl(this.service.getPulsar(), topic.getName());
                    if (clusterURL.isPresent()) {
                        if (!topic.shouldProducerMigrate()) {
                            log.info("Topic {} is migrated but replication backlog exist: producerId = {}, producerName = {}, {}", new Object[]{topicName, producerId, producerName, ex.getCause().getMessage()});
                            break block10;
                        } else {
                            log.info("[{}] redirect migrated producer to topic {}: producerId={}, producerName = {}, {}", new Object[]{this.remoteAddress, topicName, producerId, producerName, ex.getCause().getMessage()});
                            boolean msgSent = this.commandSender.sendTopicMigrated(CommandTopicMigrated.ResourceType.Producer, producerId, clusterURL.get().getBrokerServiceUrl(), clusterURL.get().getBrokerServiceUrlTls());
                            if (!msgSent) {
                                log.info("client doesn't support topic migration handling {}-{}-{}", new Object[]{topic, this.remoteAddress, producerId});
                            }
                            this.closeProducer(producer);
                            return null;
                        }
                    }
                    log.warn("[{}] failed producer because migration url not configured topic {}: producerId={}, {}", new Object[]{this.remoteAddress, topicName, producerId, ex.getCause().getMessage()});
                } else if (ex.getCause() instanceof BrokerServiceException.ProducerFencedException) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Failed to add producer to topic {}: producerId={}, {}", new Object[]{this.remoteAddress, topicName, producerId, ex.getCause().getMessage()});
                    }
                } else {
                    log.warn("[{}] Failed to add producer to topic {}: producerId={}, {}", new Object[]{this.remoteAddress, topicName, producerId, ex.getCause().getMessage()});
                }
            }
            producer.closeNow(true);
            if (producerFuture.completeExceptionally((Throwable)ex)) {
                this.commandSender.sendErrorResponse(requestId, BrokerServiceException.getClientErrorCode(ex), ex.getMessage());
            }
            return null;
        }, (Executor)this.ctx.executor());
        producerQueuedFuture.thenRun(() -> {
            if (this.isActive()) {
                log.info("[{}] Producer is waiting in queue: {}", (Object)this.remoteAddress, (Object)producer);
                this.commandSender.sendProducerSuccessResponse(requestId, producerName, producer.getLastSequenceId(), producer.getSchemaVersion(), Optional.empty(), false);
                if (this.brokerInterceptor != null) {
                    this.brokerInterceptor.producerCreated(this, producer, metadata);
                }
            }
        });
    }

    protected void handleSend(CommandSend send, ByteBuf headersAndPayload) {
        Position position;
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        CompletableFuture producerFuture = (CompletableFuture)this.producers.get(send.getProducerId());
        if (producerFuture == null || !producerFuture.isDone() || producerFuture.isCompletedExceptionally()) {
            if (this.recentlyClosedProducers.containsKey(send.getProducerId())) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Received message, but the producer was recently closed : {}. Ignoring message.", (Object)this.remoteAddress, (Object)send.getProducerId());
                }
                return;
            }
            log.warn("[{}] Received message, but the producer is not ready : {}. Closing the connection.", (Object)this.remoteAddress, (Object)send.getProducerId());
            this.close();
            return;
        }
        Producer producer = producerFuture.getNow(null);
        if (log.isDebugEnabled()) {
            this.printSendCommandDebug(send, headersAndPayload);
        }
        if (producer.getTopic().isTransferring()) {
            PulsarService pulsar = this.getBrokerService().pulsar();
            int ignoredMsgCount = send.getNumMessages();
            long ignoredSendMsgTotalCount = ExtensibleLoadManagerImpl.get(pulsar).getIgnoredSendMsgCount().addAndGet(ignoredMsgCount);
            if (log.isDebugEnabled()) {
                log.debug("Ignoring {} messages from:{}:{} to fenced topic:{} while transferring. Total ignored message count: {}.", new Object[]{ignoredMsgCount, this.remoteAddress, send.getProducerId(), producer.getTopic().getName(), ignoredSendMsgTotalCount});
            }
            return;
        }
        if (producer.isNonPersistentTopic()) {
            if (this.nonPersistentPendingMessages > this.maxNonPersistentPendingMessages) {
                long producerId = send.getProducerId();
                long sequenceId = send.getSequenceId();
                long highestSequenceId = send.getHighestSequenceId();
                this.service.getTopicOrderedExecutor().executeOrdered((Object)producer.getTopic().getName(), () -> this.commandSender.sendSendReceiptResponse(producerId, sequenceId, highestSequenceId, -1L, -1L));
                producer.recordMessageDrop(send.getNumMessages());
                return;
            }
            ++this.nonPersistentPendingMessages;
        }
        this.increasePendingSendRequestsAndPublishBytes(headersAndPayload.readableBytes());
        if (send.hasTxnidMostBits() && send.hasTxnidLeastBits()) {
            TxnID txnID = new TxnID(send.getTxnidMostBits(), send.getTxnidLeastBits());
            producer.publishTxnMessage(txnID, producer.getProducerId(), send.getSequenceId(), send.getHighestSequenceId(), headersAndPayload, send.getNumMessages(), send.isIsChunk(), send.isMarker());
            return;
        }
        Position position2 = position = send.hasMessageId() ? PositionFactory.create((long)send.getMessageId().getLedgerId(), (long)send.getMessageId().getEntryId()) : null;
        if (send.hasHighestSequenceId() && send.getSequenceId() <= send.getHighestSequenceId()) {
            producer.publishMessage(send.getProducerId(), send.getSequenceId(), send.getHighestSequenceId(), headersAndPayload, send.getNumMessages(), send.isIsChunk(), send.isMarker(), position);
        } else {
            producer.publishMessage(send.getProducerId(), send.getSequenceId(), headersAndPayload, send.getNumMessages(), send.isIsChunk(), send.isMarker(), position);
        }
    }

    private void printSendCommandDebug(CommandSend send, ByteBuf headersAndPayload) {
        headersAndPayload.markReaderIndex();
        MessageMetadata msgMetadata = Commands.parseMessageMetadata((ByteBuf)headersAndPayload);
        headersAndPayload.resetReaderIndex();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Received send message request. producer: {}:{} {}:{} size: {}, partition key is: {}, ordering key is {}, uncompressedSize is {}", new Object[]{this.remoteAddress, send.getProducerId(), send.getSequenceId(), msgMetadata.getProducerName(), msgMetadata.getSequenceId(), headersAndPayload.readableBytes(), msgMetadata.hasPartitionKey() ? msgMetadata.getPartitionKey() : null, msgMetadata.hasOrderingKey() ? msgMetadata.getOrderingKey() : null, msgMetadata.getUncompressedSize()});
        }
    }

    protected void handleAck(CommandAck ack) {
        CommandAck copyOfAckForInterceptor;
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        CompletableFuture consumerFuture = (CompletableFuture)this.consumers.get(ack.getConsumerId());
        boolean hasRequestId = ack.hasRequestId();
        long requestId = hasRequestId ? ack.getRequestId() : 0L;
        long consumerId = ack.getConsumerId();
        CommandAck commandAck = copyOfAckForInterceptor = this.brokerInterceptor != null ? new CommandAck().copyFrom(ack) : null;
        if (consumerFuture != null && consumerFuture.isDone() && !consumerFuture.isCompletedExceptionally()) {
            Consumer consumer = consumerFuture.getNow(null);
            Subscription subscription = consumer.getSubscription();
            if (subscription.getTopic().isTransferring()) {
                PulsarService pulsar = this.getBrokerService().getPulsar();
                int ignoredAckCount = ack.getMessageIdsCount();
                long ignoredAckTotalCount = ExtensibleLoadManagerImpl.get(pulsar).getIgnoredAckCount().addAndGet(ignoredAckCount);
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] Ignoring {} message acks during topic transfer. Total ignored ack count: {}", new Object[]{subscription, consumerId, ignoredAckCount, ignoredAckTotalCount});
                }
                return;
            }
            ((CompletableFuture)consumer.messageAcked(ack).thenRun(() -> {
                if (hasRequestId) {
                    this.writeAndFlush(Commands.newAckResponse((long)requestId, null, null, (long)consumerId));
                }
                if (this.brokerInterceptor != null) {
                    try {
                        this.brokerInterceptor.messageAcked(this, consumer, copyOfAckForInterceptor);
                    }
                    catch (Throwable t) {
                        log.error("Exception occur when intercept message acked.", t);
                    }
                }
            })).exceptionally(e -> {
                if (hasRequestId) {
                    this.writeAndFlush(Commands.newAckResponse((long)requestId, (ServerError)BrokerServiceException.getClientErrorCode(e), (String)e.getMessage(), (long)consumerId));
                }
                return null;
            });
        } else if (log.isDebugEnabled()) {
            log.debug("Consumer future is not complete(not complete or error), but received command ack. so discard this command. consumerId: {}, cnx: {}, messageIdCount: {}", new Object[]{ack.getConsumerId(), this.toString(), ack.getMessageIdsCount()});
        }
    }

    protected void handleFlow(CommandFlow flow) {
        CompletableFuture consumerFuture;
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        if (log.isDebugEnabled()) {
            log.debug("[{}] Received flow from consumer {} permits: {}", new Object[]{this.remoteAddress, flow.getConsumerId(), flow.getMessagePermits()});
        }
        if ((consumerFuture = (CompletableFuture)this.consumers.get(flow.getConsumerId())) != null && consumerFuture.isDone() && !consumerFuture.isCompletedExceptionally()) {
            Consumer consumer = consumerFuture.getNow(null);
            if (consumer != null) {
                consumer.flowPermits(flow.getMessagePermits());
            } else {
                log.info("[{}] Couldn't find consumer {}", (Object)this.remoteAddress, (Object)flow.getConsumerId());
            }
        }
    }

    protected void handleRedeliverUnacknowledged(CommandRedeliverUnacknowledgedMessages redeliver) {
        CompletableFuture consumerFuture;
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        if (log.isDebugEnabled()) {
            log.debug("[{}] redeliverUnacknowledged from consumer {}, consumerEpoch {}", new Object[]{this.remoteAddress, redeliver.getConsumerId(), redeliver.hasConsumerEpoch() ? Long.valueOf(redeliver.getConsumerEpoch()) : null});
        }
        if ((consumerFuture = (CompletableFuture)this.consumers.get(redeliver.getConsumerId())) != null && consumerFuture.isDone() && !consumerFuture.isCompletedExceptionally()) {
            Consumer consumer = consumerFuture.getNow(null);
            if (redeliver.getMessageIdsCount() > 0 && Subscription.isIndividualAckMode(consumer.subType())) {
                consumer.redeliverUnacknowledgedMessages(redeliver.getMessageIdsList());
            } else if (redeliver.hasConsumerEpoch()) {
                consumer.redeliverUnacknowledgedMessages(redeliver.getConsumerEpoch());
            } else {
                consumer.redeliverUnacknowledgedMessages(-1L);
            }
        }
    }

    protected void handleUnsubscribe(CommandUnsubscribe unsubscribe) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        CompletableFuture consumerFuture = (CompletableFuture)this.consumers.get(unsubscribe.getConsumerId());
        if (consumerFuture != null && consumerFuture.isDone() && !consumerFuture.isCompletedExceptionally()) {
            ((Consumer)consumerFuture.getNow(null)).doUnsubscribe(unsubscribe.getRequestId(), unsubscribe.isForce());
        } else {
            this.commandSender.sendErrorResponse(unsubscribe.getRequestId(), ServerError.MetadataError, "Consumer not found");
        }
    }

    protected void handleSeek(CommandSeek seek) {
        boolean consumerCreated;
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        long requestId = seek.getRequestId();
        CompletableFuture consumerFuture = (CompletableFuture)this.consumers.get(seek.getConsumerId());
        if (!seek.hasMessageId() && !seek.hasMessagePublishTime()) {
            this.commandSender.sendErrorResponse(requestId, ServerError.MetadataError, "Message id and message publish time were not present");
            return;
        }
        boolean bl = consumerCreated = consumerFuture != null && consumerFuture.isDone() && !consumerFuture.isCompletedExceptionally();
        if (consumerCreated && seek.hasMessageId()) {
            Consumer consumer = consumerFuture.getNow(null);
            Subscription subscription = consumer.getSubscription();
            MessageIdData msgIdData = seek.getMessageId();
            long[] ackSet = null;
            if (msgIdData.getAckSetsCount() > 0) {
                ackSet = new long[msgIdData.getAckSetsCount()];
                for (int i = 0; i < ackSet.length; ++i) {
                    ackSet[i] = msgIdData.getAckSetAt(i);
                }
            }
            Position position = AckSetStateUtil.createPositionWithAckSet((long)msgIdData.getLedgerId(), (long)msgIdData.getEntryId(), (long[])ackSet);
            ((CompletableFuture)subscription.resetCursor(position).thenRun(() -> {
                log.info("[{}] [{}][{}] Reset subscription to message id {}", new Object[]{this.remoteAddress, subscription.getTopic().getName(), subscription.getName(), position});
                this.commandSender.sendSuccessResponse(requestId);
            })).exceptionally(ex -> {
                log.warn("[{}][{}] Failed to reset subscription: {}", new Object[]{this.remoteAddress, subscription, ex.getMessage(), ex});
                this.commandSender.sendErrorResponse(requestId, ServerError.UnknownError, "Error when resetting subscription: " + ex.getCause().getMessage());
                return null;
            });
        } else if (consumerCreated && seek.hasMessagePublishTime()) {
            Consumer consumer = consumerFuture.getNow(null);
            Subscription subscription = consumer.getSubscription();
            long timestamp = seek.getMessagePublishTime();
            ((CompletableFuture)subscription.resetCursor(timestamp).thenRun(() -> {
                log.info("[{}] [{}][{}] Reset subscription to publish time {}", new Object[]{this.remoteAddress, subscription.getTopic().getName(), subscription.getName(), timestamp});
                this.commandSender.sendSuccessResponse(requestId);
            })).exceptionally(ex -> {
                log.warn("[{}][{}] Failed to reset subscription: {}", new Object[]{this.remoteAddress, subscription, ex.getMessage(), ex});
                this.commandSender.sendErrorResponse(requestId, ServerError.UnknownError, "Reset subscription to publish time error: " + ex.getCause().getMessage());
                return null;
            });
        } else {
            this.commandSender.sendErrorResponse(requestId, ServerError.MetadataError, "Consumer not found");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerCnx other = (ServerCnx)o;
        return Objects.equals(this.ctx().channel().id(), other.ctx().channel().id());
    }

    public int hashCode() {
        return Objects.hash(this.ctx().channel().id());
    }

    protected void handleCloseProducer(CommandCloseProducer closeProducer) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        long producerId = closeProducer.getProducerId();
        long requestId = closeProducer.getRequestId();
        CompletableFuture producerFuture = (CompletableFuture)this.producers.get(producerId);
        if (producerFuture == null) {
            log.info("[{}] Producer {} was not registered on the connection", (Object)this.remoteAddress, (Object)producerId);
            this.writeAndFlush(Commands.newSuccess((long)requestId));
            return;
        }
        if (!producerFuture.isDone() && producerFuture.completeExceptionally(new IllegalStateException("Closed producer before creation was complete"))) {
            log.info("[{}] Closed producer before its creation was completed. producerId={}", (Object)this.remoteAddress, (Object)producerId);
            this.commandSender.sendSuccessResponse(requestId);
            this.producers.remove(producerId, (Object)producerFuture);
            return;
        }
        if (producerFuture.isCompletedExceptionally()) {
            log.info("[{}] Closed producer that already failed to be created. producerId={}", (Object)this.remoteAddress, (Object)producerId);
            this.commandSender.sendSuccessResponse(requestId);
            this.producers.remove(producerId, (Object)producerFuture);
            return;
        }
        Producer producer = producerFuture.getNow(null);
        log.info("[{}][{}] Closing producer on cnx {}. producerId={}", new Object[]{producer.getTopic(), producer.getProducerName(), this.remoteAddress, producerId});
        producer.close(true).thenAccept(v -> {
            log.info("[{}][{}] Closed producer on cnx {}. producerId={}", new Object[]{producer.getTopic(), producer.getProducerName(), this.remoteAddress, producerId});
            this.commandSender.sendSuccessResponse(requestId);
            this.producers.remove(producerId, (Object)producerFuture);
            if (this.brokerInterceptor != null) {
                this.brokerInterceptor.producerClosed(this, producer, producer.getMetadata());
            }
        });
    }

    protected void handleCloseConsumer(CommandCloseConsumer closeConsumer) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        log.info("[{}] Closing consumer: consumerId={}", (Object)this.remoteAddress, (Object)closeConsumer.getConsumerId());
        long requestId = closeConsumer.getRequestId();
        long consumerId = closeConsumer.getConsumerId();
        CompletableFuture consumerFuture = (CompletableFuture)this.consumers.get(consumerId);
        if (consumerFuture == null) {
            log.info("[{}] Consumer was not registered on the connection: {}", (Object)consumerId, (Object)this.remoteAddress);
            this.writeAndFlush(Commands.newSuccess((long)requestId));
            return;
        }
        if (!consumerFuture.isDone() && consumerFuture.completeExceptionally(new IllegalStateException("Closed consumer before creation was complete"))) {
            log.info("[{}] Closed consumer before its creation was completed. consumerId={}", (Object)this.remoteAddress, (Object)consumerId);
            this.commandSender.sendSuccessResponse(requestId);
            return;
        }
        if (consumerFuture.isCompletedExceptionally()) {
            log.info("[{}] Closed consumer that already failed to be created. consumerId={}", (Object)this.remoteAddress, (Object)consumerId);
            this.commandSender.sendSuccessResponse(requestId);
            return;
        }
        Consumer consumer = consumerFuture.getNow(null);
        try {
            consumer.close();
            this.consumers.remove(consumerId, (Object)consumerFuture);
            this.commandSender.sendSuccessResponse(requestId);
            log.info("[{}] Closed consumer, consumerId={}", (Object)this.remoteAddress, (Object)consumerId);
            if (this.brokerInterceptor != null) {
                this.brokerInterceptor.consumerClosed(this, consumer, consumer.getMetadata());
            }
        }
        catch (BrokerServiceException e) {
            log.warn("[{]] Error closing consumer {} : {}", new Object[]{this.remoteAddress, consumer, e});
            this.commandSender.sendErrorResponse(requestId, BrokerServiceException.getClientErrorCode(e), e.getMessage());
        }
    }

    protected void handleGetLastMessageId(CommandGetLastMessageId getLastMessageId) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        CompletableFuture consumerFuture = (CompletableFuture)this.consumers.get(getLastMessageId.getConsumerId());
        if (consumerFuture != null && consumerFuture.isDone() && !consumerFuture.isCompletedExceptionally()) {
            Consumer consumer = consumerFuture.getNow(null);
            long requestId = getLastMessageId.getRequestId();
            Topic topic = consumer.getSubscription().getTopic();
            ((CompletableFuture)((CompletableFuture)topic.checkIfTransactionBufferRecoverCompletely().thenCompose(__ -> topic.getLastDispatchablePosition())).thenApply(lastPosition -> {
                int partitionIndex = TopicName.getPartitionIndex((String)topic.getName());
                Position markDeletePosition = PositionFactory.EARLIEST;
                if (consumer.getSubscription() instanceof PersistentSubscription) {
                    markDeletePosition = ((PersistentSubscription)consumer.getSubscription()).getCursor().getMarkDeletedPosition();
                }
                this.getLargestBatchIndexWhenPossible(topic, (Position)lastPosition, markDeletePosition, partitionIndex, requestId, consumer.getSubscription().getName(), consumer.readCompacted());
                return null;
            })).exceptionally(e -> {
                this.writeAndFlush(Commands.newError((long)getLastMessageId.getRequestId(), (ServerError)ServerError.UnknownError, (String)"Failed to recover Transaction Buffer."));
                return null;
            });
        } else {
            this.writeAndFlush(Commands.newError((long)getLastMessageId.getRequestId(), (ServerError)ServerError.MetadataError, (String)"Consumer not found"));
        }
    }

    private void getLargestBatchIndexWhenPossible(Topic topic, Position lastPosition, Position markDeletePosition, int partitionIndex, long requestId, String subscriptionName, boolean readCompacted) {
        PersistentTopic persistentTopic = (PersistentTopic)topic;
        ManagedLedger ml = persistentTopic.getManagedLedger();
        CompletableFuture<Object> compactionHorizonFuture = readCompacted ? persistentTopic.getTopicCompactionService().getLastCompactedPosition() : CompletableFuture.completedFuture(null);
        compactionHorizonFuture.whenComplete((compactionHorizon, ex) -> {
            if (ex != null) {
                log.error("Failed to get compactionHorizon.", ex);
                this.writeAndFlush(Commands.newError((long)requestId, (ServerError)ServerError.MetadataError, (String)ex.getMessage()));
                return;
            }
            if (lastPosition.getEntryId() == -1L || !ml.getLedgersInfo().containsKey(lastPosition.getLedgerId())) {
                if (compactionHorizon != null) {
                    this.handleLastMessageIdFromCompactionService(persistentTopic, requestId, partitionIndex, markDeletePosition);
                } else {
                    this.writeAndFlush(Commands.newGetLastMessageIdResponse((long)requestId, (long)-1L, (long)-1L, (int)partitionIndex, (int)-1, (long)markDeletePosition.getLedgerId(), (long)markDeletePosition.getEntryId()));
                }
                return;
            }
            if (compactionHorizon != null && lastPosition.compareTo(compactionHorizon) <= 0) {
                this.handleLastMessageIdFromCompactionService(persistentTopic, requestId, partitionIndex, markDeletePosition);
                return;
            }
            final CompletableFuture entryFuture = new CompletableFuture();
            ml.asyncReadEntry(lastPosition, new AsyncCallbacks.ReadEntryCallback(){

                public void readEntryComplete(Entry entry, Object ctx) {
                    entryFuture.complete(entry);
                }

                public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                    entryFuture.completeExceptionally(exception);
                }

                public String toString() {
                    return String.format("ServerCnx [%s] get largest batch index when possible", ServerCnx.this.toString());
                }
            }, null);
            CompletionStage batchSizeFuture = entryFuture.thenApply(entry -> {
                MessageMetadata metadata = entry.getMessageMetadata();
                if (metadata == null) {
                    metadata = Commands.parseMessageMetadata((ByteBuf)entry.getDataBuffer());
                }
                int batchSize = metadata.getNumMessagesInBatch();
                entry.release();
                return metadata.hasNumMessagesInBatch() ? batchSize : -1;
            });
            ((CompletableFuture)batchSizeFuture).whenComplete((batchSize, e) -> {
                if (e != null) {
                    if (e.getCause() instanceof ManagedLedgerException.NonRecoverableLedgerException && readCompacted) {
                        this.handleLastMessageIdFromCompactionService(persistentTopic, requestId, partitionIndex, markDeletePosition);
                    } else {
                        this.writeAndFlush(Commands.newError((long)requestId, (ServerError)ServerError.MetadataError, (String)("Failed to get batch size for entry " + e.getMessage())));
                    }
                } else {
                    int largestBatchIndex;
                    int n = largestBatchIndex = batchSize > 0 ? batchSize - 1 : -1;
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] [{}][{}] Get LastMessageId {} partitionIndex {}", new Object[]{this.remoteAddress, topic.getName(), subscriptionName, lastPosition, partitionIndex});
                    }
                    this.writeAndFlush(Commands.newGetLastMessageIdResponse((long)requestId, (long)lastPosition.getLedgerId(), (long)lastPosition.getEntryId(), (int)partitionIndex, (int)largestBatchIndex, (long)markDeletePosition.getLedgerId(), (long)markDeletePosition.getEntryId()));
                }
            });
        });
    }

    private void handleLastMessageIdFromCompactionService(PersistentTopic persistentTopic, long requestId, int partitionIndex, Position markDeletePosition) {
        ((CompletableFuture)persistentTopic.getTopicCompactionService().getLastMessagePosition().thenAccept(position -> this.writeAndFlush(Commands.newGetLastMessageIdResponse((long)requestId, (long)position.ledgerId(), (long)position.entryId(), (int)partitionIndex, (int)position.batchIndex(), (long)markDeletePosition.getLedgerId(), (long)markDeletePosition.getEntryId())))).exceptionally(ex -> {
            this.writeAndFlush(Commands.newError((long)requestId, (ServerError)ServerError.MetadataError, (String)("Failed to read last entry of the compacted Ledger " + ex.getCause().getMessage())));
            return null;
        });
    }

    private CompletableFuture<Boolean> isNamespaceOperationAllowed(NamespaceName namespaceName, NamespaceOperation operation) {
        if (!this.service.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        CompletableFuture isProxyAuthorizedFuture = this.originalPrincipal != null ? this.service.getAuthorizationService().allowNamespaceOperationAsync(namespaceName, operation, this.originalPrincipal, this.originalAuthData) : CompletableFuture.completedFuture(true);
        CompletableFuture isAuthorizedFuture = this.service.getAuthorizationService().allowNamespaceOperationAsync(namespaceName, operation, this.authRole, this.authenticationData);
        return isProxyAuthorizedFuture.thenCombine((CompletionStage)isAuthorizedFuture, (isProxyAuthorized, isAuthorized) -> {
            if (!isProxyAuthorized.booleanValue()) {
                log.warn("OriginalRole {} is not authorized to perform operation {} on namespace {}", new Object[]{this.authenticationRoleLoggingAnonymizer.anonymize(this.originalPrincipal), operation, namespaceName});
            }
            if (!isAuthorized.booleanValue()) {
                log.warn("Role {} is not authorized to perform operation {} on namespace {}", new Object[]{this.authenticationRoleLoggingAnonymizer.anonymize(this.authRole), operation, namespaceName});
            }
            return isProxyAuthorized != false && isAuthorized != false;
        });
    }

    protected void handleGetTopicsOfNamespace(CommandGetTopicsOfNamespace commandGetTopicsOfNamespace) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        long requestId = commandGetTopicsOfNamespace.getRequestId();
        String namespace = commandGetTopicsOfNamespace.getNamespace();
        CommandGetTopicsOfNamespace.Mode mode = commandGetTopicsOfNamespace.getMode();
        Optional<String> topicsPattern = Optional.ofNullable(commandGetTopicsOfNamespace.hasTopicsPattern() ? commandGetTopicsOfNamespace.getTopicsPattern() : null);
        Optional<String> topicsHash = Optional.ofNullable(commandGetTopicsOfNamespace.hasTopicsHash() ? commandGetTopicsOfNamespace.getTopicsHash() : null);
        NamespaceName namespaceName = NamespaceName.get((String)namespace);
        Semaphore lookupSemaphore = this.service.getLookupRequestSemaphore();
        if (lookupSemaphore.tryAcquire()) {
            ((CompletableFuture)this.isNamespaceOperationAllowed(namespaceName, NamespaceOperation.GET_TOPICS).thenApply(isAuthorized -> {
                if (isAuthorized.booleanValue()) {
                    ((CompletableFuture)this.getBrokerService().pulsar().getNamespaceService().getListOfUserTopics(namespaceName, mode).thenAccept(topics -> {
                        boolean hashUnchanged;
                        boolean filterTopics = false;
                        List filteredTopics = topics;
                        if (this.enableSubscriptionPatternEvaluation && topicsPattern.isPresent()) {
                            if (((String)topicsPattern.get()).length() <= this.maxSubscriptionPatternLength) {
                                filterTopics = true;
                                filteredTopics = TopicList.filterTopics(filteredTopics, (String)((String)topicsPattern.get()), (TopicsPattern.RegexImplementation)this.topicsPatternImplementation);
                            } else {
                                log.info("[{}] Subscription pattern provided [{}] was longer than maximum {}.", new Object[]{this.remoteAddress, topicsPattern.get(), this.maxSubscriptionPatternLength});
                            }
                        }
                        String hash = TopicList.calculateHash((List)filteredTopics);
                        boolean bl = hashUnchanged = topicsHash.isPresent() && ((String)topicsHash.get()).equals(hash);
                        if (hashUnchanged) {
                            filteredTopics = Collections.emptyList();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Received CommandGetTopicsOfNamespace for namespace [//{}] by {}, size:{}", new Object[]{this.remoteAddress, namespace, requestId, topics.size()});
                        }
                        this.commandSender.sendGetTopicsOfNamespaceResponse(filteredTopics, hash, filterTopics, !hashUnchanged, requestId);
                        lookupSemaphore.release();
                    })).exceptionally(ex -> {
                        log.warn("[{}] Error GetTopicsOfNamespace for namespace [//{}] by {}", new Object[]{this.remoteAddress, namespace, requestId});
                        this.commandSender.sendErrorResponse(requestId, BrokerServiceException.getClientErrorCode(new BrokerServiceException.ServerMetadataException((Throwable)ex)), ex.getMessage());
                        lookupSemaphore.release();
                        return null;
                    });
                } else {
                    String msg = "Client is not authorized to GetTopicsOfNamespace";
                    log.warn("[{}] {} with role {} on namespace {}", new Object[]{this.remoteAddress, "Client is not authorized to GetTopicsOfNamespace", this.getPrincipal(), namespaceName});
                    this.commandSender.sendErrorResponse(requestId, ServerError.AuthorizationError, "Client is not authorized to GetTopicsOfNamespace");
                    lookupSemaphore.release();
                }
                return null;
            })).exceptionally(ex -> {
                ServerCnx.logNamespaceNameAuthException(this.remoteAddress, "GetTopicsOfNamespace", this.getPrincipal(), Optional.of(namespaceName), ex);
                String msg = "Exception occurred while trying to authorize GetTopicsOfNamespace";
                this.commandSender.sendErrorResponse(requestId, ServerError.AuthorizationError, "Exception occurred while trying to authorize GetTopicsOfNamespace");
                lookupSemaphore.release();
                return null;
            });
        } else {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Failed GetTopicsOfNamespace lookup due to too many lookup-requests {}", (Object)this.remoteAddress, (Object)namespaceName);
            }
            this.commandSender.sendErrorResponse(requestId, ServerError.TooManyRequests, "Failed due to too many pending lookup requests");
        }
    }

    protected void handleGetSchema(CommandGetSchema commandGetSchema) {
        String schemaName;
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        if (log.isDebugEnabled()) {
            if (commandGetSchema.hasSchemaVersion()) {
                log.debug("Received CommandGetSchema call from {}, schemaVersion: {}, topic: {}, requestId: {}", new Object[]{this.remoteAddress, new String(commandGetSchema.getSchemaVersion()), commandGetSchema.getTopic(), commandGetSchema.getRequestId()});
            } else {
                log.debug("Received CommandGetSchema call from {}, schemaVersion: {}, topic: {}, requestId: {}", new Object[]{this.remoteAddress, null, commandGetSchema.getTopic(), commandGetSchema.getRequestId()});
            }
        }
        long requestId = commandGetSchema.getRequestId();
        SchemaVersion schemaVersion = SchemaVersion.Latest;
        if (commandGetSchema.hasSchemaVersion()) {
            if (commandGetSchema.getSchemaVersion().length == 0) {
                this.commandSender.sendGetSchemaErrorResponse(requestId, ServerError.IncompatibleSchema, "Empty schema version");
                return;
            }
            schemaVersion = this.schemaService.versionFromBytes(commandGetSchema.getSchemaVersion());
        }
        String topic = commandGetSchema.getTopic();
        try {
            schemaName = TopicName.get((String)topic).getSchemaName();
        }
        catch (Throwable t) {
            this.commandSender.sendGetSchemaErrorResponse(requestId, ServerError.InvalidTopicName, t.getMessage());
            return;
        }
        ((CompletableFuture)this.schemaService.getSchema(schemaName, schemaVersion).thenAccept(schemaAndMetadata -> {
            if (schemaAndMetadata == null) {
                this.commandSender.sendGetSchemaErrorResponse(requestId, ServerError.TopicNotFound, String.format("Topic not found or no-schema %s", topic));
            } else {
                this.commandSender.sendGetSchemaResponse(requestId, SchemaInfoUtil.newSchemaInfo((String)schemaName, (SchemaData)schemaAndMetadata.schema), schemaAndMetadata.version);
            }
        })).exceptionally(ex -> {
            this.commandSender.sendGetSchemaErrorResponse(requestId, ServerError.UnknownError, ex.getMessage());
            return null;
        });
    }

    protected void handleGetOrCreateSchema(CommandGetOrCreateSchema commandGetOrCreateSchema) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        if (log.isDebugEnabled()) {
            log.debug("Received CommandGetOrCreateSchema call from {}", (Object)this.remoteAddress);
        }
        long requestId = commandGetOrCreateSchema.getRequestId();
        String topicName = commandGetOrCreateSchema.getTopic();
        SchemaData schemaData = this.getSchema(commandGetOrCreateSchema.getSchema());
        SchemaData schema = schemaData.getType() == SchemaType.NONE ? null : schemaData;
        ((CompletableFuture)this.service.getTopicIfExists(topicName).thenAccept(topicOpt -> {
            if (topicOpt.isPresent()) {
                Topic topic = (Topic)topicOpt.get();
                CompletableFuture<SchemaVersion> schemaVersionFuture = this.tryAddSchema(topic, schema);
                ((CompletableFuture)schemaVersionFuture.exceptionally(ex -> {
                    ServerError errorCode = BrokerServiceException.getClientErrorCode(ex);
                    Object message = ex.getMessage();
                    if (ex.getCause() != null) {
                        message = (String)message + " caused by " + String.valueOf(ex.getCause());
                    }
                    this.commandSender.sendGetOrCreateSchemaErrorResponse(requestId, errorCode, (String)message);
                    return null;
                })).thenAccept(schemaVersion -> this.commandSender.sendGetOrCreateSchemaResponse(requestId, (SchemaVersion)schemaVersion));
            } else {
                this.commandSender.sendGetOrCreateSchemaErrorResponse(requestId, ServerError.TopicNotFound, String.format("Topic not found %s", topicName));
            }
        })).exceptionally(ex -> {
            ServerError errorCode = BrokerServiceException.getClientErrorCode(ex);
            this.commandSender.sendGetOrCreateSchemaErrorResponse(requestId, errorCode, ex.getMessage());
            return null;
        });
    }

    protected void handleTcClientConnectRequest(CommandTcClientConnectRequest command) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        long requestId = command.getRequestId();
        TransactionCoordinatorID tcId = TransactionCoordinatorID.get((long)command.getTcId());
        if (log.isDebugEnabled()) {
            log.debug("Receive tc client connect request {} to transaction meta store {} from {}.", new Object[]{requestId, tcId, this.remoteAddress});
        }
        if (!this.checkTransactionEnableAndSendError(requestId)) {
            return;
        }
        TransactionMetadataStoreService transactionMetadataStoreService = this.service.pulsar().getTransactionMetadataStoreService();
        ((CompletableFuture)transactionMetadataStoreService.handleTcClientConnect(tcId).thenAccept(connection -> {
            if (log.isDebugEnabled()) {
                log.debug("Handle tc client connect request {} to transaction meta store {} from {} success.", new Object[]{requestId, tcId, this.remoteAddress});
            }
            this.commandSender.sendTcClientConnectResponse(requestId);
        })).exceptionally(e -> {
            log.error("Handle tc client connect request {} to transaction meta store {} from {} fail.", new Object[]{requestId, tcId, this.remoteAddress, e.getCause()});
            this.commandSender.sendTcClientConnectResponse(requestId, BrokerServiceException.getClientErrorCode(e), e.getMessage());
            return null;
        });
    }

    private boolean checkTransactionEnableAndSendError(long requestId) {
        if (!this.service.getPulsar().getConfig().isTransactionCoordinatorEnabled()) {
            BrokerServiceException.NotAllowedException ex = new BrokerServiceException.NotAllowedException("Transactions are not enabled.");
            this.commandSender.sendErrorResponse(requestId, BrokerServiceException.getClientErrorCode(ex), ex.getMessage());
            return false;
        }
        return true;
    }

    private Throwable handleTxnException(Throwable ex, String op, long requestId) {
        Throwable cause = FutureUtil.unwrapCompletionException((Throwable)ex);
        if (cause instanceof CoordinatorException.CoordinatorNotFoundException) {
            if (log.isDebugEnabled()) {
                log.debug("The Coordinator was not found for the request {}", (Object)op);
            }
            return cause;
        }
        if (cause instanceof ManagedLedgerException.ManagedLedgerFencedException) {
            if (log.isDebugEnabled()) {
                log.debug("Throw a CoordinatorNotFoundException to client with the message got from a ManagedLedgerFencedException for the request {}", (Object)op);
            }
            return new CoordinatorException.CoordinatorNotFoundException(cause.getMessage());
        }
        log.error("Send response error for {} request {}.", new Object[]{op, requestId, cause});
        return cause;
    }

    protected void handleNewTxn(CommandNewTxn command) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        long requestId = command.getRequestId();
        TransactionCoordinatorID tcId = TransactionCoordinatorID.get((long)command.getTcId());
        if (log.isDebugEnabled()) {
            log.debug("Receive new txn request {} to transaction meta store {} from {}.", new Object[]{requestId, tcId, this.remoteAddress});
        }
        if (!this.checkTransactionEnableAndSendError(requestId)) {
            return;
        }
        TransactionMetadataStoreService transactionMetadataStoreService = this.service.pulsar().getTransactionMetadataStoreService();
        String owner = this.getPrincipal();
        transactionMetadataStoreService.newTransaction(tcId, command.getTxnTtlSeconds(), owner).whenComplete((txnID, ex) -> {
            if (ex == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Send response {} for new txn request {}", (Object)tcId.getId(), (Object)requestId);
                }
                this.commandSender.sendNewTxnResponse(requestId, (TxnID)txnID, tcId.getId());
            } else if (ex instanceof CoordinatorException.ReachMaxActiveTxnException) {
                log.warn("New txn op reach max active transactions! tcId : {}, requestId : {}", new Object[]{tcId.getId(), requestId, ex});
            } else {
                ex = this.handleTxnException((Throwable)ex, BaseCommand.Type.NEW_TXN.name(), requestId);
                this.commandSender.sendNewTxnErrorResponse(requestId, tcId.getId(), BrokerServiceException.getClientErrorCode(ex), ex.getMessage());
                transactionMetadataStoreService.handleOpFail((Throwable)ex, tcId);
            }
        });
    }

    protected void handleAddPartitionToTxn(CommandAddPartitionToTxn command) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        TxnID txnID = new TxnID(command.getTxnidMostBits(), command.getTxnidLeastBits());
        TransactionCoordinatorID tcId = TransactionCoordinatorID.get((long)command.getTxnidMostBits());
        long requestId = command.getRequestId();
        List partitionsList = command.getPartitionsList();
        if (log.isDebugEnabled()) {
            partitionsList.forEach(partition -> log.debug("Receive add published partition to txn request {} from {} with txnId {}, topic: [{}]", new Object[]{requestId, this.remoteAddress, txnID, partition}));
        }
        if (!this.checkTransactionEnableAndSendError(requestId)) {
            return;
        }
        TransactionMetadataStoreService transactionMetadataStoreService = this.service.pulsar().getTransactionMetadataStoreService();
        ((CompletableFuture)this.verifyTxnOwnership(txnID).thenCompose(isOwner -> {
            if (!isOwner.booleanValue()) {
                return this.failedFutureTxnNotOwned(txnID);
            }
            return transactionMetadataStoreService.addProducedPartitionToTxn(txnID, partitionsList);
        })).whenComplete((v, ex) -> {
            if (ex == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Send response success for add published partition to txn request {}", (Object)requestId);
                }
                this.writeAndFlush(Commands.newAddPartitionToTxnResponse((long)requestId, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits()));
            } else {
                ex = this.handleTxnException((Throwable)ex, BaseCommand.Type.ADD_PARTITION_TO_TXN.name(), requestId);
                this.writeAndFlush(Commands.newAddPartitionToTxnResponse((long)requestId, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits(), (ServerError)BrokerServiceException.getClientErrorCode(ex), (String)ex.getMessage()));
                transactionMetadataStoreService.handleOpFail((Throwable)ex, tcId);
            }
        });
    }

    private CompletableFuture<Void> failedFutureTxnNotOwned(TxnID txnID) {
        String msg = String.format("Client (%s) is neither the owner of the transaction %s nor a super user", this.getPrincipal(), txnID);
        log.warn("[{}] {}", (Object)this.remoteAddress, (Object)msg);
        return CompletableFuture.failedFuture((Throwable)new CoordinatorException.TransactionNotFoundException(msg));
    }

    private CompletableFuture<Void> failedFutureTxnTcNotAllowed(TxnID txnID) {
        String msg = String.format("TC client (%s) is not a super user, and is not allowed to operate on transaction %s", this.getPrincipal(), txnID);
        log.warn("[{}] {}", (Object)this.remoteAddress, (Object)msg);
        return CompletableFuture.failedFuture((Throwable)new CoordinatorException.TransactionNotFoundException(msg));
    }

    protected void handleEndTxn(CommandEndTxn command) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        long requestId = command.getRequestId();
        int txnAction = command.getTxnAction().getValue();
        TxnID txnID = new TxnID(command.getTxnidMostBits(), command.getTxnidLeastBits());
        TransactionCoordinatorID tcId = TransactionCoordinatorID.get((long)command.getTxnidMostBits());
        if (!this.checkTransactionEnableAndSendError(requestId)) {
            return;
        }
        TransactionMetadataStoreService transactionMetadataStoreService = this.service.pulsar().getTransactionMetadataStoreService();
        ((CompletableFuture)this.verifyTxnOwnership(txnID).thenCompose(isOwner -> {
            if (!isOwner.booleanValue()) {
                return this.failedFutureTxnNotOwned(txnID);
            }
            return transactionMetadataStoreService.endTransaction(txnID, txnAction, false);
        })).whenComplete((v, ex) -> {
            if (ex == null) {
                this.commandSender.sendEndTxnResponse(requestId, txnID, txnAction);
            } else {
                ex = this.handleTxnException((Throwable)ex, BaseCommand.Type.END_TXN.name(), requestId);
                this.commandSender.sendEndTxnErrorResponse(requestId, txnID, BrokerServiceException.getClientErrorCode(ex), ex.getMessage());
                transactionMetadataStoreService.handleOpFail((Throwable)ex, tcId);
            }
        });
    }

    private CompletableFuture<Boolean> isSuperUser() {
        assert (this.ctx.executor().inEventLoop());
        if (this.service.isAuthenticationEnabled() && this.service.isAuthorizationEnabled()) {
            CompletableFuture isAuthRoleAuthorized = this.service.getAuthorizationService().isSuperUser(this.authRole, this.authenticationData);
            if (this.originalPrincipal != null) {
                CompletableFuture isOriginalPrincipalAuthorized = this.service.getAuthorizationService().isSuperUser(this.originalPrincipal, this.originalAuthData != null ? this.originalAuthData : this.authenticationData);
                return isOriginalPrincipalAuthorized.thenCombine((CompletionStage)isAuthRoleAuthorized, (originalPrincipal, authRole) -> originalPrincipal != false && authRole != false);
            }
            return isAuthRoleAuthorized;
        }
        return CompletableFuture.completedFuture(true);
    }

    private CompletableFuture<Boolean> verifyTxnOwnership(TxnID txnID) {
        assert (this.ctx.executor().inEventLoop());
        return this.service.pulsar().getTransactionMetadataStoreService().verifyTxnOwnership(txnID, this.getPrincipal()).thenComposeAsync(isOwner -> {
            if (isOwner.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            if (this.service.isAuthenticationEnabled() && this.service.isAuthorizationEnabled()) {
                return this.isSuperUser();
            }
            return CompletableFuture.completedFuture(false);
        }, (Executor)this.ctx.executor());
    }

    protected void handleEndTxnOnPartition(CommandEndTxnOnPartition command) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        long requestId = command.getRequestId();
        String topic = command.getTopic();
        int txnAction = command.getTxnAction().getValue();
        TxnID txnID = new TxnID(command.getTxnidMostBits(), command.getTxnidLeastBits());
        long lowWaterMark = command.getTxnidLeastBitsOfLowWatermark();
        if (log.isDebugEnabled()) {
            log.debug("[{}] handleEndTxnOnPartition txnId: [{}], txnAction: [{}]", new Object[]{topic, txnID, txnAction});
        }
        TopicName topicName = TopicName.get((String)topic);
        CompletableFuture<Optional<Topic>> topicFuture = this.service.getTopicIfExists(topicName.toString());
        ((CompletableFuture)topicFuture.thenAcceptAsync(optionalTopic -> {
            if (optionalTopic.isPresent()) {
                ((CompletableFuture)this.isSuperUser().thenCompose(isOwner -> {
                    if (!isOwner.booleanValue()) {
                        return this.failedFutureTxnTcNotAllowed(txnID);
                    }
                    return ((Topic)optionalTopic.get()).endTxn(txnID, txnAction, lowWaterMark);
                })).whenComplete((ignored, throwable) -> {
                    if (throwable != null) {
                        throwable = FutureUtil.unwrapCompletionException((Throwable)throwable);
                        log.error("handleEndTxnOnPartition fail!, topic {}, txnId: [{}], txnAction: [{}]", new Object[]{topic, txnID, TxnAction.valueOf((int)txnAction), throwable});
                        this.writeAndFlush(Commands.newEndTxnOnPartitionResponse((long)requestId, (ServerError)BrokerServiceException.getClientErrorCode(throwable), (String)throwable.getMessage(), (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits()));
                        return;
                    }
                    this.writeAndFlush(Commands.newEndTxnOnPartitionResponse((long)requestId, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits()));
                });
            } else {
                ((CompletableFuture)this.getBrokerService().getManagedLedgerFactoryForTopic(topicName).thenCompose(managedLedgerFactory -> managedLedgerFactory.asyncExists(topicName.getPersistenceNamingEncoding()).thenAccept(b -> {
                    if (b.booleanValue()) {
                        log.error("handleEndTxnOnPartition fail ! The topic {} does not exist in broker, txnId: [{}], txnAction: [{}]", new Object[]{topic, txnID, TxnAction.valueOf((int)txnAction)});
                        this.writeAndFlush(Commands.newEndTxnOnPartitionResponse((long)requestId, (ServerError)ServerError.ServiceNotReady, (String)("The topic " + topic + " does not exist in broker."), (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits()));
                    } else {
                        log.warn("handleEndTxnOnPartition fail ! The topic {} has not been created, txnId: [{}], txnAction: [{}]", new Object[]{topic, txnID, TxnAction.valueOf((int)txnAction)});
                        this.writeAndFlush(Commands.newEndTxnOnPartitionResponse((long)requestId, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits()));
                    }
                }))).exceptionally(e -> {
                    log.error("handleEndTxnOnPartition fail ! topic {}, txnId: [{}], txnAction: [{}]", new Object[]{topic, txnID, TxnAction.valueOf((int)txnAction), e.getCause()});
                    this.writeAndFlush(Commands.newEndTxnOnPartitionResponse((long)requestId, (ServerError)ServerError.ServiceNotReady, (String)e.getMessage(), (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits()));
                    return null;
                });
            }
        }, (Executor)this.ctx.executor())).exceptionally(e -> {
            log.error("handleEndTxnOnPartition fail ! topic {}, txnId: [{}], txnAction: [{}]", new Object[]{topic, txnID, TxnAction.valueOf((int)txnAction), e.getCause()});
            this.writeAndFlush(Commands.newEndTxnOnPartitionResponse((long)requestId, (ServerError)ServerError.ServiceNotReady, (String)e.getMessage(), (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits()));
            return null;
        });
    }

    protected void handleEndTxnOnSubscription(CommandEndTxnOnSubscription command) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        long requestId = command.getRequestId();
        long txnidMostBits = command.getTxnidMostBits();
        long txnidLeastBits = command.getTxnidLeastBits();
        String topic = command.getSubscription().getTopic();
        String subName = command.getSubscription().getSubscription();
        int txnAction = command.getTxnAction().getValue();
        TxnID txnID = new TxnID(txnidMostBits, txnidLeastBits);
        long lowWaterMark = command.getTxnidLeastBitsOfLowWatermark();
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] handleEndTxnOnSubscription txnId: [{}], txnAction: [{}]", new Object[]{topic, subName, new TxnID(txnidMostBits, txnidLeastBits), txnAction});
        }
        TopicName topicName = TopicName.get((String)topic);
        CompletableFuture<Optional<Topic>> topicFuture = this.service.getTopicIfExists(topicName.toString());
        ((CompletableFuture)topicFuture.thenAcceptAsync(optionalTopic -> {
            if (optionalTopic.isPresent()) {
                Subscription subscription = ((Topic)optionalTopic.get()).getSubscription(subName);
                if (subscription == null) {
                    log.warn("handleEndTxnOnSubscription fail! topic {} subscription {} does not exist. txnId: [{}], txnAction: [{}]", new Object[]{((Topic)optionalTopic.get()).getName(), subName, txnID, TxnAction.valueOf((int)txnAction)});
                    this.writeAndFlush(Commands.newEndTxnOnSubscriptionResponse((long)requestId, (long)txnidLeastBits, (long)txnidMostBits));
                    return;
                }
                ((CompletableFuture)this.isSuperUser().thenCompose(isOwner -> {
                    if (!isOwner.booleanValue()) {
                        return this.failedFutureTxnTcNotAllowed(txnID);
                    }
                    return subscription.endTxn(txnidMostBits, txnidLeastBits, txnAction, lowWaterMark);
                })).whenComplete((ignored, e) -> {
                    if (e != null) {
                        e = FutureUtil.unwrapCompletionException((Throwable)e);
                        log.error("handleEndTxnOnSubscription fail ! topic: {}, subscription: {}txnId: [{}], txnAction: [{}]", new Object[]{topic, subName, txnID, TxnAction.valueOf((int)txnAction), e.getCause()});
                        this.writeAndFlush(Commands.newEndTxnOnSubscriptionResponse((long)requestId, (long)txnidLeastBits, (long)txnidMostBits, (ServerError)BrokerServiceException.getClientErrorCode(e), (String)("Handle end txn on subscription failed: " + e.getMessage())));
                        return;
                    }
                    this.writeAndFlush(Commands.newEndTxnOnSubscriptionResponse((long)requestId, (long)txnidLeastBits, (long)txnidMostBits));
                });
            } else {
                ((CompletableFuture)this.getBrokerService().getManagedLedgerFactoryForTopic(topicName).thenCompose(managedLedgerFactory -> managedLedgerFactory.asyncExists(topicName.getPersistenceNamingEncoding()).thenAccept(b -> {
                    if (b.booleanValue()) {
                        log.error("handleEndTxnOnSubscription fail! The topic {} does not exist in broker, subscription: {}, txnId: [{}], txnAction: [{}]", new Object[]{topic, subName, txnID, TxnAction.valueOf((int)txnAction)});
                        this.writeAndFlush(Commands.newEndTxnOnSubscriptionResponse((long)requestId, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits(), (ServerError)ServerError.ServiceNotReady, (String)("The topic " + topic + " does not exist in broker.")));
                    } else {
                        log.warn("handleEndTxnOnSubscription fail ! The topic {} has not been created, subscription: {} txnId: [{}], txnAction: [{}]", new Object[]{topic, subName, txnID, TxnAction.valueOf((int)txnAction)});
                        this.writeAndFlush(Commands.newEndTxnOnSubscriptionResponse((long)requestId, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits()));
                    }
                }))).exceptionally(e -> {
                    log.error("handleEndTxnOnSubscription fail ! topic {}, subscription: {}txnId: [{}], txnAction: [{}]", new Object[]{topic, subName, txnID, TxnAction.valueOf((int)txnAction), e.getCause()});
                    this.writeAndFlush(Commands.newEndTxnOnSubscriptionResponse((long)requestId, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits(), (ServerError)ServerError.ServiceNotReady, (String)e.getMessage()));
                    return null;
                });
            }
        }, (Executor)this.ctx.executor())).exceptionally(e -> {
            log.error("handleEndTxnOnSubscription fail ! topic: {}, subscription: {}txnId: [{}], txnAction: [{}]", new Object[]{topic, subName, txnID, TxnAction.valueOf((int)txnAction), e.getCause()});
            this.writeAndFlush(Commands.newEndTxnOnSubscriptionResponse((long)requestId, (long)txnidLeastBits, (long)txnidMostBits, (ServerError)ServerError.ServiceNotReady, (String)("Handle end txn on subscription failed: " + e.getMessage())));
            return null;
        });
    }

    private CompletableFuture<SchemaVersion> tryAddSchema(Topic topic, SchemaData schema) {
        if (schema != null) {
            return topic.addSchema(schema);
        }
        return topic.hasSchema().thenCompose(hasSchema -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] {} configured with schema {}", new Object[]{this.remoteAddress, topic.getName(), hasSchema});
            }
            CompletableFuture<SchemaVersion> result = new CompletableFuture<SchemaVersion>();
            if (hasSchema.booleanValue() && (this.schemaValidationEnforced || topic.getSchemaValidationEnforced())) {
                result.completeExceptionally(new IncompatibleSchemaException("Producers cannot connect or send message without a schema to topics with a schemawhen SchemaValidationEnforced is enabled"));
            } else {
                result.complete(SchemaVersion.Empty);
            }
            return result;
        });
    }

    protected void handleAddSubscriptionToTxn(CommandAddSubscriptionToTxn command) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        TxnID txnID = new TxnID(command.getTxnidMostBits(), command.getTxnidLeastBits());
        long requestId = command.getRequestId();
        ArrayList<org.apache.pulsar.common.api.proto.Subscription> subscriptionsList = new ArrayList<org.apache.pulsar.common.api.proto.Subscription>();
        for (org.apache.pulsar.common.api.proto.Subscription sub : command.getSubscriptionsList()) {
            subscriptionsList.add(new org.apache.pulsar.common.api.proto.Subscription().copyFrom(sub));
        }
        if (log.isDebugEnabled()) {
            log.debug("Receive add published partition to txn request {} from {} with txnId {}", new Object[]{requestId, this.remoteAddress, txnID});
        }
        TransactionCoordinatorID tcId = TransactionCoordinatorID.get((long)command.getTxnidMostBits());
        if (!this.checkTransactionEnableAndSendError(requestId)) {
            return;
        }
        TransactionMetadataStoreService transactionMetadataStoreService = this.service.pulsar().getTransactionMetadataStoreService();
        ((CompletableFuture)this.verifyTxnOwnership(txnID).thenCompose(isOwner -> {
            if (!isOwner.booleanValue()) {
                return this.failedFutureTxnNotOwned(txnID);
            }
            return transactionMetadataStoreService.addAckedPartitionToTxn(txnID, MLTransactionMetadataStore.subscriptionToTxnSubscription((List)subscriptionsList));
        })).whenComplete((v, ex) -> {
            if (ex == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Send response success for add published partition to txn request {}", (Object)requestId);
                }
                this.writeAndFlush(Commands.newAddSubscriptionToTxnResponse((long)requestId, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits()));
            } else {
                ex = this.handleTxnException((Throwable)ex, BaseCommand.Type.ADD_SUBSCRIPTION_TO_TXN.name(), requestId);
                this.writeAndFlush(Commands.newAddSubscriptionToTxnResponse((long)requestId, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits(), (ServerError)BrokerServiceException.getClientErrorCode(ex), (String)ex.getMessage()));
                transactionMetadataStoreService.handleOpFail((Throwable)ex, tcId);
            }
        });
    }

    protected void handleCommandWatchTopicList(CommandWatchTopicList commandWatchTopicList) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        long requestId = commandWatchTopicList.getRequestId();
        long watcherId = commandWatchTopicList.getWatcherId();
        NamespaceName namespaceName = NamespaceName.get((String)commandWatchTopicList.getNamespace());
        Semaphore lookupSemaphore = this.service.getLookupRequestSemaphore();
        if (lookupSemaphore.tryAcquire()) {
            ((CompletableFuture)this.isNamespaceOperationAllowed(namespaceName, NamespaceOperation.GET_TOPICS).thenApply(isAuthorized -> {
                if (isAuthorized.booleanValue()) {
                    String topicsPatternString = commandWatchTopicList.hasTopicsPattern() ? commandWatchTopicList.getTopicsPattern() : ".*";
                    String topicsHash = commandWatchTopicList.hasTopicsHash() ? commandWatchTopicList.getTopicsHash() : null;
                    this.topicListService.handleWatchTopicList(namespaceName, watcherId, requestId, topicsPatternString, this.topicsPatternImplementation, topicsHash, lookupSemaphore);
                } else {
                    String msg = "Proxy Client is not authorized to watchTopicList";
                    log.warn("[{}] {} with role {} on namespace {}", new Object[]{this.remoteAddress, "Proxy Client is not authorized to watchTopicList", this.getPrincipal(), namespaceName});
                    this.commandSender.sendErrorResponse(requestId, ServerError.AuthorizationError, "Proxy Client is not authorized to watchTopicList");
                    lookupSemaphore.release();
                }
                return null;
            })).exceptionally(ex -> {
                ServerCnx.logNamespaceNameAuthException(this.remoteAddress, "watchTopicList", this.getPrincipal(), Optional.of(namespaceName), ex);
                String msg = "Exception occurred while trying to handle command WatchTopicList";
                this.commandSender.sendErrorResponse(requestId, ServerError.AuthorizationError, "Exception occurred while trying to handle command WatchTopicList");
                lookupSemaphore.release();
                return null;
            });
        } else {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Failed WatchTopicList due to too many lookup-requests {}", (Object)this.remoteAddress, (Object)namespaceName);
            }
            this.commandSender.sendErrorResponse(requestId, ServerError.TooManyRequests, "Failed due to too many pending lookup requests");
        }
    }

    protected void handleCommandWatchTopicListClose(CommandWatchTopicListClose commandWatchTopicListClose) {
        Preconditions.checkArgument((this.state == State.Connected ? 1 : 0) != 0);
        this.topicListService.handleWatchTopicListClose(commandWatchTopicListClose);
    }

    protected boolean isHandshakeCompleted() {
        return this.state == State.Connected;
    }

    public ChannelHandlerContext ctx() {
        return this.ctx;
    }

    protected void interceptCommand(BaseCommand command) throws InterceptException {
        if (this.brokerInterceptor != null) {
            this.brokerInterceptor.onPulsarCommand(command, this);
        }
    }

    @Override
    public void closeProducer(Producer producer) {
        this.safelyRemoveProducer(producer);
        this.closeProducer(producer.getProducerId(), producer.getEpoch(), Optional.empty());
    }

    @Override
    public void closeProducer(Producer producer, Optional<BrokerLookupData> assignedBrokerLookupData) {
        this.safelyRemoveProducer(producer);
        this.closeProducer(producer.getProducerId(), producer.getEpoch(), assignedBrokerLookupData);
    }

    private LookupData getLookupData(BrokerLookupData lookupData) {
        LookupOptions.LookupOptionsBuilder builder = LookupOptions.builder();
        if (StringUtils.isNotBlank((CharSequence)this.listenerName)) {
            builder.advertisedListenerName(this.listenerName);
        }
        try {
            return lookupData.toLookupResult(builder.build()).getLookupData();
        }
        catch (PulsarServerException e) {
            log.error("Failed to get lookup data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void closeProducer(long producerId, long epoch, Optional<BrokerLookupData> assignedBrokerLookupData) {
        if (this.getRemoteEndpointProtocolVersion() >= ProtocolVersion.v5.getValue()) {
            assignedBrokerLookupData.ifPresentOrElse(lookup -> {
                LookupData lookupData = this.getLookupData((BrokerLookupData)lookup);
                this.writeAndFlush(Commands.newCloseProducer((long)producerId, (long)-1L, (String)lookupData.getBrokerUrl(), (String)lookupData.getBrokerUrlTls()));
            }, () -> this.writeAndFlush(Commands.newCloseProducer((long)producerId, (long)-1L)));
            this.recentlyClosedProducers.put(producerId, epoch);
            this.ctx.executor().schedule(() -> this.recentlyClosedProducers.remove(producerId, epoch), (long)this.service.getKeepAliveIntervalSeconds(), TimeUnit.SECONDS);
        } else {
            this.close();
        }
    }

    @Override
    public void closeConsumer(Consumer consumer, Optional<BrokerLookupData> assignedBrokerLookupData) {
        this.safelyRemoveConsumer(consumer);
        this.closeConsumer(consumer.consumerId(), assignedBrokerLookupData);
    }

    private void closeConsumer(long consumerId, Optional<BrokerLookupData> assignedBrokerLookupData) {
        if (this.getRemoteEndpointProtocolVersion() >= ProtocolVersion.v5.getValue()) {
            assignedBrokerLookupData.ifPresentOrElse(lookup -> {
                LookupData lookupData = this.getLookupData((BrokerLookupData)lookup);
                this.writeAndFlush(Commands.newCloseConsumer((long)consumerId, (long)-1L, (String)lookupData.getBrokerUrl(), (String)lookupData.getBrokerUrlTls()));
            }, () -> this.writeAndFlush(Commands.newCloseConsumer((long)consumerId, (long)-1L, null, null)));
        } else {
            this.close();
        }
    }

    protected void close() {
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    @Override
    public SocketAddress clientAddress() {
        return this.remoteAddress;
    }

    @Override
    public void removedConsumer(Consumer consumer) {
        this.safelyRemoveConsumer(consumer);
    }

    @Override
    public void removedProducer(Producer producer) {
        this.safelyRemoveProducer(producer);
    }

    private void safelyRemoveProducer(Producer producer) {
        CompletableFuture future;
        long producerId = producer.getProducerId();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Removed producer: producerId={}, producer={}", new Object[]{this.remoteAddress, producerId, producer});
        }
        if ((future = (CompletableFuture)this.producers.get(producerId)) != null) {
            future.whenComplete((producer2, exception) -> {
                if (exception != null || producer2 == producer) {
                    this.producers.remove(producerId, (Object)future);
                }
            });
        }
    }

    private void safelyRemoveConsumer(Consumer consumer) {
        CompletableFuture future;
        long consumerId = consumer.consumerId();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Removed consumer: consumerId={}, consumer={}", new Object[]{this.remoteAddress, consumerId, consumer});
        }
        if ((future = (CompletableFuture)this.consumers.get(consumerId)) != null) {
            future.whenComplete((consumer2, exception) -> {
                if (exception != null || consumer2 == consumer) {
                    this.consumers.remove(consumerId, (Object)future);
                }
            });
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean isWritable() {
        return this.ctx.channel().isWritable();
    }

    private void increasePendingSendRequestsAndPublishBytes(int msgSize) {
        if (++this.pendingSendRequest == this.maxPendingSendRequests) {
            this.throttleTracker.setPendingSendRequestsExceeded(true);
        }
        PendingBytesPerThreadTracker.getInstance().incrementPublishBytes(msgSize, this.maxPendingBytesPerThread);
    }

    void increasePublishLimitedTimesForTopics() {
        this.producers.forEach((key, producerFuture) -> {
            Producer p;
            if (producerFuture != null && producerFuture.isDone() && (p = (Producer)producerFuture.getNow(null)) != null && p.getTopic() != null) {
                p.getTopic().increasePublishLimitedTimes();
            }
        });
    }

    @Override
    public void completedSendOperation(boolean isNonPersistentTopic, int msgSize) {
        PendingBytesPerThreadTracker.getInstance().decrementPublishBytes(msgSize, this.resumeThresholdPendingBytesPerThread);
        if (--this.pendingSendRequest == this.resumeReadsThreshold) {
            this.throttleTracker.setPendingSendRequestsExceeded(false);
        }
        if (isNonPersistentTopic) {
            --this.nonPersistentPendingMessages;
        }
    }

    private <T> ServerError getErrorCode(CompletableFuture<T> future) {
        return this.getErrorCodeWithErrorLog(future, false, null);
    }

    private <T> ServerError getErrorCodeWithErrorLog(CompletableFuture<T> future, boolean logIfError, String errorMessageIfLog) {
        ServerError error;
        block3: {
            error = ServerError.UnknownError;
            try {
                future.getNow(null);
            }
            catch (Exception e) {
                if (e.getCause() instanceof BrokerServiceException) {
                    error = BrokerServiceException.getClientErrorCode(e.getCause());
                }
                if (!logIfError) break block3;
                String finalErrorMessage = StringUtils.isNotBlank((CharSequence)errorMessageIfLog) ? errorMessageIfLog : "Unknown Error";
                log.error(finalErrorMessage, (Throwable)e);
            }
        }
        return error;
    }

    private void disableTcpNoDelayIfNeeded(String topic, String producerName) {
        if (producerName != null && producerName.startsWith(this.replicatorPrefix)) {
            try {
                if (((Boolean)this.ctx.channel().config().getOption(ChannelOption.TCP_NODELAY)).booleanValue()) {
                    this.ctx.channel().config().setOption(ChannelOption.TCP_NODELAY, (Object)false);
                }
            }
            catch (Throwable t) {
                log.warn("[{}] [{}] Failed to remove TCP no-delay property on client cnx {}", new Object[]{topic, producerName, this.toString()});
            }
        }
    }

    private TopicName validateTopicName(String topic, long requestId, Object requestCommand) {
        try {
            return TopicName.get((String)topic);
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Failed to parse topic name '{}'", new Object[]{this.remoteAddress, topic, t});
            }
            if (requestCommand instanceof CommandLookupTopic) {
                this.writeAndFlush(Commands.newLookupErrorResponse((ServerError)ServerError.InvalidTopicName, (String)("Invalid topic name: " + t.getMessage()), (long)requestId));
            } else if (requestCommand instanceof CommandPartitionedTopicMetadata) {
                this.writeAndFlush(Commands.newPartitionMetadataResponse((ServerError)ServerError.InvalidTopicName, (String)("Invalid topic name: " + t.getMessage()), (long)requestId));
            } else {
                this.writeAndFlush(Commands.newError((long)requestId, (ServerError)ServerError.InvalidTopicName, (String)("Invalid topic name: " + t.getMessage())));
            }
            return null;
        }
    }

    public ByteBufPair newMessageAndIntercept(long consumerId, long ledgerId, long entryId, int partition, int redeliveryCount, ByteBuf metadataAndPayload, long[] ackSet, String topic, long epoch) {
        BaseCommand command = Commands.newMessageCommand((long)consumerId, (long)ledgerId, (long)entryId, (int)partition, (int)redeliveryCount, (long[])ackSet, (long)epoch);
        ByteBufPair res = Commands.serializeCommandMessageWithSize((BaseCommand)command, (ByteBuf)metadataAndPayload);
        if (this.brokerInterceptor != null) {
            try {
                this.brokerInterceptor.onPulsarCommand(command, this);
                CompletableFuture consumerFuture = (CompletableFuture)this.consumers.get(consumerId);
                if (consumerFuture != null && consumerFuture.isDone() && !consumerFuture.isCompletedExceptionally()) {
                    Consumer consumer = consumerFuture.getNow(null);
                    this.brokerInterceptor.messageDispatched(this, consumer, ledgerId, entryId, metadataAndPayload);
                }
            }
            catch (Exception e) {
                log.error("Exception occur when intercept messages.", (Throwable)e);
            }
        }
        return res;
    }

    public State getState() {
        return this.state;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String toString() {
        ChannelHandlerContext ctx = this.ctx();
        StringBuilder buf = new StringBuilder(166);
        if (ctx == null) {
            buf.append("[ctx: null]");
        } else {
            buf.append(ctx.channel().toString());
        }
        String clientSourceAddr = this.clientSourceAddress();
        buf.append(" [SR:").append(clientSourceAddr == null ? "-" : clientSourceAddr).append(", state:").append((Object)this.state).append("]");
        return buf.toString();
    }

    @Override
    public BrokerService getBrokerService() {
        return this.service;
    }

    public String getRole() {
        return this.authRole;
    }

    @Override
    public Promise<Void> newPromise() {
        return this.ctx.newPromise();
    }

    @Override
    public HAProxyMessage getHAProxyMessage() {
        return this.proxyMessage;
    }

    @Override
    public boolean hasHAProxyMessage() {
        return this.proxyMessage != null;
    }

    boolean hasConsumer(long consumerId) {
        return this.consumers.containsKey(consumerId);
    }

    @Override
    public boolean isBatchMessageCompatibleVersion() {
        return this.getRemoteEndpointProtocolVersion() >= ProtocolVersion.v4.getValue();
    }

    boolean supportsAuthenticationRefresh() {
        return this.features != null && this.features.isSupportsAuthRefresh();
    }

    boolean supportBrokerMetadata() {
        return this.features != null && this.features.isSupportsBrokerEntryMetadata();
    }

    boolean supportsPartialProducer() {
        return this.features != null && this.features.isSupportsPartialProducer();
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public String getProxyVersion() {
        return this.proxyVersion;
    }

    @Override
    public boolean isPreciseDispatcherFlowControl() {
        return this.preciseDispatcherFlowControl;
    }

    public AuthenticationState getAuthState() {
        return this.authState;
    }

    @Override
    public AuthenticationDataSource getAuthenticationData() {
        return this.originalAuthData != null ? this.originalAuthData : this.authenticationData;
    }

    public String getPrincipal() {
        return this.originalPrincipal != null ? this.originalPrincipal : this.authRole;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    @Override
    public String getAuthRole() {
        return this.authRole;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public ConcurrentLongHashMap<CompletableFuture<Consumer>> getConsumers() {
        return this.consumers;
    }

    public ConcurrentLongHashMap<CompletableFuture<Producer>> getProducers() {
        return this.producers;
    }

    @Override
    public PulsarCommandSender getCommandSender() {
        return this.commandSender;
    }

    @Override
    public void execute(Runnable runnable) {
        this.ctx().channel().eventLoop().execute(runnable);
    }

    @Override
    public String clientSourceAddress() {
        AuthenticationDataSource authenticationDataSource = this.getAuthData();
        if (this.proxyMessage != null) {
            return this.proxyMessage.sourceAddress();
        }
        if (this.remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)this.remoteAddress;
            return inetAddress.getAddress().getHostAddress();
        }
        return null;
    }

    @Override
    public String clientSourceAddressAndPort() {
        if (this.clientSourceAddressAndPort == null) {
            this.clientSourceAddressAndPort = this.hasHAProxyMessage() ? this.getHAProxyMessage().sourceAddress() + ":" + this.getHAProxyMessage().sourcePort() : this.clientAddress().toString();
        }
        return this.clientSourceAddressAndPort;
    }

    @Override
    public CompletableFuture<Optional<Boolean>> checkConnectionLiveness() {
        if (!this.isActive()) {
            return CompletableFuture.completedFuture(Optional.of(false));
        }
        if (this.connectionLivenessCheckTimeoutMillis > 0L) {
            return NettyFutureUtil.toCompletableFuture((Future)this.ctx.executor().submit(() -> {
                if (!this.isActive()) {
                    return CompletableFuture.completedFuture(Optional.of(false));
                }
                if (this.connectionCheckInProgress != null) {
                    return this.connectionCheckInProgress;
                }
                CompletableFuture finalConnectionCheckInProgress = new CompletableFuture();
                this.connectionCheckInProgress = finalConnectionCheckInProgress;
                this.ctx.executor().schedule(() -> {
                    if (!this.isActive()) {
                        finalConnectionCheckInProgress.complete(Optional.of(false));
                        return;
                    }
                    if (finalConnectionCheckInProgress.isDone()) {
                        return;
                    }
                    if (finalConnectionCheckInProgress == this.connectionCheckInProgress) {
                        log.warn("[{}] Connection check timed out. Closing connection.", (Object)this.toString());
                        this.ctx.close();
                    } else {
                        log.error("[{}] Reached unexpected code block. Completing connection check.", (Object)this.toString());
                        finalConnectionCheckInProgress.complete(Optional.of(true));
                    }
                }, this.connectionLivenessCheckTimeoutMillis, TimeUnit.MILLISECONDS);
                this.sendPing();
                return finalConnectionCheckInProgress;
            })).thenCompose(Function.identity());
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    protected void messageReceived() {
        super.messageReceived();
        if (this.connectionCheckInProgress != null && !this.connectionCheckInProgress.isDone()) {
            this.connectionCheckInProgress.complete(Optional.of(true));
            this.connectionCheckInProgress = null;
        }
    }

    private static void logAuthException(SocketAddress remoteAddress, String operation, String principal, Optional<TopicName> topic, Throwable ex) {
        WebApplicationException restException;
        String topicString = topic.map(t -> ", topic=" + t.toString()).orElse("");
        Throwable actEx = FutureUtil.unwrapCompletionException((Throwable)ex);
        if (actEx instanceof AuthenticationException) {
            log.info("[{}] Failed to authenticate: operation={}, principal={}{}, reason={}", new Object[]{remoteAddress, operation, principal, topicString, actEx.getMessage()});
            return;
        }
        if (actEx instanceof WebApplicationException && (restException = (WebApplicationException)actEx).getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            log.info("[{}] Trying to authenticate for a topic which under a namespace not exists: operation={}, principal={}{}, reason: {}", new Object[]{remoteAddress, operation, principal, topicString, actEx.getMessage()});
            return;
        }
        log.error("[{}] Error trying to authenticate: operation={}, principal={}{}", new Object[]{remoteAddress, operation, principal, topicString, ex});
    }

    private static void logNamespaceNameAuthException(SocketAddress remoteAddress, String operation, String principal, Optional<NamespaceName> namespaceName, Throwable ex) {
        String namespaceNameString = namespaceName.map(t -> ", namespace=" + t.toString()).orElse("");
        if (ex instanceof AuthenticationException) {
            log.info("[{}] Failed to authenticate: operation={}, principal={}{}, reason={}", new Object[]{remoteAddress, operation, principal, namespaceNameString, ex.getMessage()});
        } else {
            log.error("[{}] Error trying to authenticate: operation={}, principal={}{}", new Object[]{remoteAddress, operation, principal, namespaceNameString, ex});
        }
    }

    public boolean hasProducers() {
        return !this.producers.isEmpty();
    }

    @VisibleForTesting
    protected String getOriginalPrincipal() {
        return this.originalPrincipal;
    }

    @VisibleForTesting
    protected AuthenticationDataSource getAuthData() {
        return this.authenticationData;
    }

    @VisibleForTesting
    protected AuthenticationDataSource getOriginalAuthData() {
        return this.originalAuthData;
    }

    @VisibleForTesting
    protected AuthenticationState getOriginalAuthState() {
        return this.originalAuthState;
    }

    @VisibleForTesting
    protected void setAuthRole(String authRole) {
        this.authRole = authRole;
    }

    @Override
    public void incrementThrottleCount() {
        this.throttleTracker.incrementThrottleCount();
    }

    @Override
    public void decrementThrottleCount() {
        this.throttleTracker.decrementThrottleCount();
    }

    @VisibleForTesting
    void setAuthState(AuthenticationState authState) {
        this.authState = authState;
    }

    @Override
    @Generated
    public FeatureFlags getFeatures() {
        return this.features;
    }

    private /* synthetic */ Object lambda$handleSubscribe$24(TopicName topicName, String subscriptionName, long consumerId, Map metadata, CompletableFuture consumerFuture, long requestId, CompletableFuture existingConsumerFuture, boolean forceTopicCreation, boolean isDurable, CommandSubscribe.SubType subType, int priorityLevel, String consumerName, MessageIdImpl startMessageId, boolean readCompacted, CommandSubscribe.InitialPosition initialPosition, long startMessageRollbackDurationSec, Boolean isReplicated, KeySharedMeta keySharedMeta, Optional subscriptionProperties, long consumerEpoch, SchemaData schema, Boolean isAuthorized) {
        if (isAuthorized.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Client is authorized to subscribe with role {}", (Object)this.remoteAddress, (Object)this.getPrincipal());
            }
            log.info("[{}] Subscribing on topic {} / {}. consumerId: {}, role: {}", new Object[]{this.toString(), topicName, subscriptionName, consumerId, this.getPrincipal()});
            try {
                Metadata.validateMetadata((Map)metadata, (int)this.service.getPulsar().getConfiguration().getMaxConsumerMetadataSize());
            }
            catch (IllegalArgumentException iae) {
                String msg = iae.getMessage();
                this.consumers.remove(consumerId, (Object)consumerFuture);
                this.commandSender.sendErrorResponse(requestId, ServerError.MetadataError, msg);
                return null;
            }
            if (existingConsumerFuture != null) {
                if (!existingConsumerFuture.isDone()) {
                    log.warn("[{}][{}][{}] Consumer with id is already present on the connection, consumerId={}", new Object[]{this.remoteAddress, topicName, subscriptionName, consumerId});
                    this.commandSender.sendErrorResponse(requestId, ServerError.ServiceNotReady, "Consumer is already present on the connection");
                } else if (existingConsumerFuture.isCompletedExceptionally()) {
                    log.warn("[{}][{}][{}] A failed consumer with id is already present on the connection, consumerId={}", new Object[]{this.remoteAddress, topicName, subscriptionName, consumerId});
                    ServerError error = this.getErrorCodeWithErrorLog(existingConsumerFuture, true, String.format("A failed consumer with id is already present on the connection. consumerId: %s, remoteAddress: %s, subscription: %s", consumerId, this.remoteAddress, subscriptionName));
                    this.commandSender.sendErrorResponse(requestId, error, "Consumer that failed is already present on the connection");
                } else {
                    Consumer consumer2 = existingConsumerFuture.getNow(null);
                    log.warn("[{}] Consumer with the same id is already created: consumerId={}, consumer={}", new Object[]{this.remoteAddress, consumerId, consumer2});
                    this.commandSender.sendSuccessResponse(requestId);
                }
                return null;
            }
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.service.isAllowAutoTopicCreationAsync(topicName.toString()).thenApply(isAllowed -> forceTopicCreation && isAllowed != false)).thenCompose(createTopicIfDoesNotExist -> this.service.getTopic(topicName.toString(), (boolean)createTopicIfDoesNotExist))).thenCompose(optTopic -> {
                if (!optTopic.isPresent()) {
                    return FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicNotFoundException("Topic " + String.valueOf(topicName) + " does not exist"));
                }
                Topic topic = (Topic)optTopic.get();
                if (((AbstractTopic)topic).isConsumersExceededOnTopic()) {
                    log.warn("[{}] Attempting to add consumer to topic which reached max consumers limit", (Object)topic);
                    BrokerServiceException.ConsumerBusyException t = new BrokerServiceException.ConsumerBusyException("Topic reached max consumers limit");
                    return FutureUtil.failedFuture((Throwable)t);
                }
                return this.service.isAllowAutoSubscriptionCreationAsync(topicName).thenCompose(isAllowedAutoSubscriptionCreation -> {
                    boolean rejectSubscriptionIfDoesNotExist;
                    boolean subscriptionExists = topic.getSubscriptions().containsKey(subscriptionName);
                    if (this.getBrokerService().pulsar().getConfig().isStrictlyVerifySubscriptionName() && !subscriptionExists && !NamedEntity.isAllowed((String)subscriptionName)) {
                        return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NamingException("Please let the subscription only contains '/w(a-zA-Z_0-9)' or '_', the current value is " + subscriptionName));
                    }
                    boolean bl = rejectSubscriptionIfDoesNotExist = isDurable && isAllowedAutoSubscriptionCreation == false && !subscriptionExists && topic.isPersistent();
                    if (rejectSubscriptionIfDoesNotExist) {
                        return FutureUtil.failedFuture((Throwable)new BrokerServiceException.SubscriptionNotFoundException("Subscription does not exist"));
                    }
                    SubscriptionOption option = SubscriptionOption.builder().cnx(this).subscriptionName(subscriptionName).consumerId(consumerId).subType(subType).priorityLevel(priorityLevel).consumerName(consumerName).isDurable(isDurable).startMessageId((MessageId)startMessageId).metadata(metadata).readCompacted(readCompacted).initialPosition(initialPosition).startMessageRollbackDurationSec(startMessageRollbackDurationSec).replicatedSubscriptionStateArg(isReplicated).keySharedMeta(keySharedMeta).subscriptionProperties(subscriptionProperties).consumerEpoch(consumerEpoch).schemaType(schema == null ? null : schema.getType()).build();
                    if (schema != null && schema.getType() != SchemaType.AUTO_CONSUME) {
                        return BookkeeperSchemaStorage.ignoreUnrecoverableBKException(topic.addSchemaIfIdleOrCheckCompatible(schema)).thenCompose(v -> topic.subscribe(option));
                    }
                    return topic.subscribe(option);
                });
            })).thenAccept(consumer -> {
                if (consumer.checkAndApplyTopicMigration()) {
                    log.info("[{}] Disconnecting consumer {} on migrated subscription on topic {} / {}", new Object[]{this.remoteAddress, consumerId, subscriptionName, topicName});
                    this.consumers.remove(consumerId, (Object)consumerFuture);
                    return;
                }
                if (consumerFuture.complete(consumer)) {
                    log.info("[{}] Created subscription on topic {} / {}", new Object[]{this.remoteAddress, topicName, subscriptionName});
                    this.commandSender.sendSuccessResponse(requestId);
                    if (this.brokerInterceptor != null) {
                        try {
                            this.brokerInterceptor.consumerCreated(this, (Consumer)consumer, metadata);
                        }
                        catch (Throwable t) {
                            log.error("Exception occur when intercept consumer created.", t);
                        }
                    }
                } else {
                    try {
                        consumer.close();
                        log.info("[{}] Cleared consumer created after timeout on client side {}", (Object)this.remoteAddress, consumer);
                    }
                    catch (BrokerServiceException e) {
                        log.warn("[{}] Error closing consumer created after timeout on client side {}: {}", new Object[]{this.remoteAddress, consumer, e.getMessage()});
                    }
                    this.consumers.remove(consumerId, (Object)consumerFuture);
                }
            })).exceptionally(exception -> {
                if (exception.getCause() instanceof BrokerServiceException.ConsumerBusyException) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}][{}][{}] Failed to create consumer because exclusive consumer is already connected: {}", new Object[]{this.remoteAddress, topicName, subscriptionName, exception.getCause().getMessage()});
                    }
                } else if (exception.getCause() instanceof BrokerServiceException.TopicMigratedException) {
                    Optional<ClusterPolicies.ClusterUrl> clusterURL = PersistentTopic.getMigratedClusterUrl(this.service.getPulsar(), topicName.toString());
                    if (clusterURL.isPresent()) {
                        log.info("[{}] redirect migrated consumer to topic {}: consumerId={}, subName={}, {}", new Object[]{this.remoteAddress, topicName, consumerId, subscriptionName, exception.getCause().getMessage()});
                        boolean msgSent = this.commandSender.sendTopicMigrated(CommandTopicMigrated.ResourceType.Consumer, consumerId, clusterURL.get().getBrokerServiceUrl(), clusterURL.get().getBrokerServiceUrlTls());
                        if (!msgSent) {
                            log.info("consumer client doesn't support topic migration handling {}-{}-{}", new Object[]{topicName, this.remoteAddress, consumerId});
                        }
                        this.consumers.remove(consumerId, (Object)consumerFuture);
                        this.closeConsumer(consumerId, Optional.empty());
                        return null;
                    }
                } else if (exception.getCause() instanceof BrokerServiceException) {
                    log.warn("[{}][{}][{}] Failed to create consumer: consumerId={}, {}", new Object[]{this.remoteAddress, topicName, subscriptionName, consumerId, exception.getCause().getMessage()});
                } else {
                    log.warn("[{}][{}][{}] Failed to create consumer: consumerId={}, {}", new Object[]{this.remoteAddress, topicName, subscriptionName, consumerId, exception.getCause().getMessage(), exception});
                }
                if (consumerFuture.completeExceptionally((Throwable)exception)) {
                    this.commandSender.sendErrorResponse(requestId, BrokerServiceException.getClientErrorCode(exception.getCause()), exception.getCause().getMessage());
                }
                this.consumers.remove(consumerId, (Object)consumerFuture);
                return null;
            });
        } else {
            String msg = "Client is not authorized to subscribe";
            log.warn("[{}] {} with role {}", new Object[]{this.remoteAddress, msg, this.getPrincipal()});
            this.consumers.remove(consumerId, (Object)consumerFuture);
            this.writeAndFlush(Commands.newError((long)requestId, (ServerError)ServerError.AuthorizationError, (String)msg));
        }
        return null;
    }

    static enum State {
        Start,
        Connected,
        Failed,
        Connecting;

    }

    static final class PendingBytesPerThreadTracker {
        private static final FastThreadLocal<PendingBytesPerThreadTracker> pendingBytesPerThread = new FastThreadLocal<PendingBytesPerThreadTracker>(){

            protected PendingBytesPerThreadTracker initialValue() throws Exception {
                return new PendingBytesPerThreadTracker();
            }
        };
        private long pendingBytes;
        private boolean limitExceeded;

        PendingBytesPerThreadTracker() {
        }

        public static PendingBytesPerThreadTracker getInstance() {
            return (PendingBytesPerThreadTracker)pendingBytesPerThread.get();
        }

        public void incrementPublishBytes(long bytes, long maxPendingBytesPerThread) {
            this.pendingBytes += bytes;
            if (maxPendingBytesPerThread > 0L && this.pendingBytes > maxPendingBytesPerThread && !this.limitExceeded) {
                this.limitExceeded = true;
                ((Set)cnxsPerThread.get()).forEach(cnx -> cnx.throttleTracker.setPublishBufferLimiting(true));
            }
        }

        public void decrementPublishBytes(long bytes, long resumeThresholdPendingBytesPerThread) {
            this.pendingBytes -= bytes;
            if (this.limitExceeded && this.pendingBytes <= resumeThresholdPendingBytesPerThread) {
                this.limitExceeded = false;
                ((Set)cnxsPerThread.get()).forEach(cnx -> cnx.throttleTracker.setPublishBufferLimiting(false));
            }
        }
    }
}

