/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.util.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchRateLimiterClassicImpl
extends DispatchRateLimiter {
    private volatile RateLimiter dispatchRateLimiterOnMessage;
    private volatile RateLimiter dispatchRateLimiterOnByte;
    private static final Logger log = LoggerFactory.getLogger(DispatchRateLimiterClassicImpl.class);

    public DispatchRateLimiterClassicImpl(PersistentTopic topic, DispatchRateLimiter.Type type) {
        this(topic, null, type);
    }

    public DispatchRateLimiterClassicImpl(PersistentTopic topic, String subscriptionName, DispatchRateLimiter.Type type) {
        super(topic, subscriptionName, type);
    }

    public DispatchRateLimiterClassicImpl(BrokerService brokerService) {
        super(brokerService);
    }

    @Override
    public long getAvailableDispatchRateLimitOnMsg() {
        RateLimiter localDispatchRateLimiterOnMessage = this.dispatchRateLimiterOnMessage;
        return localDispatchRateLimiterOnMessage == null ? -1L : Math.max(localDispatchRateLimiterOnMessage.getAvailablePermits(), 0L);
    }

    @Override
    public long getAvailableDispatchRateLimitOnByte() {
        RateLimiter localDispatchRateLimiterOnByte = this.dispatchRateLimiterOnByte;
        return localDispatchRateLimiterOnByte == null ? -1L : Math.max(localDispatchRateLimiterOnByte.getAvailablePermits(), 0L);
    }

    @Override
    public void consumeDispatchQuota(long numberOfMessages, long byteSize) {
        RateLimiter localDispatchRateLimiterOnMessage = this.dispatchRateLimiterOnMessage;
        if (numberOfMessages > 0L && localDispatchRateLimiterOnMessage != null) {
            localDispatchRateLimiterOnMessage.tryAcquire(numberOfMessages);
        }
        RateLimiter localDispatchRateLimiterOnByte = this.dispatchRateLimiterOnByte;
        if (byteSize > 0L && localDispatchRateLimiterOnByte != null) {
            localDispatchRateLimiterOnByte.tryAcquire(byteSize);
        }
    }

    @Override
    public boolean isDispatchRateLimitingEnabled() {
        return this.dispatchRateLimiterOnMessage != null || this.dispatchRateLimiterOnByte != null;
    }

    @Override
    public synchronized void updateDispatchRate(DispatchRate dispatchRate) {
        Supplier<Long> permitUpdaterByte;
        Supplier<Long> permitUpdaterMsg;
        log.info("setting message-dispatch-rate {}", (Object)dispatchRate);
        long msgRate = dispatchRate.getDispatchThrottlingRateInMsg();
        long byteRate = dispatchRate.getDispatchThrottlingRateInByte();
        long ratePeriod = dispatchRate.getRatePeriodInSecond();
        Supplier<Long> supplier = permitUpdaterMsg = dispatchRate.isRelativeToPublishRate() ? () -> this.getRelativeDispatchRateInMsg(dispatchRate) : null;
        if (msgRate > 0L) {
            if (this.dispatchRateLimiterOnMessage == null) {
                this.dispatchRateLimiterOnMessage = RateLimiter.builder().scheduledExecutorService(this.brokerService.pulsar().getExecutor()).permits(msgRate).rateTime(ratePeriod).timeUnit(TimeUnit.SECONDS).permitUpdater(permitUpdaterMsg).isDispatchOrPrecisePublishRateLimiter(true).build();
            } else {
                this.dispatchRateLimiterOnMessage.setRate(msgRate, (long)dispatchRate.getRatePeriodInSecond(), TimeUnit.SECONDS, permitUpdaterMsg);
            }
        } else if (this.dispatchRateLimiterOnMessage != null) {
            this.dispatchRateLimiterOnMessage.close();
            this.dispatchRateLimiterOnMessage = null;
        }
        Supplier<Long> supplier2 = permitUpdaterByte = dispatchRate.isRelativeToPublishRate() ? () -> this.getRelativeDispatchRateInByte(dispatchRate) : null;
        if (byteRate > 0L) {
            if (this.dispatchRateLimiterOnByte == null) {
                this.dispatchRateLimiterOnByte = RateLimiter.builder().scheduledExecutorService(this.brokerService.pulsar().getExecutor()).permits(byteRate).rateTime(ratePeriod).timeUnit(TimeUnit.SECONDS).permitUpdater(permitUpdaterByte).isDispatchOrPrecisePublishRateLimiter(true).build();
            } else {
                this.dispatchRateLimiterOnByte.setRate(byteRate, (long)dispatchRate.getRatePeriodInSecond(), TimeUnit.SECONDS, permitUpdaterByte);
            }
        } else if (this.dispatchRateLimiterOnByte != null) {
            this.dispatchRateLimiterOnByte.close();
            this.dispatchRateLimiterOnByte = null;
        }
    }

    private long getRelativeDispatchRateInMsg(DispatchRate dispatchRate) {
        return this.topic != null && dispatchRate != null ? (long)this.topic.getLastUpdatedAvgPublishRateInMsg() + (long)dispatchRate.getDispatchThrottlingRateInMsg() : 0L;
    }

    private long getRelativeDispatchRateInByte(DispatchRate dispatchRate) {
        return this.topic != null && dispatchRate != null ? (long)this.topic.getLastUpdatedAvgPublishRateInByte() + dispatchRate.getDispatchThrottlingRateInByte() : 0L;
    }

    @Override
    public long getDispatchRateOnMsg() {
        RateLimiter localDispatchRateLimiterOnMessage = this.dispatchRateLimiterOnMessage;
        return localDispatchRateLimiterOnMessage != null ? localDispatchRateLimiterOnMessage.getRate() : -1L;
    }

    @Override
    public long getDispatchRateOnByte() {
        RateLimiter localDispatchRateLimiterOnByte = this.dispatchRateLimiterOnByte;
        return localDispatchRateLimiterOnByte != null ? localDispatchRateLimiterOnByte.getRate() : -1L;
    }

    @Override
    public void close() {
        if (this.dispatchRateLimiterOnMessage != null) {
            this.dispatchRateLimiterOnMessage.close();
            this.dispatchRateLimiterOnMessage = null;
        }
        if (this.dispatchRateLimiterOnByte != null) {
            this.dispatchRateLimiterOnByte.close();
            this.dispatchRateLimiterOnByte = null;
        }
    }
}

