/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.SetBackedScalingCuckooFilter;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractRareTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.LongRareTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.StringRareTerms;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class StringRareTermsAggregator
extends AbstractRareTermsAggregator {
    private final ValuesSource.Bytes valuesSource;
    private final IncludeExclude.StringFilter filter;
    private final BytesKeyedBucketOrds bucketOrds;

    StringRareTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes valuesSource, DocValueFormat format, IncludeExclude.StringFilter filter, SearchContext context, Aggregator parent, Map<String, Object> metadata, long maxDocCount, double precision, CardinalityUpperBound cardinality) throws IOException {
        super(name, factories, context, parent, metadata, maxDocCount, precision, format);
        this.valuesSource = valuesSource;
        this.filter = filter;
        this.bucketOrds = BytesKeyedBucketOrds.build(context.bigArrays(), cardinality);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        return new LeafBucketCollectorBase(sub, values){
            final BytesRefBuilder previous;
            {
                super(sub2, values2);
                this.previous = new BytesRefBuilder();
            }

            @Override
            public void collect(int docId, long owningBucketOrd) throws IOException {
                if (!values.advanceExact(docId)) {
                    return;
                }
                int valuesCount = values.docValueCount();
                this.previous.clear();
                for (int i = 0; i < valuesCount; ++i) {
                    BytesRef bytes = values.nextValue();
                    if (StringRareTermsAggregator.this.filter != null && !StringRareTermsAggregator.this.filter.accept(bytes) || i > 0 && this.previous.get().equals((Object)bytes)) continue;
                    this.previous.copyBytes(bytes);
                    long bucketOrdinal = StringRareTermsAggregator.this.bucketOrds.add(owningBucketOrd, bytes);
                    if (bucketOrdinal < 0L) {
                        bucketOrdinal = -1L - bucketOrdinal;
                        StringRareTermsAggregator.this.collectExistingBucket(sub, docId, bucketOrdinal);
                        continue;
                    }
                    StringRareTermsAggregator.this.collectBucket(sub, docId, bucketOrdinal);
                }
            }
        };
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        StringRareTerms.Bucket[][] rarestPerOrd = new StringRareTerms.Bucket[owningBucketOrds.length][];
        SetBackedScalingCuckooFilter[] filters = new SetBackedScalingCuckooFilter[owningBucketOrds.length];
        long keepCount = 0L;
        long[] mergeMap = new long[(int)this.bucketOrds.size()];
        Arrays.fill(mergeMap, -1L);
        long offset = 0L;
        for (int owningOrdIdx = 0; owningOrdIdx < owningBucketOrds.length; ++owningOrdIdx) {
            try (BytesRefHash bucketsInThisOwningBucketToCollect = new BytesRefHash(1L, this.context.bigArrays());){
                filters[owningOrdIdx] = this.newFilter();
                ArrayList<StringRareTerms.Bucket> builtBuckets = new ArrayList<StringRareTerms.Bucket>();
                BytesKeyedBucketOrds.BucketOrdsEnum collectedBuckets = this.bucketOrds.ordsEnum(owningBucketOrds[owningOrdIdx]);
                BytesRef scratch = new BytesRef();
                while (collectedBuckets.next()) {
                    collectedBuckets.readValue(scratch);
                    long docCount = this.bucketDocCount(collectedBuckets.ord());
                    if (docCount <= this.maxDocCount) {
                        StringRareTerms.Bucket bucket = new StringRareTerms.Bucket(BytesRef.deepCopyOf((BytesRef)scratch), docCount, null, this.format);
                        mergeMap[(int)collectedBuckets.ord()] = bucket.bucketOrd = offset + bucketsInThisOwningBucketToCollect.add(scratch);
                        builtBuckets.add(bucket);
                        ++keepCount;
                        continue;
                    }
                    filters[owningOrdIdx].add(scratch);
                }
                rarestPerOrd[owningOrdIdx] = builtBuckets.toArray(new StringRareTerms.Bucket[0]);
                offset += bucketsInThisOwningBucketToCollect.size();
                continue;
            }
        }
        if (keepCount != (long)mergeMap.length) {
            this.mergeBuckets(mergeMap, offset);
            if (this.deferringCollector != null) {
                this.deferringCollector.mergeBuckets(mergeMap);
            }
        }
        this.buildSubAggsForAllBuckets(rarestPerOrd, b -> b.bucketOrd, (b, aggs) -> {
            b.aggregations = aggs;
        });
        InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            Arrays.sort(rarestPerOrd[ordIdx], ORDER.comparator());
            result[ordIdx] = new StringRareTerms(this.name, ORDER, this.metadata(), this.format, Arrays.asList(rarestPerOrd[ordIdx]), this.maxDocCount, filters[ordIdx]);
        }
        return result;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new StringRareTerms(this.name, LongRareTermsAggregator.ORDER, this.metadata(), this.format, Collections.emptyList(), 0L, this.newFilter());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }
}

