/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.upgrade.post;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class UpgradeResponse
extends BroadcastResponse {
    private final Map<String, Tuple<Version, String>> versions;

    UpgradeResponse(StreamInput in) throws IOException {
        super(in);
        this.versions = in.readMap(StreamInput::readString, i -> Tuple.tuple((Object)Version.readVersion(i), (Object)i.readString()));
    }

    UpgradeResponse(Map<String, Tuple<Version, String>> versions, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.versions = versions;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.versions, StreamOutput::writeString, (o, v) -> {
            Version.writeVersion((Version)v.v1(), o);
            o.writeString((String)v.v2());
        });
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("upgraded_indices");
        for (Map.Entry<String, Tuple<Version, String>> entry : this.versions.entrySet()) {
            builder.startObject(entry.getKey());
            builder.field("upgrade_version", (ToXContent)entry.getValue().v1());
            builder.field("oldest_lucene_segment_version", (String)entry.getValue().v2());
            builder.endObject();
        }
        builder.endObject();
    }

    public Map<String, Tuple<Version, String>> versions() {
        return this.versions;
    }
}

