/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.process;

import java.io.File;
import org.apache.ranger.plugin.util.RangerMetricsUtil;
import org.apache.ranger.tagsync.process.TagSyncConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagSyncMetricsProducer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TagSyncMetricsProducer.class);
    private boolean shutdownFlag = false;

    public static void main(String[] args) {
        TagSyncMetricsProducer tagSyncMetrics = new TagSyncMetricsProducer();
        tagSyncMetrics.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block12: {
            try {
                TagSyncConfig config = TagSyncConfig.getInstance();
                long sleepTimeBetweenCycleInMillis = config.getTagSyncMetricsFrequency();
                String logFileNameWithPath = config.getTagSyncMetricsFileName();
                LOG.info("Tagsync metrics frequency :  " + sleepTimeBetweenCycleInMillis + " and metrics file : " + logFileNameWithPath);
                if (null != logFileNameWithPath) {
                    while (!this.shutdownFlag) {
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Sleeping Tagsync metrics for [" + sleepTimeBetweenCycleInMillis + "] milliSeconds");
                            }
                            Thread.sleep(sleepTimeBetweenCycleInMillis);
                        }
                        catch (InterruptedException e) {
                            LOG.error("Failed to wait for [" + sleepTimeBetweenCycleInMillis + "] milliseconds before attempting to tagsync metrics information", (Throwable)e);
                        }
                        try {
                            this.writeJVMMetrics(logFileNameWithPath, config);
                        }
                        catch (Throwable t) {
                            LOG.error("Failed to write tagsync metrics into file. Error details: ", t);
                        }
                    }
                    break block12;
                }
                LOG.info("No file directory found for tagsync metrics log ");
            }
            catch (Throwable t) {
                LOG.error("Failed to start Tagsync metrics. Error details: ", t);
            }
            finally {
                LOG.info("Shutting down the TagSync metrics thread");
            }
        }
    }

    private void writeJVMMetrics(String logFileNameWithPath, TagSyncConfig config) throws Throwable {
        try {
            File userMetricFile = null;
            userMetricFile = new File(logFileNameWithPath);
            if (!userMetricFile.exists()) {
                userMetricFile.createNewFile();
            }
            RangerMetricsUtil rangerMetricsUtil = new RangerMetricsUtil();
            if (config.getBoolean("ranger-tagsync.server.ha.enabled", false)) {
                if (config.isTagSyncServiceActive()) {
                    RangerMetricsUtil.setIsRoleActive((int)1);
                } else {
                    RangerMetricsUtil.setIsRoleActive((int)0);
                }
            }
            rangerMetricsUtil.writeMetricsToFile(userMetricFile);
        }
        catch (Throwable t) {
            LOG.error("TagSyncMetricsProducer.writeJVMMetrics() failed to write metrics into file. Error details: ", t);
            throw t;
        }
    }
}

