/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.yarn.authorizer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.security.Permission;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.authorization.yarn.authorizer.RangerYarnAccessRequest;
import org.apache.ranger.authorization.yarn.authorizer.RangerYarnAuditHandler;
import org.apache.ranger.authorization.yarn.authorizer.RangerYarnPlugin;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerYarnAuthorizer
extends YarnAuthorizationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerYarnAuthorizer.class);
    private static final Logger PERF_YARNAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"yarnauth.request");
    public static final String ACCESS_TYPE_ADMIN_QUEUE = "admin-queue";
    public static final String ACCESS_TYPE_SUBMIT_APP = "submit-app";
    public static final String ACCESS_TYPE_ADMIN = "admin";
    public static final String KEY_RESOURCE_QUEUE = "queue";
    private static volatile RangerYarnPlugin yarnPlugin = null;
    private boolean yarnAuthEnabled = true;
    private String yarnModuleName = "yarn-acl";
    private AccessControlList admins = null;
    private Map<PrivilegedEntity, Map<AccessType, AccessControlList>> yarnAcl = new HashMap<PrivilegedEntity, Map<AccessType, AccessControlList>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init(Configuration conf) {
        RangerYarnPlugin plugin;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuthorizer.init()");
        }
        if ((plugin = yarnPlugin) == null) {
            Class<RangerYarnAuthorizer> clazz = RangerYarnAuthorizer.class;
            // MONITORENTER : org.apache.ranger.authorization.yarn.authorizer.RangerYarnAuthorizer.class
            plugin = yarnPlugin;
            if (plugin == null) {
                plugin = new RangerYarnPlugin();
                plugin.init();
                yarnPlugin = plugin;
            }
            // MONITOREXIT : clazz
        }
        RangerPluginConfig pluginConfig = yarnPlugin.getConfig();
        this.yarnAuthEnabled = pluginConfig.getBoolean("ranger.add-yarn-authorization", true);
        this.yarnModuleName = pluginConfig.get("ranger.auditlog.yarnAcl.name", "yarn-acl");
        pluginConfig.setIsFallbackSupported(this.yarnAuthEnabled);
        if (!LOG.isDebugEnabled()) return;
        LOG.debug("<== RangerYarnAuthorizer.init()");
    }

    public boolean checkPermission(AccessRequest accessRequest) {
        AccessType accessType = accessRequest.getAccessType();
        PrivilegedEntity entity = accessRequest.getEntity();
        UserGroupInformation ugi = accessRequest.getUser();
        List forwardedAddresses = accessRequest.getForwardedAddresses();
        String remoteIpAddress = accessRequest.getRemoteAddress();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuthorizer.checkPermission(" + accessType + ", " + this.toString(entity) + ", " + ugi + ")");
        }
        boolean ret = false;
        RangerYarnPlugin plugin = yarnPlugin;
        RangerYarnAuditHandler auditHandler = null;
        RangerAccessResult result = null;
        RangerPerfTracer perf = null;
        RangerPerfTracer yarnAclPerf = null;
        if (plugin != null) {
            if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_YARNAUTH_REQUEST_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Logger)PERF_YARNAUTH_REQUEST_LOG, (String)("RangerYarnAuthorizer.checkPermission(entity=" + entity + ")"));
            }
            RangerYarnAccessRequest request = new RangerYarnAccessRequest(entity, RangerYarnAuthorizer.getRangerAccessType(accessType), accessType.name(), ugi, forwardedAddresses, remoteIpAddress);
            auditHandler = new RangerYarnAuditHandler(this.yarnModuleName);
            result = plugin.isAccessAllowed((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
        }
        if (this.yarnAuthEnabled && (result == null || !result.getIsAccessDetermined())) {
            if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_YARNAUTH_REQUEST_LOG)) {
                yarnAclPerf = RangerPerfTracer.getPerfTracer((Logger)PERF_YARNAUTH_REQUEST_LOG, (String)("RangerYarnNativeAuthorizer.isAllowedByYarnAcl(entity=" + entity + ")"));
            }
            ret = this.isAllowedByYarnAcl(accessType, entity, ugi, auditHandler);
        } else {
            boolean bl = ret = result != null && result.getIsAllowed();
        }
        if (auditHandler != null) {
            auditHandler.flushAudit();
        }
        RangerPerfTracer.log(yarnAclPerf);
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuthorizer.checkPermission(" + accessType + ", " + this.toString(entity) + ", " + ugi + "): " + ret);
        }
        return ret;
    }

    public boolean isAdmin(UserGroupInformation ugi) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuthorizer.isAdmin(" + ugi + ")");
        }
        boolean ret = false;
        AccessControlList admins = this.admins;
        if (admins != null) {
            ret = admins.isUserAllowed(ugi);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuthorizer.isAdmin(" + ugi + "): " + ret);
        }
        return ret;
    }

    public void setAdmins(AccessControlList acl, UserGroupInformation ugi) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuthorizer.setAdmins(" + acl + ", " + ugi + ")");
        }
        this.admins = acl;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuthorizer.setAdmins(" + acl + ", " + ugi + ")");
        }
    }

    public void setPermission(List<Permission> permissions, UserGroupInformation ugi) {
        for (Permission permission : permissions) {
            this.setPermission(permission.getTarget(), permission.getAcls(), ugi);
        }
    }

    private void setPermission(PrivilegedEntity entity, Map<AccessType, AccessControlList> permission, UserGroupInformation ugi) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuthorizer.setPermission(" + this.toString(entity) + ", " + permission + ", " + ugi + ")");
        }
        this.yarnAcl.put(entity, permission);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuthorizer.setPermission(" + this.toString(entity) + ", " + permission + ", " + ugi + ")");
        }
    }

    public boolean isAllowedByYarnAcl(AccessType accessType, PrivilegedEntity entity, UserGroupInformation ugi, RangerYarnAuditHandler auditHandler) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerYarnAuthorizer.isAllowedByYarnAcl(" + accessType + ", " + this.toString(entity) + ", " + ugi + ")");
        }
        boolean ret = false;
        for (Map.Entry<PrivilegedEntity, Map<AccessType, AccessControlList>> e : this.yarnAcl.entrySet()) {
            PrivilegedEntity aclEntity = e.getKey();
            Map<AccessType, AccessControlList> entityPermissions = e.getValue();
            AccessControlList acl = entityPermissions == null ? null : entityPermissions.get(accessType);
            if (acl == null || !acl.isUserAllowed(ugi) || !this.isSelfOrChildOf(entity, aclEntity)) continue;
            ret = true;
            break;
        }
        if (auditHandler != null) {
            auditHandler.logYarnAclEvent(ret);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerYarnAuthorizer.isAllowedByYarnAcl(" + accessType + ", " + this.toString(entity) + ", " + ugi + "): " + ret);
        }
        return ret;
    }

    private static String getRangerAccessType(AccessType accessType) {
        String ret = null;
        switch (accessType) {
            case ADMINISTER_QUEUE: {
                ret = ACCESS_TYPE_ADMIN_QUEUE;
                break;
            }
            case SUBMIT_APP: {
                ret = ACCESS_TYPE_SUBMIT_APP;
            }
        }
        return ret;
    }

    private boolean isSelfOrChildOf(PrivilegedEntity queue, PrivilegedEntity parentQueue) {
        boolean ret = queue.equals((Object)parentQueue);
        if (!ret && queue.getType() == PrivilegedEntity.EntityType.QUEUE) {
            String queueName = queue.getName();
            String parentQueueName = parentQueue.getName();
            if (queueName.contains(".") && !StringUtil.isEmpty((String)parentQueueName)) {
                if (parentQueueName.charAt(parentQueueName.length() - 1) != '.') {
                    parentQueueName = parentQueueName + ".";
                }
                ret = queueName.startsWith(parentQueueName);
            }
        }
        return ret;
    }

    private String toString(PrivilegedEntity entity) {
        if (entity != null) {
            return "{name=" + entity.getName() + "; type=" + entity.getType() + "}";
        }
        return "null";
    }
}

