/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.kms.metrics;

import java.util.ArrayList;
import java.util.Map;
import org.apache.ranger.kms.metrics.collector.KMSMetricsCollector;
import org.apache.ranger.kms.metrics.source.KMSMetricSource;
import org.apache.ranger.metrics.RangerMetricsSystemWrapper;
import org.apache.ranger.metrics.source.RangerMetricsSource;
import org.apache.ranger.metrics.wrapper.RangerMetricsSourceWrapper;
import org.apache.ranger.plugin.util.JsonUtilsV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMSMetricWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(KMSMetricWrapper.class);
    private static final Logger KMS_METRICS_LOGGER = LoggerFactory.getLogger((String)"kms-metrics");
    private KMSMetricSource kmsMetricSource;
    private final RangerMetricsSystemWrapper rangerMetricsSystemWrapper;
    private final KMSMetricsCollector kmsMetricsCollector;
    private static volatile KMSMetricWrapper instance;

    private KMSMetricWrapper(boolean isMetricCollectionThreadSafe) {
        LOG.info("Creating KMSMetricWrapper with thread-safe value=" + isMetricCollectionThreadSafe);
        this.rangerMetricsSystemWrapper = new RangerMetricsSystemWrapper();
        this.kmsMetricsCollector = KMSMetricsCollector.getInstance(isMetricCollectionThreadSafe);
        this.kmsMetricSource = new KMSMetricSource("kms", "KMS", this.kmsMetricsCollector);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KMSMetricWrapper getInstance(boolean isMetricCollectionThreadSafe) {
        if (null != instance) return instance;
        Class<KMSMetricWrapper> clazz = KMSMetricWrapper.class;
        synchronized (KMSMetricWrapper.class) {
            if (null != instance) return instance;
            instance = new KMSMetricWrapper(isMetricCollectionThreadSafe);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("===>> KMSMetricWrapper.init()");
        }
        ArrayList<RangerMetricsSourceWrapper> sourceWrappers = new ArrayList<RangerMetricsSourceWrapper>();
        sourceWrappers.add(new RangerMetricsSourceWrapper("KMSMetricSource", "KMS metrics", "kms", (RangerMetricsSource)this.kmsMetricSource));
        this.rangerMetricsSystemWrapper.init("kms", sourceWrappers, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<<=== KMSMetricWrapper.init()");
        }
    }

    public String getRangerMetricsInPrometheusFormat() throws Exception {
        return this.rangerMetricsSystemWrapper.getRangerMetricsInPrometheusFormat();
    }

    public Map<String, Map<String, Object>> getRangerMetricsInJsonFormat() {
        return this.rangerMetricsSystemWrapper.getRangerMetrics();
    }

    public KMSMetricsCollector getKmsMetricsCollector() {
        return this.kmsMetricsCollector;
    }

    public void writeJsonMetricsToFile() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("===>> KMSMetricWrapper.writeJsonMetricsToFile()");
        }
        try {
            KMS_METRICS_LOGGER.info(JsonUtilsV2.mapToJson(this.getRangerMetricsInJsonFormat()));
        }
        catch (Exception e) {
            LOG.error("Error while writing metrics to metrics-log file", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<<=== KMSMetricWrapper.writeJsonMetricsToFile()");
        }
    }
}

