/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.nestedstructure.authorizer;

import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ranger.authorization.nestedstructure.authorizer.DataMasker;
import org.apache.ranger.authorization.nestedstructure.authorizer.FieldLevelAccess;
import org.apache.ranger.authorization.nestedstructure.authorizer.MaskingException;

public class JsonManipulator {
    private final DocumentContext documentContext;
    private final DocumentContext fieldContextDocument;
    private final Set<String> fields;

    public JsonManipulator(String jsonString) {
        this.checkIsValidJson(jsonString);
        this.documentContext = JsonPath.parse((String)jsonString);
        Configuration conf = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build();
        this.fieldContextDocument = JsonPath.using((Configuration)conf).parse(jsonString);
        ArrayList<String> leafPathList = (ArrayList<String>)this.fieldContextDocument.read("$..*", new Predicate[0]);
        Collections.sort(leafPathList);
        ArrayList<String> filteredList = new ArrayList<String>();
        for (int i = 0; i < leafPathList.size(); ++i) {
            String current = (String)leafPathList.get(i);
            if (i + 1 < leafPathList.size()) {
                String next = (String)leafPathList.get(i + 1);
                if (next.startsWith(current)) continue;
                filteredList.add(current);
                continue;
            }
            filteredList.add(current);
        }
        leafPathList = filteredList;
        Stream<String> newList = leafPathList.stream().map(path -> path.replaceAll("\\[[0-9]+\\]", ".*").replaceAll("\\$\\['", "").replaceAll("'\\]\\['", ".").replaceAll("\\*\\['", "*.").replaceAll("'\\]", ""));
        this.fields = newList.collect(Collectors.toSet());
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public void maskFields(List<FieldLevelAccess> fieldAccess) {
        Stream<FieldLevelAccess> maskedFields = fieldAccess.stream().filter(fa -> fa.hasAccess && fa.isMasked);
        maskedFields.forEach(fa -> this.getMatchingFields(fa.field).forEach(fullFieldPath -> {
            Object maskedValue;
            Object realValue = this.documentContext.read(fullFieldPath, new Predicate[0]);
            if (realValue instanceof String) {
                maskedValue = DataMasker.maskString((String)realValue, fa.maskType, fa.customMaskedValue);
            } else if (realValue instanceof Number) {
                maskedValue = DataMasker.maskNumber((Number)realValue, fa.maskType, fa.customMaskedValue);
            } else if (realValue instanceof Boolean) {
                maskedValue = DataMasker.maskBoolean((Boolean)realValue, fa.maskType, fa.customMaskedValue);
            } else {
                throw new MaskingException("unable to determine field type: " + realValue);
            }
            this.documentContext.set(fullFieldPath, maskedValue, new Predicate[0]);
        }));
    }

    public String getJsonString() {
        return this.documentContext.jsonString();
    }

    String readString(String fullPath) {
        return this.documentContext.read(fullPath, new Predicate[0]).toString();
    }

    private void checkIsValidJson(String jsonString) {
        try {
            JsonParser.parseString((String)jsonString);
        }
        catch (JsonSyntaxException e) {
            throw new MaskingException("invalid input json; unable to mask", (Exception)((Object)e));
        }
    }

    private List<String> getMatchingFields(String fieldPath) {
        return (List)this.fieldContextDocument.read("$." + fieldPath, new Predicate[0]);
    }
}

