/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.resourcematcher.AbstractStringResourceMatcher;

final class QuotedCaseSensitiveStartsWithMatcher
extends AbstractStringResourceMatcher {
    private final String quoteChars;

    QuotedCaseSensitiveStartsWithMatcher(String value, Map<String, String> options, String quoteChars) {
        super(value, options);
        this.quoteChars = quoteChars;
    }

    @Override
    boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
        if (QuotedCaseSensitiveStartsWithMatcher.startsWithAnyChar(resourceValue, this.quoteChars)) {
            return StringUtils.startsWith((String)resourceValue, (String)this.getExpandedValue(evalContext));
        }
        return StringUtils.startsWithIgnoreCase((String)resourceValue, (String)this.getExpandedValue(evalContext));
    }

    @Override
    public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
        if (QuotedCaseSensitiveStartsWithMatcher.startsWithAnyChar(resourceValue, this.quoteChars)) {
            return StringUtils.startsWith((String)this.getExpandedValue(evalContext), (String)resourceValue);
        }
        return StringUtils.startsWithIgnoreCase((String)this.getExpandedValue(evalContext), (String)resourceValue);
    }

    @Override
    int getPriority() {
        return 4 + (this.getNeedsDynamicEval() ? 8 : 0);
    }
}

