/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.nio.channels.ClosedByInterruptException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreRetriever;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAdminUserStoreRetriever
extends RangerUserStoreRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAdminUserStoreRetriever.class);
    private RangerAdminClient adminClient;

    @Override
    public void init(Map<String, String> options) {
        if (StringUtils.isNotBlank((String)this.serviceName) && this.serviceDef != null && StringUtils.isNotBlank((String)this.appId)) {
            RangerPluginContext pluginContext;
            RangerAdminClient rangerAdmin;
            RangerPluginConfig pluginConfig = this.pluginConfig;
            if (pluginConfig == null) {
                pluginConfig = new RangerPluginConfig(this.serviceDef.getName(), this.serviceName, this.appId, null, null, null);
            }
            this.adminClient = (rangerAdmin = (pluginContext = this.getPluginContext()).getAdminClient()) != null ? rangerAdmin : pluginContext.createAdminClient(pluginConfig);
        } else {
            LOG.error("FATAL: Cannot find service/serviceDef to use for retrieving userstore. Will NOT be able to retrieve userstore.");
        }
    }

    @Override
    public RangerUserStore retrieveUserStoreInfo(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        RangerUserStore rangerUserStore = null;
        if (this.adminClient != null) {
            try {
                rangerUserStore = this.adminClient.getUserStoreIfUpdated(lastKnownVersion, lastActivationTimeInMillis);
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                LOG.error("UserStore-retriever thread was interrupted while blocked on I/O");
                throw new InterruptedException();
            }
            catch (Exception e) {
                LOG.error("UserStore-retriever encounterd exception, exception=", (Throwable)e);
                LOG.error("Returning null userstore info");
            }
        }
        return rangerUserStore;
    }
}

