/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerAdminConfig;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.store.EmbeddedServiceDefsUtil;
import org.apache.ranger.plugin.store.PList;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.util.SearchFilter;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceStore
implements ServiceStore {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServiceStore.class);
    public static final String COMPONENT_ACCESSTYPE_SEPARATOR = ":";
    public static final String AUTOPROPAGATE_ROWFILTERDEF_TO_TAG_PROP = "ranger.servicedef.autopropagate.rowfilterdef.to.tag";
    public static final boolean AUTOPROPAGATE_ROWFILTERDEF_TO_TAG_PROP_DEFAULT = false;
    private static final int MAX_ACCESS_TYPES_IN_SERVICE_DEF = 1000;
    private final RangerAdminConfig config = RangerAdminConfig.getInstance();

    protected abstract void updateServicesForServiceDefUpdate(RangerServiceDef var1) throws Exception;

    protected AbstractServiceStore() {
    }

    @Override
    public void updateTagServiceDefForAccessTypes() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> ServiceDefDBStore.updateTagServiceDefForAccessTypes()");
        }
        List<RangerServiceDef> allServiceDefs = this.getServiceDefs(new SearchFilter());
        for (RangerServiceDef serviceDef : allServiceDefs) {
            if (!ServiceDefUtil.getOption_enableTagBasedPolicies(serviceDef, this.config)) continue;
            this.updateTagServiceDefForUpdatingAccessTypes(serviceDef);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== ServiceDefDBStore.updateTagServiceDefForAccessTypes()");
        }
    }

    @Override
    public PList<RangerServiceDef> getPaginatedServiceDefs(SearchFilter filter) throws Exception {
        List<RangerServiceDef> resultList = this.getServiceDefs(filter);
        return CollectionUtils.isEmpty(resultList) ? new PList<RangerServiceDef>() : new PList<RangerServiceDef>(resultList, 0, resultList.size(), resultList.size(), resultList.size(), filter.getSortType(), filter.getSortBy());
    }

    @Override
    public PList<RangerService> getPaginatedServices(SearchFilter filter) throws Exception {
        List<RangerService> resultList = this.getServices(filter);
        return CollectionUtils.isEmpty(resultList) ? new PList<RangerService>() : new PList<RangerService>(resultList, 0, resultList.size(), resultList.size(), resultList.size(), filter.getSortType(), filter.getSortBy());
    }

    @Override
    public PList<RangerPolicy> getPaginatedPolicies(SearchFilter filter) throws Exception {
        List<RangerPolicy> resultList = this.getPolicies(filter);
        return CollectionUtils.isEmpty(resultList) ? new PList<RangerPolicy>() : new PList<RangerPolicy>(resultList, 0, resultList.size(), resultList.size(), resultList.size(), filter.getSortType(), filter.getSortBy());
    }

    @Override
    public PList<RangerPolicy> getPaginatedServicePolicies(Long serviceId, SearchFilter filter) throws Exception {
        List<RangerPolicy> resultList = this.getServicePolicies(serviceId, filter);
        return CollectionUtils.isEmpty(resultList) ? new PList<RangerPolicy>() : new PList<RangerPolicy>(resultList, 0, resultList.size(), resultList.size(), resultList.size(), filter.getSortType(), filter.getSortBy());
    }

    @Override
    public PList<RangerPolicy> getPaginatedServicePolicies(String serviceName, SearchFilter filter) throws Exception {
        List<RangerPolicy> resultList = this.getServicePolicies(serviceName, filter);
        return CollectionUtils.isEmpty(resultList) ? new PList<RangerPolicy>() : new PList<RangerPolicy>(resultList, 0, resultList.size(), resultList.size(), resultList.size(), filter.getSortType(), filter.getSortBy());
    }

    @Override
    public Long getServicePolicyVersion(String serviceName) {
        RangerService service = null;
        try {
            service = this.getServiceByName(serviceName);
        }
        catch (Exception exception) {
            LOG.error("Failed to get service object for service:" + serviceName);
        }
        return service != null ? service.getPolicyVersion() : null;
    }

    protected void postCreate(RangerBaseModelObject obj) throws Exception {
        if (obj instanceof RangerServiceDef) {
            this.updateTagServiceDefForUpdatingAccessTypes((RangerServiceDef)obj);
        }
    }

    protected void postUpdate(RangerBaseModelObject obj) throws Exception {
        if (obj instanceof RangerServiceDef) {
            RangerServiceDef serviceDef = (RangerServiceDef)obj;
            this.updateTagServiceDefForUpdatingAccessTypes(serviceDef);
            this.updateServicesForServiceDefUpdate(serviceDef);
        }
    }

    protected void postDelete(RangerBaseModelObject obj) throws Exception {
        if (obj instanceof RangerServiceDef) {
            this.updateTagServiceDefForDeletingAccessTypes(((RangerServiceDef)obj).getName());
        }
    }

    public static long getNextVersion(Long currentVersion) {
        return currentVersion == null ? 1L : currentVersion + 1L;
    }

    private RangerServiceDef.RangerAccessTypeDef findAccessTypeDef(long itemId, List<RangerServiceDef.RangerAccessTypeDef> accessTypeDefs) {
        RangerServiceDef.RangerAccessTypeDef ret = null;
        for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : accessTypeDefs) {
            if (itemId != accessTypeDef.getItemId()) continue;
            ret = accessTypeDef;
            break;
        }
        return ret;
    }

    private boolean updateTagAccessTypeDef(RangerServiceDef.RangerAccessTypeDef tagAccessType, RangerServiceDef.RangerAccessTypeDef svcAccessType, String prefix) {
        boolean isUpdated = false;
        if (!Objects.equals(tagAccessType.getName().substring(prefix.length()), svcAccessType.getName())) {
            isUpdated = true;
        } else if (!Objects.equals(tagAccessType.getLabel(), svcAccessType.getLabel())) {
            isUpdated = true;
        } else if (!Objects.equals(tagAccessType.getRbKeyLabel(), svcAccessType.getRbKeyLabel())) {
            isUpdated = true;
        } else {
            int svcImpliedGrantsLen;
            Collection<String> tagImpliedGrants = tagAccessType.getImpliedGrants();
            Collection<String> svcImpliedGrants = svcAccessType.getImpliedGrants();
            int tagImpliedGrantsLen = tagImpliedGrants == null ? 0 : tagImpliedGrants.size();
            int n = svcImpliedGrantsLen = svcImpliedGrants == null ? 0 : svcImpliedGrants.size();
            if (tagImpliedGrantsLen != svcImpliedGrantsLen) {
                isUpdated = true;
            } else if (tagImpliedGrantsLen > 0) {
                for (String svcImpliedGrant : svcImpliedGrants) {
                    if (tagImpliedGrants.contains(prefix + svcImpliedGrant)) continue;
                    isUpdated = true;
                    break;
                }
            }
        }
        if (isUpdated) {
            tagAccessType.setName(prefix + svcAccessType.getName());
            tagAccessType.setLabel(svcAccessType.getLabel());
            tagAccessType.setRbKeyLabel(svcAccessType.getRbKeyLabel());
            tagAccessType.setImpliedGrants(new HashSet<String>());
            if (CollectionUtils.isNotEmpty(svcAccessType.getImpliedGrants())) {
                for (String svcImpliedGrant : svcAccessType.getImpliedGrants()) {
                    tagAccessType.getImpliedGrants().add(prefix + svcImpliedGrant);
                }
            }
        }
        return isUpdated;
    }

    private boolean updateTagAccessTypeDefs(List<RangerServiceDef.RangerAccessTypeDef> svcDefAccessTypes, List<RangerServiceDef.RangerAccessTypeDef> tagDefAccessTypes, long itemIdOffset, String prefix) {
        ArrayList<RangerServiceDef.RangerAccessTypeDef> toAdd = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        ArrayList<RangerServiceDef.RangerAccessTypeDef> toUpdate = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        ArrayList<RangerServiceDef.RangerAccessTypeDef> toDelete = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        for (RangerServiceDef.RangerAccessTypeDef svcAccessType : svcDefAccessTypes) {
            long tagAccessTypeItemId = svcAccessType.getItemId() + itemIdOffset;
            RangerServiceDef.RangerAccessTypeDef tagAccessType = this.findAccessTypeDef(tagAccessTypeItemId, tagDefAccessTypes);
            if (tagAccessType != null) continue;
            tagAccessType = new RangerServiceDef.RangerAccessTypeDef();
            tagAccessType.setItemId(tagAccessTypeItemId);
            tagAccessType.setName(prefix + svcAccessType.getName());
            tagAccessType.setLabel(svcAccessType.getLabel());
            tagAccessType.setRbKeyLabel(svcAccessType.getRbKeyLabel());
            tagAccessType.setCategory(svcAccessType.getCategory());
            tagAccessType.setImpliedGrants(new HashSet<String>());
            if (CollectionUtils.isNotEmpty(svcAccessType.getImpliedGrants())) {
                for (String svcImpliedGrant : svcAccessType.getImpliedGrants()) {
                    tagAccessType.getImpliedGrants().add(prefix + svcImpliedGrant);
                }
            }
            toAdd.add(tagAccessType);
        }
        for (RangerServiceDef.RangerAccessTypeDef tagAccessType : tagDefAccessTypes) {
            if (!tagAccessType.getName().startsWith(prefix)) continue;
            long svcAccessTypeItemId = tagAccessType.getItemId() - itemIdOffset;
            RangerServiceDef.RangerAccessTypeDef svcAccessType = this.findAccessTypeDef(svcAccessTypeItemId, svcDefAccessTypes);
            if (svcAccessType == null) {
                toDelete.add(tagAccessType);
                continue;
            }
            if (!this.updateTagAccessTypeDef(tagAccessType, svcAccessType, prefix)) continue;
            toUpdate.add(tagAccessType);
        }
        boolean updateNeeded = false;
        if (CollectionUtils.isNotEmpty(toAdd) || CollectionUtils.isNotEmpty(toUpdate) || CollectionUtils.isNotEmpty(toDelete)) {
            if (LOG.isDebugEnabled()) {
                for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : toDelete) {
                    LOG.debug("accessTypeDef-to-delete:[" + accessTypeDef + "]");
                }
                for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : toUpdate) {
                    LOG.debug("accessTypeDef-to-update:[" + accessTypeDef + "]");
                }
                for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : toAdd) {
                    LOG.debug("accessTypeDef-to-add:[" + accessTypeDef + "]");
                }
            }
            tagDefAccessTypes.addAll(toAdd);
            tagDefAccessTypes.removeAll(toDelete);
            updateNeeded = true;
        }
        return updateNeeded;
    }

    private void updateTagServiceDefForUpdatingAccessTypes(RangerServiceDef serviceDef) throws Exception {
        RangerServiceDef tagServiceDef;
        if (StringUtils.equals((String)serviceDef.getName(), (String)"tag")) {
            return;
        }
        if (EmbeddedServiceDefsUtil.instance().getTagServiceDefId() == -1L) {
            LOG.info("AbstractServiceStore.updateTagServiceDefForUpdatingAccessTypes(" + serviceDef.getName() + "): tag service-def does not exist");
        }
        try {
            tagServiceDef = this.getServiceDef(EmbeddedServiceDefsUtil.instance().getTagServiceDefId());
        }
        catch (Exception e) {
            LOG.error("AbstractServiceStore.updateTagServiceDefForUpdatingAccessTypes" + serviceDef.getName() + "): could not find TAG ServiceDef.. ", (Throwable)e);
            throw e;
        }
        if (tagServiceDef == null) {
            LOG.error("AbstractServiceStore.updateTagServiceDefForUpdatingAccessTypes(" + serviceDef.getName() + "): could not find TAG ServiceDef.. ");
            return;
        }
        String serviceDefName = serviceDef.getName();
        String prefix = serviceDefName + COMPONENT_ACCESSTYPE_SEPARATOR;
        List<RangerServiceDef.RangerAccessTypeDef> svcDefAccessTypes = serviceDef.getAccessTypes();
        List<RangerServiceDef.RangerAccessTypeDef> tagDefAccessTypes = tagServiceDef.getAccessTypes();
        long itemIdOffset = serviceDef.getId() * 1001L;
        boolean updateNeeded = this.updateTagAccessTypeDefs(svcDefAccessTypes, tagDefAccessTypes, itemIdOffset, prefix);
        if (this.updateTagServiceDefForUpdatingDataMaskDef(tagServiceDef, serviceDef, itemIdOffset, prefix)) {
            updateNeeded = true;
        }
        if (this.updateTagServiceDefForUpdatingRowFilterDef(tagServiceDef, serviceDef, itemIdOffset, prefix)) {
            updateNeeded = true;
        }
        boolean resourceUpdated = this.updateResourceInTagServiceDef(tagServiceDef);
        boolean bl = updateNeeded = updateNeeded || resourceUpdated;
        if (updateNeeded) {
            try {
                this.updateServiceDef(tagServiceDef);
                LOG.info("AbstractServiceStore.updateTagServiceDefForUpdatingAccessTypes -- updated TAG service def with " + serviceDefName + " access types");
            }
            catch (Exception e) {
                LOG.error("AbstractServiceStore.updateTagServiceDefForUpdatingAccessTypes -- Failed to update TAG ServiceDef.. ", (Throwable)e);
                throw e;
            }
        }
    }

    private void updateTagServiceDefForDeletingAccessTypes(String serviceDefName) throws Exception {
        RangerServiceDef tagServiceDef;
        if ("tag".equals(serviceDefName)) {
            return;
        }
        try {
            tagServiceDef = this.getServiceDef(EmbeddedServiceDefsUtil.instance().getTagServiceDefId());
        }
        catch (Exception e) {
            LOG.error("AbstractServiceStore.updateTagServiceDefForDeletingAccessTypes(" + serviceDefName + "): could not find TAG ServiceDef.. ", (Throwable)e);
            throw e;
        }
        if (tagServiceDef == null) {
            LOG.error("AbstractServiceStore.updateTagServiceDefForDeletingAccessTypes(" + serviceDefName + "): could not find TAG ServiceDef.. ");
            return;
        }
        ArrayList<RangerServiceDef.RangerAccessTypeDef> accessTypes = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        for (RangerServiceDef.RangerAccessTypeDef accessType : tagServiceDef.getAccessTypes()) {
            if (!accessType.getName().startsWith(serviceDefName + COMPONENT_ACCESSTYPE_SEPARATOR)) continue;
            accessTypes.add(accessType);
        }
        tagServiceDef.getAccessTypes().removeAll(accessTypes);
        this.updateTagServiceDefForDeletingDataMaskDef(tagServiceDef, serviceDefName);
        this.updateTagServiceDefForDeletingRowFilterDef(tagServiceDef, serviceDefName);
        this.updateResourceInTagServiceDef(tagServiceDef);
        try {
            this.updateServiceDef(tagServiceDef);
            LOG.info("AbstractServiceStore.updateTagServiceDefForDeletingAccessTypes -- updated TAG service def with " + serviceDefName + " access types");
        }
        catch (Exception e) {
            LOG.error("AbstractServiceStore.updateTagServiceDefForDeletingAccessTypes -- Failed to update TAG ServiceDef.. ", (Throwable)e);
            throw e;
        }
    }

    private boolean updateTagServiceDefForUpdatingDataMaskDef(RangerServiceDef tagServiceDef, RangerServiceDef serviceDef, long itemIdOffset, String prefix) {
        boolean tagMaskDefAccessTypesUpdated;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AbstractServiceStore.updateTagServiceDefForUpdatingDataMaskDef(" + serviceDef.getName() + ")");
        }
        boolean ret = false;
        RangerServiceDef.RangerDataMaskDef svcDataMaskDef = serviceDef.getDataMaskDef();
        RangerServiceDef.RangerDataMaskDef tagDataMaskDef = tagServiceDef.getDataMaskDef();
        List<RangerServiceDef.RangerDataMaskTypeDef> svcDefMaskTypes = svcDataMaskDef.getMaskTypes();
        List<RangerServiceDef.RangerDataMaskTypeDef> tagDefMaskTypes = tagDataMaskDef.getMaskTypes();
        List<RangerServiceDef.RangerAccessTypeDef> svcDefAccessTypes = svcDataMaskDef.getAccessTypes();
        List<RangerServiceDef.RangerAccessTypeDef> tagDefAccessTypes = tagDataMaskDef.getAccessTypes();
        ArrayList<RangerServiceDef.RangerDataMaskTypeDef> maskTypesToAdd = new ArrayList<RangerServiceDef.RangerDataMaskTypeDef>();
        ArrayList<RangerServiceDef.RangerDataMaskTypeDef> maskTypesToUpdate = new ArrayList<RangerServiceDef.RangerDataMaskTypeDef>();
        ArrayList<RangerServiceDef.RangerDataMaskTypeDef> maskTypesToDelete = new ArrayList<RangerServiceDef.RangerDataMaskTypeDef>();
        for (RangerServiceDef.RangerDataMaskTypeDef svcMaskType : svcDefMaskTypes) {
            long tagMaskTypeItemId = itemIdOffset + svcMaskType.getItemId();
            RangerServiceDef.RangerDataMaskTypeDef foundTagMaskType = null;
            for (RangerServiceDef.RangerDataMaskTypeDef tagMaskType : tagDefMaskTypes) {
                if (!tagMaskType.getItemId().equals(tagMaskTypeItemId)) continue;
                foundTagMaskType = tagMaskType;
                break;
            }
            if (foundTagMaskType != null) continue;
            RangerServiceDef.RangerDataMaskTypeDef tagMaskType = new RangerServiceDef.RangerDataMaskTypeDef(svcMaskType);
            tagMaskType.setName(prefix + svcMaskType.getName());
            tagMaskType.setItemId(itemIdOffset + svcMaskType.getItemId());
            tagMaskType.setLabel(svcMaskType.getLabel());
            tagMaskType.setRbKeyLabel(svcMaskType.getRbKeyLabel());
            maskTypesToAdd.add(tagMaskType);
        }
        for (RangerServiceDef.RangerDataMaskTypeDef tagMaskType : tagDefMaskTypes) {
            if (!StringUtils.startsWith((String)tagMaskType.getName(), (String)prefix)) continue;
            RangerServiceDef.RangerDataMaskTypeDef foundSvcMaskType = null;
            for (RangerServiceDef.RangerDataMaskTypeDef svcMaskType : svcDefMaskTypes) {
                long tagMaskTypeItemId = itemIdOffset + svcMaskType.getItemId();
                if (!tagMaskType.getItemId().equals(tagMaskTypeItemId)) continue;
                foundSvcMaskType = svcMaskType;
                break;
            }
            if (foundSvcMaskType == null) {
                maskTypesToDelete.add(tagMaskType);
                continue;
            }
            RangerServiceDef.RangerDataMaskTypeDef checkTagMaskType = new RangerServiceDef.RangerDataMaskTypeDef(foundSvcMaskType);
            checkTagMaskType.setName(prefix + foundSvcMaskType.getName());
            checkTagMaskType.setItemId(itemIdOffset + foundSvcMaskType.getItemId());
            if (checkTagMaskType.equals(tagMaskType)) continue;
            tagMaskType.setLabel(checkTagMaskType.getLabel());
            tagMaskType.setDescription(checkTagMaskType.getDescription());
            tagMaskType.setTransformer(checkTagMaskType.getTransformer());
            tagMaskType.setDataMaskOptions(checkTagMaskType.getDataMaskOptions());
            tagMaskType.setRbKeyLabel(checkTagMaskType.getRbKeyLabel());
            tagMaskType.setRbKeyDescription(checkTagMaskType.getRbKeyDescription());
            maskTypesToUpdate.add(tagMaskType);
        }
        if (CollectionUtils.isNotEmpty(maskTypesToAdd) || CollectionUtils.isNotEmpty(maskTypesToUpdate) || CollectionUtils.isNotEmpty(maskTypesToDelete)) {
            ret = true;
            if (LOG.isDebugEnabled()) {
                for (RangerServiceDef.RangerDataMaskTypeDef maskTypeDef : maskTypesToDelete) {
                    LOG.debug("maskTypeDef-to-delete:[" + maskTypeDef + "]");
                }
                for (RangerServiceDef.RangerDataMaskTypeDef maskTypeDef : maskTypesToUpdate) {
                    LOG.debug("maskTypeDef-to-update:[" + maskTypeDef + "]");
                }
                for (RangerServiceDef.RangerDataMaskTypeDef maskTypeDef : maskTypesToAdd) {
                    LOG.debug("maskTypeDef-to-add:[" + maskTypeDef + "]");
                }
            }
            tagDefMaskTypes.removeAll(maskTypesToDelete);
            tagDefMaskTypes.addAll(maskTypesToAdd);
            tagDataMaskDef.setMaskTypes(tagDefMaskTypes);
        }
        if (tagMaskDefAccessTypesUpdated = this.updateTagAccessTypeDefs(svcDefAccessTypes, tagDefAccessTypes, itemIdOffset, prefix)) {
            tagDataMaskDef.setAccessTypes(tagDefAccessTypes);
            ret = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AbstractServiceStore.updateTagServiceDefForUpdatingDataMaskDef(" + serviceDef.getName() + ") : " + ret);
        }
        return ret;
    }

    private void updateTagServiceDefForDeletingDataMaskDef(RangerServiceDef tagServiceDef, String serviceDefName) {
        RangerServiceDef.RangerDataMaskDef tagDataMaskDef;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AbstractServiceStore.updateTagServiceDefForDeletingDataMaskDef(" + serviceDefName + ")");
        }
        if ((tagDataMaskDef = tagServiceDef.getDataMaskDef()) == null) {
            return;
        }
        String prefix = serviceDefName + COMPONENT_ACCESSTYPE_SEPARATOR;
        ArrayList<RangerServiceDef.RangerAccessTypeDef> accessTypes = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        for (RangerServiceDef.RangerAccessTypeDef accessType : tagDataMaskDef.getAccessTypes()) {
            if (!accessType.getName().startsWith(prefix)) continue;
            accessTypes.add(accessType);
        }
        ArrayList<RangerServiceDef.RangerDataMaskTypeDef> maskTypes = new ArrayList<RangerServiceDef.RangerDataMaskTypeDef>();
        for (RangerServiceDef.RangerDataMaskTypeDef maskType : tagDataMaskDef.getMaskTypes()) {
            if (!maskType.getName().startsWith(prefix)) continue;
            maskTypes.add(maskType);
        }
        tagDataMaskDef.getAccessTypes().removeAll(accessTypes);
        tagDataMaskDef.getMaskTypes().removeAll(maskTypes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AbstractServiceStore.updateTagServiceDefForDeletingDataMaskDef(" + serviceDefName + ")");
        }
    }

    private boolean updateTagServiceDefForUpdatingRowFilterDef(RangerServiceDef tagServiceDef, RangerServiceDef serviceDef, long itemIdOffset, String prefix) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AbstractServiceStore.updateTagServiceDefForUpdatingRowFilterDef(" + serviceDef.getName() + ")");
        }
        boolean ret = false;
        boolean autopropagateRowfilterdefToTag = this.config.getBoolean(AUTOPROPAGATE_ROWFILTERDEF_TO_TAG_PROP, false);
        if (autopropagateRowfilterdefToTag) {
            List<RangerServiceDef.RangerAccessTypeDef> tagDefAccessTypes;
            RangerServiceDef.RangerRowFilterDef svcRowFilterDef = serviceDef.getRowFilterDef();
            RangerServiceDef.RangerRowFilterDef tagRowFilterDef = tagServiceDef.getRowFilterDef();
            List<RangerServiceDef.RangerAccessTypeDef> svcDefAccessTypes = svcRowFilterDef.getAccessTypes();
            boolean tagRowFilterAccessTypesUpdated = this.updateTagAccessTypeDefs(svcDefAccessTypes, tagDefAccessTypes = tagRowFilterDef.getAccessTypes(), itemIdOffset, prefix);
            if (tagRowFilterAccessTypesUpdated) {
                tagRowFilterDef.setAccessTypes(tagDefAccessTypes);
                ret = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AbstractServiceStore.updateTagServiceDefForUpdatingRowFilterDef(" + serviceDef.getName() + ") : " + ret);
        }
        return ret;
    }

    private void updateTagServiceDefForDeletingRowFilterDef(RangerServiceDef tagServiceDef, String serviceDefName) {
        RangerServiceDef.RangerRowFilterDef tagRowFilterDef;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AbstractServiceStore.updateTagServiceDefForDeletingRowFilterDef(" + serviceDefName + ")");
        }
        if ((tagRowFilterDef = tagServiceDef.getRowFilterDef()) == null) {
            return;
        }
        String prefix = serviceDefName + COMPONENT_ACCESSTYPE_SEPARATOR;
        ArrayList<RangerServiceDef.RangerAccessTypeDef> accessTypes = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        for (RangerServiceDef.RangerAccessTypeDef accessType : tagRowFilterDef.getAccessTypes()) {
            if (!accessType.getName().startsWith(prefix)) continue;
            accessTypes.add(accessType);
        }
        tagRowFilterDef.getAccessTypes().removeAll(accessTypes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AbstractServiceStore.updateTagServiceDefForDeletingRowFilterDef(" + serviceDefName + ")");
        }
    }

    private boolean updateResourceInTagServiceDef(RangerServiceDef tagServiceDef) throws Exception {
        boolean autopropagateRowfilterdefToTag;
        RangerServiceDef.RangerRowFilterDef rowFilterDef;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AbstractServiceStore.updateResourceInTagServiceDef(" + tagServiceDef + ")");
        }
        boolean ret = false;
        RangerServiceDef.RangerResourceDef accessPolicyTagResource = this.getResourceDefForTagResource(tagServiceDef.getResources());
        ArrayList<RangerServiceDef.RangerResourceDef> resources = new ArrayList<RangerServiceDef.RangerResourceDef>();
        if (accessPolicyTagResource == null) {
            LOG.warn("Resource with name :[tag] not found in  tag-service-definition!!");
        } else {
            resources.add(accessPolicyTagResource);
        }
        RangerServiceDef.RangerDataMaskDef dataMaskDef = tagServiceDef.getDataMaskDef();
        if (dataMaskDef != null) {
            if (CollectionUtils.isNotEmpty(dataMaskDef.getAccessTypes())) {
                if (CollectionUtils.isEmpty(dataMaskDef.getResources())) {
                    dataMaskDef.setResources(resources);
                    ret = true;
                }
            } else if (CollectionUtils.isNotEmpty(dataMaskDef.getResources())) {
                dataMaskDef.setResources(null);
                ret = true;
            }
        }
        if ((rowFilterDef = tagServiceDef.getRowFilterDef()) != null && (autopropagateRowfilterdefToTag = this.config.getBoolean(AUTOPROPAGATE_ROWFILTERDEF_TO_TAG_PROP, false))) {
            if (CollectionUtils.isNotEmpty(rowFilterDef.getAccessTypes())) {
                if (CollectionUtils.isEmpty(rowFilterDef.getResources())) {
                    rowFilterDef.setResources(resources);
                    ret = true;
                }
            } else if (CollectionUtils.isNotEmpty(rowFilterDef.getResources())) {
                rowFilterDef.setResources(null);
                ret = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AbstractServiceStore.updateResourceInTagServiceDef(" + tagServiceDef + ") : " + ret);
        }
        return ret;
    }

    private RangerServiceDef.RangerResourceDef getResourceDefForTagResource(List<RangerServiceDef.RangerResourceDef> resourceDefs) {
        RangerServiceDef.RangerResourceDef ret = null;
        if (CollectionUtils.isNotEmpty(resourceDefs)) {
            for (RangerServiceDef.RangerResourceDef resourceDef : resourceDefs) {
                if (!resourceDef.getName().equals("tag")) continue;
                ret = resourceDef;
                break;
            }
        }
        return ret;
    }
}

