/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public final class PropertiesUtil
extends PropertyPlaceholderConfigurer {
    private static Map<String, String> propertiesMap = new HashMap<String, String>();
    private static Logger logger = LoggerFactory.getLogger(PropertiesUtil.class);
    protected List<String> xmlPropertyConfigurer = new ArrayList<String>();

    private PropertiesUtil() {
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) {
        String value;
        Properties sysProps = System.getProperties();
        if (sysProps != null) {
            for (String key : sysProps.stringPropertyNames()) {
                value = sysProps.getProperty(key);
                if (value != null) {
                    value = value.trim();
                }
                propertiesMap.put(key, value);
            }
        }
        if (props != null) {
            for (String key : props.stringPropertyNames()) {
                value = props.getProperty(key);
                if (value != null) {
                    value = value.trim();
                }
                propertiesMap.put(key, value);
            }
        }
        super.processProperties(beanFactory, props);
    }

    public static String getProperty(String key, String defaultValue) {
        if (key == null) {
            return null;
        }
        String rtrnVal = propertiesMap.get(key);
        if (rtrnVal == null) {
            rtrnVal = defaultValue;
        }
        return rtrnVal;
    }

    public static String getProperty(String key) {
        if (key == null) {
            return null;
        }
        return propertiesMap.get(key);
    }

    public static String[] getPropertyStringList(String key) {
        if (key == null) {
            return null;
        }
        String value = propertiesMap.get(key);
        if (value != null) {
            String[] splitValues = value.split(",");
            String[] returnValues = new String[splitValues.length];
            for (int i = 0; i < splitValues.length; ++i) {
                returnValues[i] = splitValues[i].trim();
            }
            return returnValues;
        }
        return new String[0];
    }

    public static Integer getIntProperty(String key, int defaultValue) {
        if (key == null) {
            return null;
        }
        String rtrnVal = propertiesMap.get(key);
        if (rtrnVal == null) {
            return defaultValue;
        }
        return Integer.valueOf(rtrnVal);
    }

    public static Integer getIntProperty(String key) {
        if (key == null) {
            return null;
        }
        String rtrnVal = propertiesMap.get(key);
        if (rtrnVal == null) {
            return null;
        }
        return Integer.valueOf(rtrnVal);
    }

    public static boolean getBooleanProperty(String key, boolean defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        String value = PropertiesUtil.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }
}

