/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.dledger;

import io.openmessaging.storage.dledger.AppendFuture;
import io.openmessaging.storage.dledger.BatchAppendFuture;
import io.openmessaging.storage.dledger.DLedgerConfig;
import io.openmessaging.storage.dledger.DLedgerServer;
import io.openmessaging.storage.dledger.protocol.AppendEntryRequest;
import io.openmessaging.storage.dledger.protocol.AppendEntryResponse;
import io.openmessaging.storage.dledger.protocol.BatchAppendEntryRequest;
import io.openmessaging.storage.dledger.protocol.DLedgerResponseCode;
import io.openmessaging.storage.dledger.store.file.DLedgerMmapFileStore;
import io.openmessaging.storage.dledger.store.file.MmapFile;
import io.openmessaging.storage.dledger.store.file.MmapFileList;
import io.openmessaging.storage.dledger.store.file.SelectMmapBufferResult;
import io.openmessaging.storage.dledger.utils.DLedgerUtils;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExtBatch;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.message.MessageVersion;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.store.AppendMessageResult;
import org.apache.rocketmq.store.AppendMessageStatus;
import org.apache.rocketmq.store.CommitLog;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.MessageExtEncoder;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.StoreStatsService;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.logfile.MappedFile;
import org.rocksdb.RocksDBException;

public class DLedgerCommitLog
extends CommitLog {
    private final DLedgerServer dLedgerServer;
    private final DLedgerConfig dLedgerConfig;
    private final DLedgerMmapFileStore dLedgerFileStore;
    private final MmapFileList dLedgerFileList;
    private final int id;
    private final MessageSerializer messageSerializer;
    private volatile long beginTimeInDledgerLock = 0L;
    private long dividedCommitlogOffset = -1L;
    private boolean isInrecoveringOldCommitlog = false;
    private final StringBuilder msgIdBuilder = new StringBuilder();

    public DLedgerCommitLog(DefaultMessageStore defaultMessageStore) {
        super(defaultMessageStore);
        this.dLedgerConfig = new DLedgerConfig();
        this.dLedgerConfig.setEnableDiskForceClean(defaultMessageStore.getMessageStoreConfig().isCleanFileForciblyEnable());
        this.dLedgerConfig.setStoreType("FILE");
        this.dLedgerConfig.setSelfId(defaultMessageStore.getMessageStoreConfig().getdLegerSelfId());
        this.dLedgerConfig.setGroup(defaultMessageStore.getMessageStoreConfig().getdLegerGroup());
        this.dLedgerConfig.setPeers(defaultMessageStore.getMessageStoreConfig().getdLegerPeers());
        this.dLedgerConfig.setStoreBaseDir(defaultMessageStore.getMessageStoreConfig().getStorePathRootDir());
        this.dLedgerConfig.setDataStorePath(defaultMessageStore.getMessageStoreConfig().getStorePathDLedgerCommitLog());
        this.dLedgerConfig.setReadOnlyDataStoreDirs(defaultMessageStore.getMessageStoreConfig().getReadOnlyCommitLogStorePaths());
        this.dLedgerConfig.setMappedFileSizeForEntryData(defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog());
        this.dLedgerConfig.setDeleteWhen(defaultMessageStore.getMessageStoreConfig().getDeleteWhen());
        this.dLedgerConfig.setFileReservedHours(defaultMessageStore.getMessageStoreConfig().getFileReservedTime() + 1);
        this.dLedgerConfig.setPreferredLeaderId(defaultMessageStore.getMessageStoreConfig().getPreferredLeaderId());
        this.dLedgerConfig.setEnableBatchPush(defaultMessageStore.getMessageStoreConfig().isEnableBatchPush());
        this.dLedgerConfig.setDiskSpaceRatioToCheckExpired((float)defaultMessageStore.getMessageStoreConfig().getDiskMaxUsedSpaceRatio() / 100.0f);
        this.id = Integer.parseInt(this.dLedgerConfig.getSelfId().substring(1)) + 1;
        this.dLedgerServer = new DLedgerServer(this.dLedgerConfig);
        this.dLedgerFileStore = (DLedgerMmapFileStore)this.dLedgerServer.getdLedgerStore();
        DLedgerMmapFileStore.AppendHook appendHook = (entry, buffer, bodyOffset) -> {
            assert (bodyOffset == 48);
            buffer.position(buffer.position() + bodyOffset + 28);
            buffer.putLong(entry.getPos() + (long)bodyOffset);
        };
        this.dLedgerFileStore.addAppendHook(appendHook);
        this.dLedgerFileList = this.dLedgerFileStore.getDataFileList();
        this.messageSerializer = new MessageSerializer(defaultMessageStore.getMessageStoreConfig().getMaxMessageSize());
    }

    @Override
    public boolean load() {
        return super.load();
    }

    private void refreshConfig() {
        this.dLedgerConfig.setEnableDiskForceClean(this.defaultMessageStore.getMessageStoreConfig().isCleanFileForciblyEnable());
        this.dLedgerConfig.setDeleteWhen(this.defaultMessageStore.getMessageStoreConfig().getDeleteWhen());
        this.dLedgerConfig.setFileReservedHours(this.defaultMessageStore.getMessageStoreConfig().getFileReservedTime() + 1);
    }

    private void disableDeleteDledger() {
        this.dLedgerConfig.setEnableDiskForceClean(false);
        this.dLedgerConfig.setFileReservedHours(87600);
    }

    @Override
    public void start() {
        this.dLedgerServer.startup();
    }

    @Override
    public void shutdown() {
        this.dLedgerServer.shutdown();
    }

    @Override
    public long flush() {
        this.dLedgerFileStore.flush();
        return this.dLedgerFileList.getFlushedWhere();
    }

    @Override
    public long getMaxOffset() {
        if (this.dLedgerFileStore.getCommittedPos() > 0L) {
            return this.dLedgerFileStore.getCommittedPos();
        }
        if (this.dLedgerFileList.getMinOffset() > 0L) {
            return this.dLedgerFileList.getMinOffset();
        }
        return 0L;
    }

    @Override
    public long getMinOffset() {
        if (!this.mappedFileQueue.getMappedFiles().isEmpty()) {
            return this.mappedFileQueue.getMinOffset();
        }
        for (MmapFile file : this.dLedgerFileList.getMappedFiles()) {
            if (!file.isAvailable()) continue;
            return file.getFileFromOffset() + (long)file.getStartPosition();
        }
        return 0L;
    }

    @Override
    public long getConfirmOffset() {
        return this.getMaxOffset();
    }

    @Override
    public void setConfirmOffset(long phyOffset) {
        log.warn("Should not set confirm offset {} for dleger commitlog", (Object)phyOffset);
    }

    @Override
    public long remainHowManyDataToCommit() {
        return this.dLedgerFileList.remainHowManyDataToCommit();
    }

    @Override
    public long remainHowManyDataToFlush() {
        return this.dLedgerFileList.remainHowManyDataToFlush();
    }

    @Override
    public int deleteExpiredFile(long expiredTime, int deleteFilesInterval, long intervalForcibly, boolean cleanImmediately) {
        if (this.mappedFileQueue.getMappedFiles().isEmpty()) {
            this.refreshConfig();
            return Integer.MAX_VALUE;
        }
        this.disableDeleteDledger();
        int count = super.deleteExpiredFile(expiredTime, deleteFilesInterval, intervalForcibly, cleanImmediately);
        if (count > 0 || this.mappedFileQueue.getMappedFiles().size() != 1) {
            return count;
        }
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
        log.info("Try to delete the last old commitlog file {}", (Object)mappedFile.getFileName());
        long liveMaxTimestamp = mappedFile.getLastModifiedTimestamp() + expiredTime;
        if (System.currentTimeMillis() >= liveMaxTimestamp || cleanImmediately) {
            while (!mappedFile.destroy(10000L)) {
                DLedgerUtils.sleep((long)1000L);
            }
            this.mappedFileQueue.getMappedFiles().remove(mappedFile);
        }
        return 1;
    }

    public SelectMappedBufferResult convertSbr(SelectMmapBufferResult sbr) {
        if (sbr == null) {
            return null;
        }
        return new DLedgerSelectMappedBufferResult(sbr);
    }

    public SelectMmapBufferResult truncate(SelectMmapBufferResult sbr) {
        long committedPos = this.dLedgerFileStore.getCommittedPos();
        if (sbr == null || sbr.getStartOffset() == committedPos) {
            return null;
        }
        if (sbr.getStartOffset() + (long)sbr.getSize() <= committedPos) {
            return sbr;
        }
        sbr.setSize((int)(committedPos - sbr.getStartOffset()));
        return sbr;
    }

    @Override
    public SelectMappedBufferResult getData(long offset) {
        if (offset < this.dividedCommitlogOffset) {
            return super.getData(offset);
        }
        return this.getData(offset, offset == 0L);
    }

    @Override
    public SelectMappedBufferResult getData(long offset, boolean returnFirstOnNotFound) {
        if (offset < this.dividedCommitlogOffset) {
            return super.getData(offset, returnFirstOnNotFound);
        }
        if (offset >= this.dLedgerFileStore.getCommittedPos()) {
            return null;
        }
        int mappedFileSize = this.dLedgerServer.getdLedgerConfig().getMappedFileSizeForEntryData();
        MmapFile mappedFile = this.dLedgerFileList.findMappedFileByOffset(offset, returnFirstOnNotFound);
        if (mappedFile != null) {
            int pos = (int)(offset % (long)mappedFileSize);
            SelectMmapBufferResult sbr = mappedFile.selectMappedBuffer(pos);
            return this.convertSbr(this.truncate(sbr));
        }
        return null;
    }

    @Override
    public boolean getData(long offset, int size, ByteBuffer byteBuffer) {
        if (offset < this.dividedCommitlogOffset) {
            return super.getData(offset, size, byteBuffer);
        }
        if (offset >= this.dLedgerFileStore.getCommittedPos()) {
            return false;
        }
        int mappedFileSize = this.dLedgerServer.getdLedgerConfig().getMappedFileSizeForEntryData();
        MmapFile mappedFile = this.dLedgerFileList.findMappedFileByOffset(offset, offset == 0L);
        if (mappedFile != null) {
            int pos = (int)(offset % (long)mappedFileSize);
            return mappedFile.getData(pos, size, byteBuffer);
        }
        return false;
    }

    private void dledgerRecoverNormally(long maxPhyOffsetOfConsumeQueue) throws RocksDBException {
        this.dLedgerFileStore.load();
        if (!this.dLedgerFileList.getMappedFiles().isEmpty()) {
            long maxPhyOffset;
            this.dLedgerFileStore.recover();
            this.dividedCommitlogOffset = this.dLedgerFileList.getFirstMappedFile().getFileFromOffset();
            MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
            if (mappedFile != null) {
                this.disableDeleteDledger();
            }
            if (maxPhyOffsetOfConsumeQueue >= (maxPhyOffset = this.dLedgerFileList.getMaxWrotePosition())) {
                log.warn("[TruncateCQ]maxPhyOffsetOfConsumeQueue({}) >= processOffset({}), truncate dirty logic files", (Object)maxPhyOffsetOfConsumeQueue, (Object)maxPhyOffset);
                this.defaultMessageStore.truncateDirtyLogicFiles(maxPhyOffset);
            }
            return;
        }
        this.isInrecoveringOldCommitlog = true;
        super.recoverNormally(maxPhyOffsetOfConsumeQueue);
        this.isInrecoveringOldCommitlog = false;
        this.setRecoverPosition();
    }

    private void dledgerRecoverAbnormally(long maxPhyOffsetOfConsumeQueue) throws RocksDBException {
        boolean checkCRCOnRecover = this.defaultMessageStore.getMessageStoreConfig().isCheckCRCOnRecover();
        boolean checkDupInfo = this.defaultMessageStore.getMessageStoreConfig().isDuplicationEnable();
        this.dLedgerFileStore.load();
        if (!this.dLedgerFileList.getMappedFiles().isEmpty()) {
            long mmapFileOffset;
            long processOffset;
            block9: {
                int index;
                this.dLedgerFileStore.recover();
                this.dividedCommitlogOffset = this.dLedgerFileList.getFirstMappedFile().getFileFromOffset();
                MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
                if (mappedFile != null) {
                    this.disableDeleteDledger();
                }
                List mmapFiles = this.dLedgerFileList.getMappedFiles();
                MmapFile mmapFile = null;
                for (index = mmapFiles.size() - 1; index >= 0; --index) {
                    mmapFile = (MmapFile)mmapFiles.get(index);
                    if (!this.isMmapFileMatchedRecover(mmapFile)) continue;
                    log.info("dledger recover from this mappFile " + mmapFile.getFileName());
                    break;
                }
                if (index < 0) {
                    index = 0;
                    mmapFile = (MmapFile)mmapFiles.get(index);
                }
                ByteBuffer byteBuffer = mmapFile.sliceByteBuffer();
                processOffset = mmapFile.getFileFromOffset();
                mmapFileOffset = 0L;
                while (true) {
                    DispatchRequest dispatchRequest = this.checkMessageAndReturnSize(byteBuffer, checkCRCOnRecover, checkDupInfo);
                    int size = dispatchRequest.getMsgSize();
                    if (!dispatchRequest.isSuccess()) break;
                    if (size > 0) {
                        mmapFileOffset += (long)size;
                        if (this.defaultMessageStore.getMessageStoreConfig().isDuplicationEnable()) {
                            if (dispatchRequest.getCommitLogOffset() >= this.defaultMessageStore.getConfirmOffset()) continue;
                            this.defaultMessageStore.doDispatch(dispatchRequest);
                            continue;
                        }
                        this.defaultMessageStore.doDispatch(dispatchRequest);
                        continue;
                    }
                    if (size != 0) continue;
                    if (++index >= mmapFiles.size()) {
                        log.info("dledger recover physics file over, last mapped file " + mmapFile.getFileName());
                        break block9;
                    }
                    mmapFile = (MmapFile)mmapFiles.get(index);
                    byteBuffer = mmapFile.sliceByteBuffer();
                    processOffset = mmapFile.getFileFromOffset();
                    mmapFileOffset = 0L;
                    log.info("dledger recover next physics file, " + mmapFile.getFileName());
                }
                log.info("dledger recover physics file end, " + mmapFile.getFileName() + " pos=" + byteBuffer.position());
            }
            if (maxPhyOffsetOfConsumeQueue >= (processOffset += mmapFileOffset)) {
                log.warn("dledger maxPhyOffsetOfConsumeQueue({}) >= processOffset({}), truncate dirty logic files", (Object)maxPhyOffsetOfConsumeQueue, (Object)processOffset);
                this.defaultMessageStore.truncateDirtyLogicFiles(processOffset);
            }
            return;
        }
        this.isInrecoveringOldCommitlog = true;
        super.recoverAbnormally(maxPhyOffsetOfConsumeQueue);
        this.isInrecoveringOldCommitlog = false;
        this.setRecoverPosition();
    }

    private void setRecoverPosition() {
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
        if (mappedFile == null) {
            return;
        }
        ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
        byteBuffer.position(mappedFile.getWrotePosition());
        boolean needWriteMagicCode = true;
        byteBuffer.getInt();
        int magicCode = byteBuffer.getInt();
        if (magicCode == -875286124) {
            needWriteMagicCode = false;
        } else {
            log.info("Recover old commitlog found a illegal magic code={}", (Object)magicCode);
        }
        this.dLedgerConfig.setEnableDiskForceClean(false);
        this.dividedCommitlogOffset = mappedFile.getFileFromOffset() + (long)mappedFile.getFileSize();
        log.info("Recover old commitlog needWriteMagicCode={} pos={} file={} dividedCommitlogOffset={}", new Object[]{needWriteMagicCode, mappedFile.getFileFromOffset() + (long)mappedFile.getWrotePosition(), mappedFile.getFileName(), this.dividedCommitlogOffset});
        if (needWriteMagicCode) {
            byteBuffer.position(mappedFile.getWrotePosition());
            byteBuffer.putInt(mappedFile.getFileSize() - mappedFile.getWrotePosition());
            byteBuffer.putInt(-875286124);
            mappedFile.flush(0);
        }
        mappedFile.setWrotePosition(mappedFile.getFileSize());
        mappedFile.setCommittedPosition(mappedFile.getFileSize());
        mappedFile.setFlushedPosition(mappedFile.getFileSize());
        this.dLedgerFileList.getLastMappedFile(this.dividedCommitlogOffset);
        log.info("Will set the initial commitlog offset={} for dledger", (Object)this.dividedCommitlogOffset);
    }

    private boolean isMmapFileMatchedRecover(MmapFile mmapFile) {
        ByteBuffer byteBuffer = mmapFile.sliceByteBuffer();
        int magicCode = byteBuffer.getInt(52);
        if (magicCode != -626843481) {
            return false;
        }
        int sysFlag = byteBuffer.getInt(84);
        int storeTimestampPosition = (sysFlag & 0x10) == 0 ? 56 : 68;
        long storeTimestamp = byteBuffer.getLong(48 + storeTimestampPosition);
        if (storeTimestamp == 0L) {
            return false;
        }
        if (this.defaultMessageStore.getMessageStoreConfig().isMessageIndexEnable() && this.defaultMessageStore.getMessageStoreConfig().isMessageIndexSafe()) {
            if (storeTimestamp <= this.defaultMessageStore.getStoreCheckpoint().getMinTimestampIndex()) {
                log.info("dledger find check timestamp, {} {}", (Object)storeTimestamp, (Object)UtilAll.timeMillisToHumanString((long)storeTimestamp));
                return true;
            }
        } else if (storeTimestamp <= this.defaultMessageStore.getStoreCheckpoint().getMinTimestamp()) {
            log.info("dledger find check timestamp, {} {}", (Object)storeTimestamp, (Object)UtilAll.timeMillisToHumanString((long)storeTimestamp));
            return true;
        }
        return false;
    }

    @Override
    public void recoverNormally(long maxPhyOffsetOfConsumeQueue) throws RocksDBException {
        this.dledgerRecoverNormally(maxPhyOffsetOfConsumeQueue);
    }

    @Override
    public void recoverAbnormally(long maxPhyOffsetOfConsumeQueue) throws RocksDBException {
        this.dledgerRecoverAbnormally(maxPhyOffsetOfConsumeQueue);
    }

    @Override
    public DispatchRequest checkMessageAndReturnSize(ByteBuffer byteBuffer, boolean checkCRC, boolean checkDupInfo, boolean readBody) {
        if (this.isInrecoveringOldCommitlog) {
            return super.checkMessageAndReturnSize(byteBuffer, checkCRC, checkDupInfo, readBody);
        }
        try {
            int bodyOffset = 48;
            int pos = byteBuffer.position();
            int magic = byteBuffer.getInt();
            int magicOld = byteBuffer.getInt();
            if (magicOld == -875286124 || magicOld == -626843481 || magicOld == -626843477) {
                byteBuffer.position(pos);
                return super.checkMessageAndReturnSize(byteBuffer, checkCRC, checkDupInfo, readBody);
            }
            if (magic == -1) {
                return new DispatchRequest(0, true);
            }
            byteBuffer.position(pos + bodyOffset);
            DispatchRequest dispatchRequest = super.checkMessageAndReturnSize(byteBuffer, checkCRC, checkDupInfo, readBody);
            if (dispatchRequest.isSuccess()) {
                dispatchRequest.setBufferSize(dispatchRequest.getMsgSize() + bodyOffset);
            } else if (dispatchRequest.getMsgSize() > 0) {
                dispatchRequest.setBufferSize(dispatchRequest.getMsgSize() + bodyOffset);
            }
            return dispatchRequest;
        }
        catch (Throwable throwable) {
            return new DispatchRequest(-1, false);
        }
    }

    @Override
    public boolean resetOffset(long offset) {
        return false;
    }

    @Override
    public long getBeginTimeInLock() {
        return this.beginTimeInDledgerLock;
    }

    private void setMessageInfo(MessageExtBrokerInner msg, int tranType) {
        InetSocketAddress storeSocketAddress;
        msg.setStoreTimestamp(System.currentTimeMillis());
        msg.setBodyCRC(UtilAll.crc32((byte[])msg.getBody()));
        InetSocketAddress bornSocketAddress = (InetSocketAddress)msg.getBornHost();
        if (bornSocketAddress.getAddress() instanceof Inet6Address) {
            msg.setBornHostV6Flag();
        }
        if ((storeSocketAddress = (InetSocketAddress)msg.getStoreHost()).getAddress() instanceof Inet6Address) {
            msg.setStoreHostAddressV6Flag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<PutMessageResult> asyncPutMessage(MessageExtBrokerInner msg) {
        AppendMessageResult appendResult;
        AppendFuture dledgerFuture;
        EncodeResult encodeResult;
        StoreStatsService storeStatsService = this.defaultMessageStore.getStoreStatsService();
        int tranType = MessageSysFlag.getTransactionValue((int)msg.getSysFlag());
        this.setMessageInfo(msg, tranType);
        String finalTopic = msg.getTopic();
        msg.setVersion(MessageVersion.MESSAGE_VERSION_V1);
        boolean autoMessageVersionOnTopicLen = this.defaultMessageStore.getMessageStoreConfig().isAutoMessageVersionOnTopicLen();
        if (autoMessageVersionOnTopicLen && msg.getTopic().length() > 127) {
            msg.setVersion(MessageVersion.MESSAGE_VERSION_V2);
        }
        if ((encodeResult = this.messageSerializer.serialize(msg)).status != AppendMessageStatus.PUT_OK) {
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, new AppendMessageResult(encodeResult.status)));
        }
        String topicQueueKey = msg.getTopic() + "-" + msg.getQueueId();
        this.topicQueueLock.lock(topicQueueKey);
        try {
            long elapsedTimeInLock;
            this.defaultMessageStore.assignOffset(msg);
            this.putMessageLock.lock();
            try {
                this.beginTimeInDledgerLock = this.defaultMessageStore.getSystemClock().now();
                long queueOffset = this.getQueueOffsetByKey(msg, tranType);
                encodeResult.setQueueOffsetKey(queueOffset, false);
                AppendEntryRequest request = new AppendEntryRequest();
                request.setGroup(this.dLedgerConfig.getGroup());
                request.setRemoteId(this.dLedgerServer.getMemberState().getSelfId());
                request.setBody(encodeResult.getData());
                dledgerFuture = (AppendFuture)this.dLedgerServer.handleAppend(request);
                if (dledgerFuture.getPos() == -1L) {
                    CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.OS_PAGE_CACHE_BUSY, new AppendMessageResult(AppendMessageStatus.UNKNOWN_ERROR)));
                    return completableFuture;
                }
                long wroteOffset = dledgerFuture.getPos() + 48L;
                int msgIdLength = (msg.getSysFlag() & 0x20) == 0 ? 16 : 28;
                ByteBuffer buffer = ByteBuffer.allocate(msgIdLength);
                String msgId = MessageDecoder.createMessageId((ByteBuffer)buffer, (ByteBuffer)msg.getStoreHostBytes(), (long)wroteOffset);
                elapsedTimeInLock = this.defaultMessageStore.getSystemClock().now() - this.beginTimeInDledgerLock;
                appendResult = new AppendMessageResult(AppendMessageStatus.PUT_OK, wroteOffset, encodeResult.getData().length, msgId, System.currentTimeMillis(), queueOffset, elapsedTimeInLock);
            }
            finally {
                this.beginTimeInDledgerLock = 0L;
                this.putMessageLock.unlock();
            }
            if (elapsedTimeInLock > 500L) {
                log.warn("[NOTIFYME]putMessage in lock cost time(ms)={}, bodyLength={} AppendMessageResult={}", new Object[]{elapsedTimeInLock, msg.getBody().length, appendResult});
            }
            this.defaultMessageStore.increaseOffset(msg, this.getMessageNum(msg));
        }
        catch (Exception e) {
            log.error("Put message error", (Throwable)e);
            CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, new AppendMessageResult(AppendMessageStatus.UNKNOWN_ERROR)));
            return completableFuture;
        }
        finally {
            this.topicQueueLock.unlock(topicQueueKey);
        }
        return dledgerFuture.thenApply(appendEntryResponse -> {
            PutMessageStatus putMessageStatus = PutMessageStatus.UNKNOWN_ERROR;
            switch (DLedgerResponseCode.valueOf((int)appendEntryResponse.getCode())) {
                case SUCCESS: {
                    putMessageStatus = PutMessageStatus.PUT_OK;
                    break;
                }
                case INCONSISTENT_LEADER: 
                case NOT_LEADER: 
                case LEADER_NOT_READY: 
                case DISK_FULL: {
                    putMessageStatus = PutMessageStatus.SERVICE_NOT_AVAILABLE;
                    break;
                }
                case WAIT_QUORUM_ACK_TIMEOUT: {
                    putMessageStatus = PutMessageStatus.IN_SYNC_REPLICAS_NOT_ENOUGH;
                    break;
                }
                case LEADER_PENDING_FULL: {
                    putMessageStatus = PutMessageStatus.OS_PAGE_CACHE_BUSY;
                }
            }
            PutMessageResult putMessageResult = new PutMessageResult(putMessageStatus, appendResult);
            if (putMessageStatus == PutMessageStatus.PUT_OK) {
                storeStatsService.getSinglePutMessageTopicTimesTotal(finalTopic).add(1L);
                storeStatsService.getSinglePutMessageTopicSizeTotal(msg.getTopic()).add(appendResult.getWroteBytes());
            }
            return putMessageResult;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<PutMessageResult> asyncPutMessages(MessageExtBatch messageExtBatch) {
        AppendMessageResult appendResult;
        BatchAppendFuture dledgerFuture;
        EncodeResult encodeResult;
        InetSocketAddress storeSocketAddress;
        int tranType = MessageSysFlag.getTransactionValue((int)messageExtBatch.getSysFlag());
        if (tranType != 0) {
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null));
        }
        if (messageExtBatch.getDelayTimeLevel() > 0) {
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null));
        }
        messageExtBatch.setStoreTimestamp(System.currentTimeMillis());
        StoreStatsService storeStatsService = this.defaultMessageStore.getStoreStatsService();
        InetSocketAddress bornSocketAddress = (InetSocketAddress)messageExtBatch.getBornHost();
        if (bornSocketAddress.getAddress() instanceof Inet6Address) {
            messageExtBatch.setBornHostV6Flag();
        }
        if ((storeSocketAddress = (InetSocketAddress)messageExtBatch.getStoreHost()).getAddress() instanceof Inet6Address) {
            messageExtBatch.setStoreHostAddressV6Flag();
        }
        messageExtBatch.setVersion(MessageVersion.MESSAGE_VERSION_V1);
        boolean autoMessageVersionOnTopicLen = this.defaultMessageStore.getMessageStoreConfig().isAutoMessageVersionOnTopicLen();
        if (autoMessageVersionOnTopicLen && messageExtBatch.getTopic().length() > 127) {
            messageExtBatch.setVersion(MessageVersion.MESSAGE_VERSION_V2);
        }
        if ((encodeResult = this.messageSerializer.serialize(messageExtBatch)).status != AppendMessageStatus.PUT_OK) {
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, new AppendMessageResult(encodeResult.status)));
        }
        int batchNum = encodeResult.batchData.size();
        this.topicQueueLock.lock(encodeResult.queueOffsetKey);
        try {
            long elapsedTimeInLock;
            this.defaultMessageStore.assignOffset((MessageExtBrokerInner)messageExtBatch);
            this.putMessageLock.lock();
            this.msgIdBuilder.setLength(0);
            int msgNum = 0;
            try {
                this.beginTimeInDledgerLock = this.defaultMessageStore.getSystemClock().now();
                long queueOffset = this.getQueueOffsetByKey((MessageExtBrokerInner)messageExtBatch, tranType);
                encodeResult.setQueueOffsetKey(queueOffset, true);
                BatchAppendEntryRequest request = new BatchAppendEntryRequest();
                request.setGroup(this.dLedgerConfig.getGroup());
                request.setRemoteId(this.dLedgerServer.getMemberState().getSelfId());
                request.setBatchMsgs(encodeResult.batchData);
                AppendFuture appendFuture = (AppendFuture)this.dLedgerServer.handleAppend((AppendEntryRequest)request);
                if (appendFuture.getPos() == -1L) {
                    log.warn("HandleAppend return false due to error code {}", (Object)((AppendEntryResponse)appendFuture.get()).getCode());
                    CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.OS_PAGE_CACHE_BUSY, new AppendMessageResult(AppendMessageStatus.UNKNOWN_ERROR)));
                    return completableFuture;
                }
                dledgerFuture = (BatchAppendFuture)appendFuture;
                long wroteOffset = 0L;
                int msgIdLength = (messageExtBatch.getSysFlag() & 0x20) == 0 ? 16 : 28;
                ByteBuffer buffer = ByteBuffer.allocate(msgIdLength);
                boolean isFirstOffset = true;
                long firstWroteOffset = 0L;
                for (long pos : dledgerFuture.getPositions()) {
                    wroteOffset = pos + 48L;
                    if (isFirstOffset) {
                        firstWroteOffset = wroteOffset;
                        isFirstOffset = false;
                    }
                    String msgId = MessageDecoder.createMessageId((ByteBuffer)buffer, (ByteBuffer)messageExtBatch.getStoreHostBytes(), (long)wroteOffset);
                    if (this.msgIdBuilder.length() > 0) {
                        this.msgIdBuilder.append(',').append(msgId);
                    } else {
                        this.msgIdBuilder.append(msgId);
                    }
                    ++msgNum;
                }
                elapsedTimeInLock = this.defaultMessageStore.getSystemClock().now() - this.beginTimeInDledgerLock;
                appendResult = new AppendMessageResult(AppendMessageStatus.PUT_OK, firstWroteOffset, encodeResult.totalMsgLen, this.msgIdBuilder.toString(), System.currentTimeMillis(), queueOffset, elapsedTimeInLock);
                appendResult.setMsgNum(msgNum);
            }
            finally {
                this.beginTimeInDledgerLock = 0L;
                this.putMessageLock.unlock();
            }
            if (elapsedTimeInLock > 500L) {
                log.warn("[NOTIFYME]putMessage in lock cost time(ms)={}, bodyLength={} AppendMessageResult={}", new Object[]{elapsedTimeInLock, messageExtBatch.getBody().length, appendResult});
            }
            this.defaultMessageStore.increaseOffset((MessageExtBrokerInner)messageExtBatch, (short)batchNum);
        }
        catch (Exception e) {
            log.error("Put message error", (Throwable)e);
            CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, new AppendMessageResult(AppendMessageStatus.UNKNOWN_ERROR)));
            return completableFuture;
        }
        finally {
            this.topicQueueLock.unlock(encodeResult.queueOffsetKey);
        }
        return dledgerFuture.thenApply(appendEntryResponse -> {
            PutMessageStatus putMessageStatus = PutMessageStatus.UNKNOWN_ERROR;
            switch (DLedgerResponseCode.valueOf((int)appendEntryResponse.getCode())) {
                case SUCCESS: {
                    putMessageStatus = PutMessageStatus.PUT_OK;
                    break;
                }
                case INCONSISTENT_LEADER: 
                case NOT_LEADER: 
                case LEADER_NOT_READY: 
                case DISK_FULL: {
                    putMessageStatus = PutMessageStatus.SERVICE_NOT_AVAILABLE;
                    break;
                }
                case WAIT_QUORUM_ACK_TIMEOUT: {
                    putMessageStatus = PutMessageStatus.IN_SYNC_REPLICAS_NOT_ENOUGH;
                    break;
                }
                case LEADER_PENDING_FULL: {
                    putMessageStatus = PutMessageStatus.OS_PAGE_CACHE_BUSY;
                }
            }
            PutMessageResult putMessageResult = new PutMessageResult(putMessageStatus, appendResult);
            if (putMessageStatus == PutMessageStatus.PUT_OK) {
                storeStatsService.getSinglePutMessageTopicTimesTotal(messageExtBatch.getTopic()).add(appendResult.getMsgNum());
                storeStatsService.getSinglePutMessageTopicSizeTotal(messageExtBatch.getTopic()).add(appendResult.getWroteBytes());
            }
            return putMessageResult;
        });
    }

    @Override
    public SelectMappedBufferResult getMessage(long offset, int size) {
        if (offset < this.dividedCommitlogOffset) {
            return super.getMessage(offset, size);
        }
        int mappedFileSize = this.dLedgerServer.getdLedgerConfig().getMappedFileSizeForEntryData();
        MmapFile mappedFile = this.dLedgerFileList.findMappedFileByOffset(offset, offset == 0L);
        if (mappedFile != null) {
            int pos = (int)(offset % (long)mappedFileSize);
            return this.convertSbr(mappedFile.selectMappedBuffer(pos, size));
        }
        return null;
    }

    @Override
    public long rollNextFile(long offset) {
        int mappedFileSize = this.defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog();
        return offset + (long)mappedFileSize - offset % (long)mappedFileSize;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.dLedgerFileList.destroy();
    }

    @Override
    public boolean appendData(long startOffset, byte[] data, int dataStart, int dataLength) {
        return false;
    }

    @Override
    public void checkSelf() {
        this.dLedgerFileList.checkSelf();
    }

    @Override
    public long lockTimeMills() {
        long diff = 0L;
        long begin = this.beginTimeInDledgerLock;
        if (begin > 0L) {
            diff = this.defaultMessageStore.now() - begin;
        }
        if (diff < 0L) {
            diff = 0L;
        }
        return diff;
    }

    private long getQueueOffsetByKey(MessageExtBrokerInner msg, int tranType) {
        Long queueOffset = msg.getQueueOffset();
        switch (tranType) {
            case 4: 
            case 12: {
                queueOffset = 0L;
                break;
            }
        }
        return queueOffset;
    }

    public DLedgerServer getdLedgerServer() {
        return this.dLedgerServer;
    }

    public int getId() {
        return this.id;
    }

    public long getDividedCommitlogOffset() {
        return this.dividedCommitlogOffset;
    }

    static {
        System.setProperty("dLedger.multiPath.Splitter", MessageStoreConfig.MULTI_PATH_SPLITTER);
    }

    public static class DLedgerSelectMappedBufferResult
    extends SelectMappedBufferResult {
        private SelectMmapBufferResult sbr;

        public DLedgerSelectMappedBufferResult(SelectMmapBufferResult sbr) {
            super(sbr.getStartOffset(), sbr.getByteBuffer(), sbr.getSize(), null);
            this.sbr = sbr;
        }

        @Override
        public synchronized void release() {
            super.release();
            if (this.sbr != null) {
                this.sbr.release();
            }
        }
    }

    class MessageSerializer {
        private final int maxMessageBodySize;

        MessageSerializer(int size) {
            this.maxMessageBodySize = size;
        }

        public EncodeResult serialize(MessageExtBrokerInner msgInner) {
            int propertiesLength;
            long wroteOffset = 0L;
            long queueOffset = 0L;
            int sysflag = msgInner.getSysFlag();
            int bornHostLength = (sysflag & 0x10) == 0 ? 8 : 20;
            int storeHostLength = (sysflag & 0x20) == 0 ? 8 : 20;
            ByteBuffer bornHostHolder = ByteBuffer.allocate(bornHostLength);
            ByteBuffer storeHostHolder = ByteBuffer.allocate(storeHostLength);
            String key = msgInner.getTopic() + "-" + msgInner.getQueueId();
            byte[] propertiesData = msgInner.getPropertiesString() == null ? null : msgInner.getPropertiesString().getBytes(MessageDecoder.CHARSET_UTF8);
            int n = propertiesLength = propertiesData == null ? 0 : propertiesData.length;
            if (propertiesLength > Short.MAX_VALUE) {
                log.warn("putMessage message properties length too long. length={}", (Object)propertiesData.length);
                return new EncodeResult(AppendMessageStatus.PROPERTIES_SIZE_EXCEEDED, null, key);
            }
            byte[] topicData = msgInner.getTopic().getBytes(MessageDecoder.CHARSET_UTF8);
            int topicLength = topicData.length;
            int bodyLength = msgInner.getBody() == null ? 0 : msgInner.getBody().length;
            int msgLen = MessageExtEncoder.calMsgLength(msgInner.getVersion(), msgInner.getSysFlag(), bodyLength, topicLength, propertiesLength);
            ByteBuffer msgStoreItemMemory = ByteBuffer.allocate(msgLen);
            if (bodyLength > this.maxMessageBodySize) {
                log.warn("message body size exceeded, msg total size: " + msgLen + ", msg body size: " + bodyLength + ", maxMessageBodySize: " + this.maxMessageBodySize);
                return new EncodeResult(AppendMessageStatus.MESSAGE_SIZE_EXCEEDED, null, key);
            }
            this.resetByteBuffer(msgStoreItemMemory, msgLen);
            msgStoreItemMemory.putInt(msgLen);
            msgStoreItemMemory.putInt(msgInner.getVersion().getMagicCode());
            msgStoreItemMemory.putInt(msgInner.getBodyCRC());
            msgStoreItemMemory.putInt(msgInner.getQueueId());
            msgStoreItemMemory.putInt(msgInner.getFlag());
            msgStoreItemMemory.putLong(queueOffset);
            msgStoreItemMemory.putLong(wroteOffset);
            msgStoreItemMemory.putInt(msgInner.getSysFlag());
            msgStoreItemMemory.putLong(msgInner.getBornTimestamp());
            this.resetByteBuffer(bornHostHolder, bornHostLength);
            msgStoreItemMemory.put(msgInner.getBornHostBytes(bornHostHolder));
            msgStoreItemMemory.putLong(msgInner.getStoreTimestamp());
            this.resetByteBuffer(storeHostHolder, storeHostLength);
            msgStoreItemMemory.put(msgInner.getStoreHostBytes(storeHostHolder));
            msgStoreItemMemory.putInt(msgInner.getReconsumeTimes());
            msgStoreItemMemory.putLong(msgInner.getPreparedTransactionOffset());
            msgStoreItemMemory.putInt(bodyLength);
            if (bodyLength > 0) {
                msgStoreItemMemory.put(msgInner.getBody());
            }
            msgInner.getVersion().putTopicLength(msgStoreItemMemory, topicLength);
            msgStoreItemMemory.put(topicData);
            msgStoreItemMemory.putShort((short)propertiesLength);
            if (propertiesLength > 0) {
                msgStoreItemMemory.put(propertiesData);
            }
            return new EncodeResult(AppendMessageStatus.PUT_OK, msgStoreItemMemory, key);
        }

        public EncodeResult serialize(MessageExtBatch messageExtBatch) {
            String key = messageExtBatch.getTopic() + "-" + messageExtBatch.getQueueId();
            int totalMsgLen = 0;
            ByteBuffer messagesByteBuff = messageExtBatch.wrap();
            int totalLength = messagesByteBuff.limit();
            if (totalLength > this.maxMessageBodySize) {
                log.warn("message body size exceeded, msg body size: " + totalLength + ", maxMessageBodySize: " + this.maxMessageBodySize);
                throw new RuntimeException("message size exceeded");
            }
            LinkedList<byte[]> batchBody = new LinkedList<byte[]>();
            int sysFlag = messageExtBatch.getSysFlag();
            int bornHostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
            int storeHostLength = (sysFlag & 0x20) == 0 ? 8 : 20;
            ByteBuffer bornHostHolder = ByteBuffer.allocate(bornHostLength);
            ByteBuffer storeHostHolder = ByteBuffer.allocate(storeHostLength);
            while (messagesByteBuff.hasRemaining()) {
                messagesByteBuff.getInt();
                messagesByteBuff.getInt();
                messagesByteBuff.getInt();
                int flag = messagesByteBuff.getInt();
                int bodyLen = messagesByteBuff.getInt();
                int bodyPos = messagesByteBuff.position();
                int bodyCrc = UtilAll.crc32((byte[])messagesByteBuff.array(), (int)bodyPos, (int)bodyLen);
                messagesByteBuff.position(bodyPos + bodyLen);
                short propertiesLen = messagesByteBuff.getShort();
                int propertiesPos = messagesByteBuff.position();
                messagesByteBuff.position(propertiesPos + propertiesLen);
                byte[] topicData = messageExtBatch.getTopic().getBytes(MessageDecoder.CHARSET_UTF8);
                int topicLength = topicData.length;
                int msgLen = MessageExtEncoder.calMsgLength(messageExtBatch.getVersion(), messageExtBatch.getSysFlag(), bodyLen, topicLength, propertiesLen);
                ByteBuffer msgStoreItemMemory = ByteBuffer.allocate(msgLen);
                totalMsgLen += msgLen;
                this.resetByteBuffer(msgStoreItemMemory, msgLen);
                msgStoreItemMemory.putInt(msgLen);
                msgStoreItemMemory.putInt(messageExtBatch.getVersion().getMagicCode());
                msgStoreItemMemory.putInt(bodyCrc);
                msgStoreItemMemory.putInt(messageExtBatch.getQueueId());
                msgStoreItemMemory.putInt(flag);
                msgStoreItemMemory.putLong(0L);
                msgStoreItemMemory.putLong(0L);
                msgStoreItemMemory.putInt(messageExtBatch.getSysFlag());
                msgStoreItemMemory.putLong(messageExtBatch.getBornTimestamp());
                this.resetByteBuffer(bornHostHolder, bornHostLength);
                msgStoreItemMemory.put(messageExtBatch.getBornHostBytes(bornHostHolder));
                msgStoreItemMemory.putLong(messageExtBatch.getStoreTimestamp());
                this.resetByteBuffer(storeHostHolder, storeHostLength);
                msgStoreItemMemory.put(messageExtBatch.getStoreHostBytes(storeHostHolder));
                msgStoreItemMemory.putInt(messageExtBatch.getReconsumeTimes());
                msgStoreItemMemory.putLong(0L);
                msgStoreItemMemory.putInt(bodyLen);
                if (bodyLen > 0) {
                    msgStoreItemMemory.put(messagesByteBuff.array(), bodyPos, bodyLen);
                }
                messageExtBatch.getVersion().putTopicLength(msgStoreItemMemory, topicLength);
                msgStoreItemMemory.put(topicData);
                msgStoreItemMemory.putShort(propertiesLen);
                if (propertiesLen > 0) {
                    msgStoreItemMemory.put(messagesByteBuff.array(), propertiesPos, propertiesLen);
                }
                byte[] data = new byte[msgLen];
                msgStoreItemMemory.clear();
                msgStoreItemMemory.get(data);
                batchBody.add(data);
            }
            return new EncodeResult(AppendMessageStatus.PUT_OK, key, batchBody, totalMsgLen);
        }

        private void resetByteBuffer(ByteBuffer byteBuffer, int limit) {
            byteBuffer.flip();
            byteBuffer.limit(limit);
        }
    }

    class EncodeResult {
        private String queueOffsetKey;
        private ByteBuffer data;
        private List<byte[]> batchData;
        private AppendMessageStatus status;
        private int totalMsgLen;

        public EncodeResult(AppendMessageStatus status, ByteBuffer data, String queueOffsetKey) {
            this.data = data;
            this.status = status;
            this.queueOffsetKey = queueOffsetKey;
        }

        public void setQueueOffsetKey(long offset, boolean isBatch) {
            if (!isBatch) {
                this.data.putLong(20, offset);
                return;
            }
            for (byte[] data : this.batchData) {
                ByteBuffer.wrap(data).putLong(20, offset++);
            }
        }

        public byte[] getData() {
            return this.data.array();
        }

        public EncodeResult(AppendMessageStatus status, String queueOffsetKey, List<byte[]> batchData, int totalMsgLen) {
            this.batchData = batchData;
            this.status = status;
            this.queueOffsetKey = queueOffsetKey;
            this.totalMsgLen = totalMsgLen;
        }
    }
}

