/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.channel;

import com.google.common.base.Strings;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.common.utils.ConcurrentHashMapUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.service.channel.InvocationChannel;
import org.apache.rocketmq.proxy.service.channel.SimpleChannel;

public class ChannelManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final ConcurrentMap<String, SimpleChannel> clientIdChannelMap = new ConcurrentHashMap<String, SimpleChannel>();

    public SimpleChannel createChannel(ProxyContext context) {
        String clientId = this.anonymousChannelId(context);
        if (Strings.isNullOrEmpty((String)clientId)) {
            log.warn("ClientId is unexpected null or empty");
            return this.createChannelInner(context);
        }
        SimpleChannel channel = (SimpleChannel)((Object)ConcurrentHashMapUtils.computeIfAbsent(this.clientIdChannelMap, (Object)clientId, k -> this.createChannelInner(context)));
        channel.updateLastAccessTime();
        return channel;
    }

    public SimpleChannel createInvocationChannel(ProxyContext context) {
        String clientId = this.anonymousChannelId(InvocationChannel.class.getName(), context);
        String clientHost = context.getRemoteAddress();
        String localAddress = context.getLocalAddress();
        if (Strings.isNullOrEmpty((String)clientId)) {
            log.warn("ClientId is unexpected null or empty");
            return new InvocationChannel(clientHost, localAddress);
        }
        SimpleChannel channel = this.clientIdChannelMap.computeIfAbsent(clientId, k -> new InvocationChannel(clientHost, localAddress));
        channel.updateLastAccessTime();
        return channel;
    }

    private String anonymousChannelId(ProxyContext context) {
        String clientHost = context.getRemoteAddress();
        String localAddress = context.getLocalAddress();
        return clientHost + "@" + localAddress;
    }

    private String anonymousChannelId(String key, ProxyContext context) {
        String clientHost = context.getRemoteAddress();
        String localAddress = context.getLocalAddress();
        return key + "@" + clientHost + "@" + localAddress;
    }

    private SimpleChannel createChannelInner(ProxyContext context) {
        return new SimpleChannel(context.getRemoteAddress(), context.getLocalAddress());
    }

    public void scanAndCleanChannels() {
        try {
            Iterator iterator = this.clientIdChannelMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((SimpleChannel)((Object)entry.getValue())).isActive()) {
                    iterator.remove();
                    continue;
                }
                ((SimpleChannel)((Object)entry.getValue())).clearExpireContext();
            }
        }
        catch (Throwable e) {
            log.error("Unexpected exception", e);
        }
    }
}

