/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import com.alibaba.fastjson.JSON;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.CheckRocksdbCqWriteResult;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.StoreType;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.exception.ConsumeQueueException;
import org.apache.rocketmq.store.exception.StoreException;
import org.apache.rocketmq.store.queue.AbstractConsumeQueueStore;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.ConsumeQueueStore;
import org.apache.rocketmq.store.queue.ConsumeQueueStoreInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueStore;
import org.rocksdb.RocksDBException;

public class CombineConsumeQueueStore
implements ConsumeQueueStoreInterface {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger BROKER_LOG = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final DefaultMessageStore messageStore;
    private final MessageStoreConfig messageStoreConfig;
    private final LinkedList<AbstractConsumeQueueStore> innerConsumeQueueStoreList = new LinkedList();
    private final ConsumeQueueStore consumeQueueStore;
    private final RocksDBConsumeQueueStore rocksDBConsumeQueueStore;
    private final AbstractConsumeQueueStore currentReadStore;
    private final AbstractConsumeQueueStore assignOffsetStore;
    private final AtomicInteger extraSearchCommitLogFilesForRecovery;

    public CombineConsumeQueueStore(DefaultMessageStore messageStore) {
        this.messageStore = messageStore;
        this.messageStoreConfig = messageStore.getMessageStoreConfig();
        this.extraSearchCommitLogFilesForRecovery = new AtomicInteger(this.messageStoreConfig.getCombineCQMaxExtraSearchCommitLogFiles());
        Set<StoreType> loadingConsumeQueueTypeSet = StoreType.fromString(this.messageStoreConfig.getCombineCQLoadingCQTypes());
        if (loadingConsumeQueueTypeSet.isEmpty()) {
            throw new IllegalArgumentException("CombineConsumeQueueStore loadingCQTypes is empty");
        }
        if (loadingConsumeQueueTypeSet.contains((Object)StoreType.DEFAULT)) {
            this.consumeQueueStore = new ConsumeQueueStore(messageStore);
            this.innerConsumeQueueStoreList.add(this.consumeQueueStore);
        } else {
            this.consumeQueueStore = null;
        }
        if (loadingConsumeQueueTypeSet.contains((Object)StoreType.DEFAULT_ROCKSDB)) {
            this.rocksDBConsumeQueueStore = new RocksDBConsumeQueueStore(messageStore);
            this.innerConsumeQueueStoreList.add(this.rocksDBConsumeQueueStore);
        } else {
            this.rocksDBConsumeQueueStore = null;
        }
        if (this.innerConsumeQueueStoreList.isEmpty()) {
            throw new IllegalArgumentException("CombineConsumeQueueStore loadingCQTypes is empty");
        }
        this.assignOffsetStore = this.getInnerStoreByString(this.messageStoreConfig.getCombineAssignOffsetCQType());
        if (this.assignOffsetStore == null) {
            log.error("CombineConsumeQueueStore chooseAssignOffsetStore fail, config={}", (Object)this.messageStoreConfig.getCombineAssignOffsetCQType());
            throw new IllegalArgumentException("CombineConsumeQueue chooseAssignOffsetStore fail");
        }
        this.currentReadStore = this.getInnerStoreByString(this.messageStoreConfig.getCombineCQPreferCQType());
        if (this.currentReadStore == null) {
            log.error("CombineConsumeQueueStore choosePreferCQ fail, config={}", (Object)this.messageStoreConfig.getCombineCQPreferCQType());
            throw new IllegalArgumentException("CombineConsumeQueue choosePreferCQ fail");
        }
        log.info("CombineConsumeQueueStore init, consumeQueueStoreList={}, currentReadStore={}, assignOffsetStore={}", new Object[]{this.innerConsumeQueueStoreList, this.currentReadStore.getClass().getSimpleName(), this.assignOffsetStore.getClass().getSimpleName()});
    }

    @Override
    public boolean load() {
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            if (store.load()) continue;
            log.error("CombineConsumeQueueStore load fail, loadType={}", (Object)store.getClass().getSimpleName());
            return false;
        }
        log.info("CombineConsumeQueueStore load success");
        return true;
    }

    @Override
    public void recover(boolean concurrently) throws RocksDBException {
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            store.recover(concurrently);
        }
        log.info("CombineConsumeQueueStore recover success, concurrently={}", (Object)concurrently);
    }

    @Override
    public boolean isMappedFileMatchedRecover(long phyOffset, long storeTimestamp, boolean recoverNormally) throws RocksDBException {
        if (!this.assignOffsetStore.isMappedFileMatchedRecover(phyOffset, storeTimestamp, recoverNormally)) {
            return false;
        }
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            if (store == this.assignOffsetStore || store.isMappedFileMatchedRecover(phyOffset, storeTimestamp, recoverNormally)) continue;
            if (this.extraSearchCommitLogFilesForRecovery.getAndDecrement() <= 0) {
                if (this.assignOffsetStore != this.currentReadStore) {
                    log.error("CombineConsumeQueueStore currentReadStore not satisfied readable conditions, assignOffsetStore={}, currentReadStore={}", (Object)this.assignOffsetStore.getClass().getSimpleName(), (Object)this.currentReadStore.getClass().getSimpleName());
                    throw new IllegalArgumentException(store.getClass().getSimpleName() + " not satisfied readable conditions, only can read from " + this.assignOffsetStore.getClass().getSimpleName());
                }
                log.warn("CombineConsumeQueueStore can not recover all inner store, maybe some inner store start haven\u2019t started before, store={}", (Object)store.getClass().getSimpleName());
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public long getDispatchFromPhyOffset() {
        long dispatchFromPhyOffset = this.assignOffsetStore.getDispatchFromPhyOffset();
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            if (store == this.assignOffsetStore || store.getDispatchFromPhyOffset() >= dispatchFromPhyOffset) continue;
            dispatchFromPhyOffset = store.getDispatchFromPhyOffset();
        }
        return dispatchFromPhyOffset;
    }

    @Override
    public void start() {
        boolean success = false;
        try {
            success = this.verifyAndInitOffsetForAllStore(true);
        }
        catch (RocksDBException e) {
            log.error("CombineConsumeQueueStore checkAssignOffsetStore fail", (Throwable)e);
        }
        if (!success && this.assignOffsetStore != this.currentReadStore) {
            log.error("CombineConsumeQueueStore currentReadStore not satisfied readable conditions, checkAssignOffsetResult={}, assignOffsetStore={}, currentReadStore={}", new Object[]{success, this.assignOffsetStore.getClass().getSimpleName(), this.currentReadStore.getClass().getSimpleName()});
            throw new RuntimeException("CombineConsumeQueueStore currentReadStore not satisfied readable conditions");
        }
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            store.start();
        }
    }

    public boolean verifyAndInitOffsetForAllStore(boolean initializeOffset) throws RocksDBException {
        if (this.innerConsumeQueueStoreList.size() <= 1) {
            return true;
        }
        boolean result = true;
        long minPhyOffset = this.messageStore.getCommitLog().getMinOffset();
        for (Map.Entry entry : this.assignOffsetStore.getConsumeQueueTable().entrySet()) {
            for (Map.Entry entry0 : ((ConcurrentMap)entry.getValue()).entrySet()) {
                String topic = (String)entry.getKey();
                int queueId = (Integer)entry0.getKey();
                long maxOffsetInAssign = ((ConsumeQueueInterface)entry0.getValue()).getMaxOffsetInQueue();
                for (AbstractConsumeQueueStore abstractConsumeQueueStore : this.innerConsumeQueueStoreList) {
                    ConsumeQueueInterface queue;
                    long maxOffset0;
                    if (abstractConsumeQueueStore == this.assignOffsetStore || maxOffsetInAssign == (maxOffset0 = (queue = abstractConsumeQueueStore.findOrCreateConsumeQueue(topic, queueId)).getMaxOffsetInQueue()) || maxOffsetInAssign <= 0L && maxOffset0 <= 0L) continue;
                    if (maxOffset0 > 0L) {
                        log.error("CombineConsumeQueueStore checkAssignOffsetStore fail, topic={}, queueId={}, maxOffsetInAssign={}, otherCQ={}, maxOffset0={}", new Object[]{topic, queueId, maxOffsetInAssign, abstractConsumeQueueStore.getClass().getSimpleName(), maxOffset0});
                        result = false;
                    }
                    if (!initializeOffset) continue;
                    queue.initializeWithOffset(maxOffsetInAssign, minPhyOffset);
                    log.info("CombineConsumeQueueStore initialize offset in queue, topic={}, queueId={}, maxOffsetInAssign={}, otherCQ={}, maxOffset0={}, maxOffsetNew={}", new Object[]{topic, queueId, maxOffsetInAssign, abstractConsumeQueueStore.getClass().getSimpleName(), maxOffset0, queue.getMaxOffsetInQueue()});
                }
            }
        }
        return result;
    }

    @Override
    public boolean shutdown() {
        boolean result = true;
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            if (store.shutdown()) continue;
            result = false;
        }
        return result;
    }

    @Override
    public void destroy(boolean loadAfterDestroy) {
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            store.destroy(loadAfterDestroy);
        }
    }

    @Override
    public boolean deleteTopic(String topic) {
        boolean result = false;
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            if (!store.deleteTopic(topic)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public void flush() throws StoreException {
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            store.flush();
        }
    }

    @Override
    public void cleanExpired(long minCommitLogOffset) {
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            store.cleanExpired(minCommitLogOffset);
        }
    }

    @Override
    public void checkSelf() {
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            store.checkSelf();
        }
        if (this.messageStoreConfig.isCombineCQEnableCheckSelf()) {
            try {
                this.verifyAndInitOffsetForAllStore(false);
            }
            catch (RocksDBException e) {
                log.error("CombineConsumeQueueStore checkAssignOffsetStore fail in checkSelf", (Throwable)e);
            }
            CheckRocksdbCqWriteResult checkResult = this.doCheckCqWriteProgress(null, System.currentTimeMillis() - 600000L, StoreType.DEFAULT, StoreType.DEFAULT_ROCKSDB);
            BROKER_LOG.info("checkRocksdbCqWriteProgress result: {}", (Object)JSON.toJSONString((Object)checkResult));
        }
    }

    @Override
    public void truncateDirty(long offsetToTruncate) throws RocksDBException {
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            store.truncateDirty(offsetToTruncate);
        }
    }

    @Override
    public void putMessagePositionInfoWrapper(DispatchRequest request) throws RocksDBException {
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            store.putMessagePositionInfoWrapper(request);
        }
    }

    @Override
    public ConcurrentMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>> getConsumeQueueTable() {
        return this.currentReadStore.getConsumeQueueTable();
    }

    @Override
    public void assignQueueOffset(MessageExtBrokerInner msg) throws RocksDBException {
        this.assignOffsetStore.assignQueueOffset(msg);
    }

    @Override
    public void increaseQueueOffset(MessageExtBrokerInner msg, short messageNum) {
        this.assignOffsetStore.increaseQueueOffset(msg, messageNum);
    }

    @Override
    public void increaseLmqOffset(String topic, int queueId, short delta) throws ConsumeQueueException {
        this.assignOffsetStore.increaseLmqOffset(topic, queueId, delta);
    }

    @Override
    public long getLmqQueueOffset(String topic, int queueId) throws ConsumeQueueException {
        return this.assignOffsetStore.getLmqQueueOffset(topic, queueId);
    }

    @Override
    public void recoverOffsetTable(long minPhyOffset) {
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            store.recoverOffsetTable(minPhyOffset);
        }
    }

    @Override
    public Long getMaxOffset(String topic, int queueId) throws ConsumeQueueException {
        return this.currentReadStore.getMaxOffset(topic, queueId);
    }

    @Override
    public long getMinOffsetInQueue(String topic, int queueId) throws RocksDBException {
        return this.currentReadStore.getMinOffsetInQueue(topic, queueId);
    }

    @Override
    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp, BoundaryType boundaryType) throws RocksDBException {
        return this.currentReadStore.getOffsetInQueueByTime(topic, queueId, timestamp, boundaryType);
    }

    @Override
    public ConsumeQueueInterface findOrCreateConsumeQueue(String topic, int queueId) {
        return this.currentReadStore.findOrCreateConsumeQueue(topic, queueId);
    }

    @Override
    public ConsumeQueueInterface getConsumeQueue(String topic, int queueId) {
        return this.currentReadStore.getConsumeQueue(topic, queueId);
    }

    @Override
    public long getTotalSize() {
        long result = 0L;
        for (AbstractConsumeQueueStore store : this.innerConsumeQueueStoreList) {
            result += store.getTotalSize();
        }
        return result;
    }

    public RocksDBConsumeQueueStore getRocksDBConsumeQueueStore() {
        return this.rocksDBConsumeQueueStore;
    }

    @VisibleForTesting
    public ConsumeQueueStore getConsumeQueueStore() {
        return this.consumeQueueStore;
    }

    @VisibleForTesting
    public AbstractConsumeQueueStore getCurrentReadStore() {
        return this.currentReadStore;
    }

    @VisibleForTesting
    public AbstractConsumeQueueStore getAssignOffsetStore() {
        return this.assignOffsetStore;
    }

    public CheckRocksdbCqWriteResult doCheckCqWriteProgress(String requestTopic, long checkStoreTime, StoreType baseStoreType, StoreType compareStoreType) {
        CheckRocksdbCqWriteResult result = new CheckRocksdbCqWriteResult();
        AbstractConsumeQueueStore baseStore = this.getInnerStoreByStoreType(baseStoreType);
        AbstractConsumeQueueStore compareStore = this.getInnerStoreByStoreType(compareStoreType);
        if (baseStore == null || compareStore == null) {
            result.setCheckResult("baseStore or compareStore is null, no need check");
            result.setCheckStatus(CheckRocksdbCqWriteResult.CheckStatus.CHECK_OK.getValue());
            return result;
        }
        ConcurrentMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>> cqTable = baseStore.getConsumeQueueTable();
        StringBuilder diffResult = new StringBuilder();
        try {
            if (StringUtils.isNotBlank((CharSequence)requestTopic)) {
                boolean checkResult = this.processConsumeQueuesForTopic((ConcurrentMap)cqTable.get(requestTopic), requestTopic, compareStore, diffResult, true, checkStoreTime);
                result.setCheckResult(diffResult.toString());
                result.setCheckStatus(checkResult ? CheckRocksdbCqWriteResult.CheckStatus.CHECK_OK.getValue() : CheckRocksdbCqWriteResult.CheckStatus.CHECK_NOT_OK.getValue());
                return result;
            }
            int successNum = 0;
            int checkSize = 0;
            for (Map.Entry topicEntry : cqTable.entrySet()) {
                boolean checkResult = this.processConsumeQueuesForTopic((ConcurrentMap)topicEntry.getValue(), (String)topicEntry.getKey(), compareStore, diffResult, false, checkStoreTime);
                successNum += checkResult ? 1 : 0;
                ++checkSize;
            }
            boolean checkReady = successNum == checkSize;
            String checkResultString = checkReady ? String.format("all topic is ready, checkSize: %s, currentQueueNum: %s", checkSize, cqTable.size()) : String.format("success/all : %s/%s, currentQueueNum: %s", successNum, checkSize, cqTable.size());
            diffResult.append("check all topic finish, ").append(checkResultString);
            result.setCheckResult(diffResult.toString());
            result.setCheckStatus(checkReady ? CheckRocksdbCqWriteResult.CheckStatus.CHECK_OK.getValue() : CheckRocksdbCqWriteResult.CheckStatus.CHECK_NOT_OK.getValue());
        }
        catch (Exception e) {
            log.error("CheckRocksdbCqWriteProgressCommand error", (Throwable)e);
            result.setCheckResult(e.getMessage() + Arrays.toString(e.getStackTrace()));
            result.setCheckStatus(CheckRocksdbCqWriteResult.CheckStatus.CHECK_ERROR.getValue());
        }
        return result;
    }

    private boolean processConsumeQueuesForTopic(ConcurrentMap<Integer, ConsumeQueueInterface> queueMap, String topic, AbstractConsumeQueueStore abstractConsumeQueueStore, StringBuilder diffResult, boolean printDetail, long checkpointByStoreTime) {
        boolean processResult = true;
        block2: for (Map.Entry queueEntry : queueMap.entrySet()) {
            Integer queueId = (Integer)queueEntry.getKey();
            ConsumeQueueInterface baseCQ = (ConsumeQueueInterface)queueEntry.getValue();
            ConsumeQueueInterface compareCQ = abstractConsumeQueueStore.findOrCreateConsumeQueue(topic, queueId);
            if (printDetail) {
                String format = String.format("[topic: %s, queue:  %s] \n  kvEarliest : %s |  kvLatest : %s \n fileEarliest: %s | fileEarliest: %s ", topic, queueId, compareCQ.getEarliestUnit(), compareCQ.getLatestUnit(), baseCQ.getEarliestUnit(), baseCQ.getLatestUnit());
                diffResult.append(format).append("\n");
            }
            long minOffsetByTime = 0L;
            try {
                minOffsetByTime = abstractConsumeQueueStore.getOffsetInQueueByTime(topic, queueId, checkpointByStoreTime, BoundaryType.UPPER);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long minOffsetInQueue = compareCQ.getMinOffsetInQueue();
            long checkFrom = Math.max(minOffsetInQueue, minOffsetByTime);
            long checkTo = baseCQ.getMaxOffsetInQueue() - 1L;
            Pair<CqUnit, Long> fileLatestCq = baseCQ.getCqUnitAndStoreTime(checkTo);
            if (fileLatestCq != null && (Long)fileLatestCq.getObject2() < checkpointByStoreTime) continue;
            for (long i = checkFrom; i <= checkTo; ++i) {
                Pair<CqUnit, Long> baseCqUnit = baseCQ.getCqUnitAndStoreTime(i);
                Pair<CqUnit, Long> compareCqUnit = compareCQ.getCqUnitAndStoreTime(i);
                if (baseCqUnit != null && compareCqUnit != null && this.checkCqUnitEqual((CqUnit)compareCqUnit.getObject1(), (CqUnit)baseCqUnit.getObject1())) continue;
                log.error(String.format("[topic: %s, queue: %s, offset: %s] \n file : %s  \n  kv : %s \n", topic, queueId, i, compareCqUnit != null ? compareCqUnit.getObject1() : "null", baseCqUnit != null ? baseCqUnit.getObject1() : "null"));
                processResult = false;
                continue block2;
            }
        }
        return processResult;
    }

    private boolean checkCqUnitEqual(CqUnit cqUnit1, CqUnit cqUnit2) {
        if (cqUnit1.getQueueOffset() != cqUnit2.getQueueOffset()) {
            return false;
        }
        if (cqUnit1.getSize() != cqUnit2.getSize()) {
            return false;
        }
        if (cqUnit1.getPos() != cqUnit2.getPos()) {
            return false;
        }
        if (cqUnit1.getBatchNum() != cqUnit2.getBatchNum()) {
            return false;
        }
        return cqUnit1.getTagsCode() == cqUnit2.getTagsCode();
    }

    private AbstractConsumeQueueStore getInnerStoreByString(String storeTypeString) {
        if (StoreType.DEFAULT.getStoreType().equalsIgnoreCase(storeTypeString)) {
            return this.consumeQueueStore;
        }
        if (StoreType.DEFAULT_ROCKSDB.getStoreType().equalsIgnoreCase(storeTypeString)) {
            return this.rocksDBConsumeQueueStore;
        }
        return null;
    }

    private AbstractConsumeQueueStore getInnerStoreByStoreType(StoreType storeType) {
        switch (storeType) {
            case DEFAULT: {
                return this.consumeQueueStore;
            }
            case DEFAULT_ROCKSDB: {
                return this.rocksDBConsumeQueueStore;
            }
        }
        return null;
    }
}

