/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.snapshot.file;

import io.openmessaging.storage.dledger.snapshot.SnapshotReader;
import io.openmessaging.storage.dledger.snapshot.SnapshotStore;
import io.openmessaging.storage.dledger.snapshot.SnapshotWriter;
import io.openmessaging.storage.dledger.snapshot.file.FileSnapshotReader;
import io.openmessaging.storage.dledger.snapshot.file.FileSnapshotWriter;
import io.openmessaging.storage.dledger.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSnapshotStore
implements SnapshotStore {
    private static Logger logger = LoggerFactory.getLogger(FileSnapshotStore.class);
    private final String snapshotStoreBaseDir;

    public FileSnapshotStore(String snapshotStoreBaseDir) {
        this.snapshotStoreBaseDir = snapshotStoreBaseDir;
        this.initStore();
    }

    private void initStore() {
        File dir = new File(this.snapshotStoreBaseDir);
        try {
            IOUtils.mkDir(dir);
        }
        catch (IOException e) {
            logger.error("Unable to create snapshot storage directory {}", (Object)this.snapshotStoreBaseDir, (Object)e);
            throw new RuntimeException(e);
        }
        File tmpSnapshot = new File(this.snapshotStoreBaseDir + File.separator + "tmp");
        if (tmpSnapshot.exists()) {
            try {
                IOUtils.deleteFile(tmpSnapshot);
            }
            catch (IOException e) {
                logger.error("Unable to clean temp snapshots {}", (Object)tmpSnapshot.getPath(), (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public SnapshotWriter createSnapshotWriter() {
        String tmpSnapshotStorePath = this.snapshotStoreBaseDir + File.separator + "tmp";
        if (new File(tmpSnapshotStorePath).exists()) {
            try {
                IOUtils.deleteFile(new File(tmpSnapshotStorePath));
            }
            catch (IOException e) {
                logger.error("Unable to delete temp snapshot: {}", (Object)tmpSnapshotStorePath, (Object)e);
                return null;
            }
        }
        File dir = new File(tmpSnapshotStorePath);
        try {
            IOUtils.mkDir(dir);
        }
        catch (IOException e) {
            logger.error("Unable to create snapshot storage directory: " + tmpSnapshotStorePath, (Throwable)e);
            return null;
        }
        return new FileSnapshotWriter(tmpSnapshotStorePath, this);
    }

    @Override
    public SnapshotReader createSnapshotReader() {
        long lastSnapshotIndex = this.getLastSnapshotIdx();
        if (lastSnapshotIndex == -1L) {
            logger.warn("No snapshot exists");
            return null;
        }
        String snapshotStorePath = this.snapshotStoreBaseDir + File.separator + "snapshot_" + lastSnapshotIndex;
        return new FileSnapshotReader(snapshotStorePath);
    }

    private long getLastSnapshotIdx() {
        File[] snapshotFiles = new File(this.snapshotStoreBaseDir).listFiles();
        long lastSnapshotIdx = -1L;
        if (snapshotFiles != null && snapshotFiles.length > 0) {
            for (File snapshotFile : snapshotFiles) {
                String fileName = snapshotFile.getName();
                if (!fileName.startsWith("snapshot_")) continue;
                lastSnapshotIdx = Math.max(Long.parseLong(fileName.substring("snapshot_".length())), lastSnapshotIdx);
            }
        }
        return lastSnapshotIdx;
    }

    public String getSnapshotStoreBaseDir() {
        return this.snapshotStoreBaseDir;
    }
}

