/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.otlp.metrics;

import java.io.IOException;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.otlp.metrics.SummaryDataPointMarshaler;
import org.apache.rocketmq.shaded.io.opentelemetry.proto.metrics.v1.internal.Summary;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.SummaryData;

final class SummaryMarshaler
extends MarshalerWithSize {
    private final SummaryDataPointMarshaler[] dataPoints;

    static SummaryMarshaler create(SummaryData summary) {
        SummaryDataPointMarshaler[] dataPointMarshalers = SummaryDataPointMarshaler.createRepeated(summary.getPoints());
        return new SummaryMarshaler(dataPointMarshalers);
    }

    private SummaryMarshaler(SummaryDataPointMarshaler[] dataPoints) {
        super(SummaryMarshaler.calculateSize(dataPoints));
        this.dataPoints = dataPoints;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeRepeatedMessage(Summary.DATA_POINTS, this.dataPoints);
    }

    private static int calculateSize(SummaryDataPointMarshaler[] dataPoints) {
        int size = 0;
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Summary.DATA_POINTS, (Marshaler[])dataPoints);
    }
}

