/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramAccumulation;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.resources.Resource;

public final class DoubleExplicitBucketHistogramAggregator
implements Aggregator<ExplicitBucketHistogramAccumulation, DoubleExemplarData> {
    private final double[] boundaries;
    private final List<Double> boundaryList;
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;

    public DoubleExplicitBucketHistogramAggregator(double[] boundaries, Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier) {
        this.boundaries = boundaries;
        ArrayList<Double> boundaryList = new ArrayList<Double>(this.boundaries.length);
        for (double v : this.boundaries) {
            boundaryList.add(v);
        }
        this.boundaryList = Collections.unmodifiableList(boundaryList);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<ExplicitBucketHistogramAccumulation, DoubleExemplarData> createHandle() {
        return new Handle(this.boundaries, this.reservoirSupplier.get());
    }

    @Override
    public ExplicitBucketHistogramAccumulation merge(ExplicitBucketHistogramAccumulation previous, ExplicitBucketHistogramAccumulation current) {
        long[] previousCounts = previous.getCounts();
        long[] mergedCounts = new long[previousCounts.length];
        for (int i = 0; i < previousCounts.length; ++i) {
            mergedCounts[i] = previousCounts[i] + current.getCounts()[i];
        }
        double min2 = -1.0;
        double max = -1.0;
        if (previous.hasMinMax() && current.hasMinMax()) {
            min2 = Math.min(previous.getMin(), current.getMin());
            max = Math.max(previous.getMax(), current.getMax());
        } else if (previous.hasMinMax()) {
            min2 = previous.getMin();
            max = previous.getMax();
        } else if (current.hasMinMax()) {
            min2 = current.getMin();
            max = current.getMax();
        }
        return ExplicitBucketHistogramAccumulation.create(previous.getSum() + current.getSum(), previous.hasMinMax() || current.hasMinMax(), min2, max, mergedCounts, current.getExemplars());
    }

    @Override
    public ExplicitBucketHistogramAccumulation diff(ExplicitBucketHistogramAccumulation previous, ExplicitBucketHistogramAccumulation current) {
        long[] previousCounts = previous.getCounts();
        long[] diffedCounts = new long[previousCounts.length];
        for (int i = 0; i < previousCounts.length; ++i) {
            diffedCounts[i] = current.getCounts()[i] - previousCounts[i];
        }
        return ExplicitBucketHistogramAccumulation.create(current.getSum() - previous.getSum(), false, -1.0, -1.0, diffedCounts, current.getExemplars());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Map<Attributes, ExplicitBucketHistogramAccumulation> accumulationByLabels, AggregationTemporality temporality, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return ImmutableMetricData.createDoubleHistogram(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ImmutableHistogramData.create(temporality, MetricDataUtils.toExplicitBucketHistogramPointList(accumulationByLabels, temporality == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos, this.boundaryList)));
    }

    static final class Handle
    extends AggregatorHandle<ExplicitBucketHistogramAccumulation, DoubleExemplarData> {
        private final double[] boundaries;
        private double sum;
        private double min;
        private double max;
        private long count;
        private final long[] counts;
        private final ReentrantLock lock = new ReentrantLock();

        Handle(double[] boundaries, ExemplarReservoir<DoubleExemplarData> reservoir) {
            super(reservoir);
            this.boundaries = boundaries;
            this.counts = new long[this.boundaries.length + 1];
            this.sum = 0.0;
            this.min = Double.MAX_VALUE;
            this.max = -1.0;
            this.count = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ExplicitBucketHistogramAccumulation doAccumulateThenReset(List<DoubleExemplarData> exemplars) {
            this.lock.lock();
            try {
                ExplicitBucketHistogramAccumulation acc = ExplicitBucketHistogramAccumulation.create(this.sum, this.count > 0L, this.count > 0L ? this.min : -1.0, this.count > 0L ? this.max : -1.0, Arrays.copyOf(this.counts, this.counts.length), exemplars);
                this.sum = 0.0;
                this.min = Double.MAX_VALUE;
                this.max = -1.0;
                this.count = 0L;
                Arrays.fill(this.counts, 0L);
                ExplicitBucketHistogramAccumulation explicitBucketHistogramAccumulation = acc;
                return explicitBucketHistogramAccumulation;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRecordDouble(double value) {
            int bucketIndex = ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, value);
            this.lock.lock();
            try {
                this.sum += value;
                this.min = Math.min(this.min, value);
                this.max = Math.max(this.max, value);
                ++this.count;
                int n = bucketIndex;
                this.counts[n] = this.counts[n] + 1L;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.doRecordDouble(value);
        }
    }
}

