/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.knnJudgement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.sedona.core.knnJudgement.GeometryDistanceComparator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.locationtech.jts.geom.Geometry;

public class KnnJudgement<U extends Geometry, T extends Geometry>
implements FlatMapFunction<Iterator<T>, T>,
Serializable {
    int k;
    U queryCenter;

    public KnnJudgement(U queryCenter, int k) {
        this.queryCenter = queryCenter;
        this.k = k;
    }

    public Iterator<T> call(Iterator<T> input) throws Exception {
        PriorityQueue<U> pq = new PriorityQueue<U>(this.k, new GeometryDistanceComparator<U>(this.queryCenter, false));
        while (input.hasNext()) {
            if (pq.size() < this.k) {
                pq.offer(input.next());
                continue;
            }
            Geometry curpoint = (Geometry)input.next();
            double distance = curpoint.distance((Geometry)this.queryCenter);
            double largestDistanceInPriQueue = ((Geometry)pq.peek()).distance((Geometry)this.queryCenter);
            if (!(largestDistanceInPriQueue > distance)) continue;
            pq.poll();
            pq.offer(curpoint);
        }
        ArrayList<U> res = new ArrayList<U>();
        if (pq.size() >= this.k) {
            for (int i = 0; i < this.k; ++i) {
                res.add(pq.poll());
            }
        } else {
            for (int i = 0; i < pq.size(); ++i) {
                res.add(pq.poll());
            }
        }
        return res.iterator();
    }
}

