/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.sedona_sql.expressions.FunctionResolver;
import org.apache.spark.sql.sedona_sql.expressions.FunctionResolver$NotMatch$;
import org.apache.spark.sql.sedona_sql.expressions.FunctionResolver$PerfectMatch$;
import org.apache.spark.sql.sedona_sql.expressions.InferrableFunction;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class FunctionResolver$ {
    public static final FunctionResolver$ MODULE$ = new FunctionResolver$();

    public InferrableFunction resolveFunction(Seq<Expression> expressions, Seq<InferrableFunction> functionOverloads) {
        FunctionResolver.MatchResult matchResult;
        Seq functionsWithMatchingArity = (Seq)functionOverloads.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FunctionResolver$.$anonfun$resolveFunction$1(expressions, x$1)));
        if (functionsWithMatchingArity.length() == 1) {
            return (InferrableFunction)functionsWithMatchingArity.head();
        }
        if (functionsWithMatchingArity.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(41).append("No overloaded function accepts ").append(expressions.length()).append(" arguments").toString());
        }
        Seq functionWithMatchResults = (Seq)functionsWithMatchingArity.map((Function1 & Serializable)function -> {
            FunctionResolver.MatchResult matchResult = MODULE$.matchFunctionToInputTypes(expressions, (InferrableFunction)function);
            return new Tuple2(function, (Object)matchResult);
        });
        Tuple2 bestMatch = (Tuple2)functionWithMatchResults.minBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)FunctionResolver$.$anonfun$resolveFunction$3(x0$1)), (Ordering)Ordering.Int$.MODULE$);
        Tuple2 tuple2 = bestMatch;
        if (tuple2 != null && FunctionResolver$NotMatch$.MODULE$.equals(matchResult = (FunctionResolver.MatchResult)tuple2._2())) {
            String candidateTypesMsg = ((IterableOnceOps)functionsWithMatchingArity.map((Function1 & Serializable)function -> new StringBuilder(4).append("  (").append(function.sparkInputTypes().mkString(", ")).append(")").toString())).mkString("\n");
            throw new IllegalArgumentException(new StringBuilder(77).append("Types of arguments does not match with function parameters. Candidates are: \n").append(candidateTypesMsg).toString());
        }
        if (tuple2 != null) {
            InferrableFunction function2 = (InferrableFunction)tuple2._1();
            Seq ambiguousMatches = (Seq)functionWithMatchResults.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)FunctionResolver$.$anonfun$resolveFunction$5(bestMatch, x0$2)));
            if (ambiguousMatches.length() == 1) {
                return function2;
            }
            String candidateTypesMsg = ((IterableOnceOps)ambiguousMatches.map((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    InferrableFunction function = (InferrableFunction)tuple2._1();
                    return new StringBuilder(4).append("  (").append(function.sparkInputTypes().mkString(", ")).append(")").toString();
                }
                throw new MatchError((Object)tuple2);
            })).mkString("\n");
            throw new IllegalArgumentException(new StringBuilder(42).append("Ambiguous function call. Candidates are: \n").append(candidateTypesMsg).toString());
        }
        throw new MatchError((Object)tuple2);
    }

    private FunctionResolver.MatchResult matchFunctionToInputTypes(Seq<Expression> expressions, InferrableFunction function) {
        if (expressions.length() != function.sparkInputTypes().length()) {
            return FunctionResolver$NotMatch$.MODULE$;
        }
        Seq inputMatchResults = (Seq)((IterableOps)expressions.zip(function.sparkInputTypes())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DataType argumentType;
                Expression expr = (Expression)tuple2._1();
                AbstractDataType parameterType = (AbstractDataType)tuple2._2();
                if (parameterType.acceptsType(argumentType = expr.dataType())) {
                    return FunctionResolver$PerfectMatch$.MODULE$;
                }
                Option option = TypeCoercion$.MODULE$.implicitCast(expr, parameterType);
                if (option instanceof Some) {
                    return new FunctionResolver.CoercedMatch(1);
                }
                if (None$.MODULE$.equals(option)) {
                    return FunctionResolver$NotMatch$.MODULE$;
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
        if (inputMatchResults.contains((Object)FunctionResolver$NotMatch$.MODULE$)) {
            return FunctionResolver$NotMatch$.MODULE$;
        }
        int numCoercedInputs = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)inputMatchResults.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)FunctionResolver$.$anonfun$matchFunctionToInputTypes$2(x0$2)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (numCoercedInputs == 0) {
            return FunctionResolver$PerfectMatch$.MODULE$;
        }
        return new FunctionResolver.CoercedMatch(numCoercedInputs);
    }

    public static final /* synthetic */ boolean $anonfun$resolveFunction$1(Seq expressions$1, InferrableFunction x$1) {
        return x$1.sparkInputTypes().length() == expressions$1.length();
    }

    public static final /* synthetic */ int $anonfun$resolveFunction$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            FunctionResolver.MatchResult matchResult = (FunctionResolver.MatchResult)tuple2._2();
            FunctionResolver.MatchResult matchResult2 = matchResult;
            if (FunctionResolver$NotMatch$.MODULE$.equals(matchResult2)) {
                return Integer.MAX_VALUE;
            }
            if (FunctionResolver$PerfectMatch$.MODULE$.equals(matchResult2)) {
                return 0;
            }
            if (matchResult2 instanceof FunctionResolver.CoercedMatch) {
                FunctionResolver.CoercedMatch coercedMatch = (FunctionResolver.CoercedMatch)matchResult2;
                int coercedInputs = coercedMatch.coercedInputs();
                return coercedInputs;
            }
            throw new MatchError((Object)matchResult2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$resolveFunction$5(Tuple2 bestMatch$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            FunctionResolver.MatchResult matchResult;
            FunctionResolver.MatchResult matchResult2 = matchResult = (FunctionResolver.MatchResult)tuple2._2();
            Object object = bestMatch$1._2();
            return !(matchResult2 != null ? !matchResult2.equals(object) : object != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$matchFunctionToInputTypes$2(Product x0$2) {
        Product product = x0$2;
        if (product instanceof FunctionResolver.CoercedMatch) {
            FunctionResolver.CoercedMatch coercedMatch = (FunctionResolver.CoercedMatch)product;
            int coercedInputs = coercedMatch.coercedInputs();
            return coercedInputs;
        }
        return 0;
    }

    private FunctionResolver$() {
    }
}

