/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import ucar.units.BaseUnit;
import ucar.units.DerivableUnit;
import ucar.units.DerivedUnit;
import ucar.units.MultiplyException;
import ucar.units.NameException;
import ucar.units.OperationException;
import ucar.units.QuantityDimension;
import ucar.units.Unit;
import ucar.units.UnitDimension;
import ucar.units.UnitImpl;
import ucar.units.UnitName;

public class DerivedUnitImpl
extends UnitImpl
implements DerivedUnit,
DerivableUnit {
    private static final long serialVersionUID = 1L;
    public static final DerivedUnitImpl DIMENSIONLESS = new DerivedUnitImpl();
    private UnitDimension dimension;

    protected DerivedUnitImpl() {
        this(new UnitDimension(), DerivedUnitImpl.dimensionlessID());
    }

    private static UnitName dimensionlessID() {
        UnitName id;
        try {
            id = UnitName.newUnitName("1", "1", "1");
        }
        catch (NameException e) {
            id = null;
        }
        return id;
    }

    protected DerivedUnitImpl(UnitDimension dimension) {
        this(dimension, null);
    }

    protected DerivedUnitImpl(UnitName id) {
        this(null, id);
    }

    protected DerivedUnitImpl(UnitDimension dimension, UnitName id) {
        super(id);
        this.dimension = dimension;
    }

    protected void setDimension(UnitDimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public final UnitDimension getDimension() {
        return this.dimension;
    }

    @Override
    public final QuantityDimension getQuantityDimension() {
        return this.getDimension().getQuantityDimension();
    }

    @Override
    public final boolean isReciprocalOf(DerivedUnit that) {
        return this.dimension.isReciprocalOf(that.getDimension());
    }

    @Override
    public final DerivedUnit getDerivedUnit() {
        return this;
    }

    @Override
    public final Unit clone(UnitName id) {
        return new DerivedUnitImpl(this.dimension, id);
    }

    @Override
    protected Unit myMultiplyBy(Unit that) throws MultiplyException {
        UnitDimension thatDimension;
        Unit result = this.dimension.getRank() == 0 ? that : (!(that instanceof DerivedUnit) ? that.multiplyBy(this) : ((thatDimension = ((DerivedUnit)that).getDimension()).getRank() == 0 ? this : new DerivedUnitImpl(this.dimension.multiplyBy(thatDimension))));
        return result;
    }

    @Override
    protected Unit myDivideBy(Unit that) throws OperationException {
        UnitDimension thatDimension;
        Unit result = this.dimension.getRank() == 0 ? that.raiseTo(-1) : (!(that instanceof DerivedUnit) ? that.divideInto(this) : ((thatDimension = ((DerivedUnit)that).getDimension()).getRank() == 0 ? this : new DerivedUnitImpl(this.dimension.divideBy(thatDimension))));
        return result;
    }

    @Override
    protected Unit myDivideInto(Unit that) throws OperationException {
        return that.divideBy(this);
    }

    @Override
    protected Unit myRaiseTo(int power) {
        return power == 1 ? this : new DerivedUnitImpl(this.dimension.raiseTo(power));
    }

    @Override
    public final float toDerivedUnit(float amount) {
        return amount;
    }

    @Override
    public final double toDerivedUnit(double amount) {
        return amount;
    }

    @Override
    public final float[] toDerivedUnit(float[] input, float[] output) {
        if (input != output) {
            System.arraycopy(input, 0, output, 0, input.length);
        }
        return output;
    }

    @Override
    public final double[] toDerivedUnit(double[] input, double[] output) {
        if (input != output) {
            System.arraycopy(input, 0, output, 0, input.length);
        }
        return output;
    }

    @Override
    public final float fromDerivedUnit(float amount) {
        return amount;
    }

    @Override
    public final double fromDerivedUnit(double amount) {
        return amount;
    }

    @Override
    public final float[] fromDerivedUnit(float[] input, float[] output) {
        return this.toDerivedUnit(input, output);
    }

    @Override
    public final double[] fromDerivedUnit(double[] input, double[] output) {
        return this.toDerivedUnit(input, output);
    }

    @Override
    public final boolean isCompatible(Unit that) {
        DerivedUnit unit = that.getDerivedUnit();
        return this.equals(unit) || this.isReciprocalOf(unit);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DerivedUnit)) {
            return false;
        }
        DerivedUnit that = (DerivedUnit)object;
        return (!(this instanceof BaseUnit) || !(that instanceof BaseUnit)) && this.dimension.equals(that.getDimension());
    }

    @Override
    public int hashCode() {
        return this instanceof BaseUnit ? System.identityHashCode(this) : this.dimension.hashCode();
    }

    @Override
    public boolean isDimensionless() {
        return this.dimension.isDimensionless();
    }

    @Override
    public String toString() {
        String string = super.toString();
        return string != null ? string : this.getCanonicalString();
    }

    @Override
    public String getCanonicalString() {
        return this.dimension.toString();
    }
}

