/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.joinJudgement.DedupParams;
import org.apache.sedona.core.spatialPartitioning.SpatialPartitioner;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Tuple2;

public class GenericUniquePartitioner
extends SpatialPartitioner {
    private SpatialPartitioner parent;

    public GenericUniquePartitioner(SpatialPartitioner parent) {
        this.parent = parent;
    }

    @Override
    public GridType getGridType() {
        return this.parent.gridType;
    }

    @Override
    public List<Envelope> getGrids() {
        return this.parent.grids;
    }

    public Iterator<Tuple2<Integer, Geometry>> placeObject(Geometry spatialObject) throws Exception {
        Iterator<Tuple2<Integer, Geometry>> it = this.parent.placeObject(spatialObject);
        int minPartitionId = Integer.MAX_VALUE;
        Geometry minGeometry = null;
        while (it.hasNext()) {
            Tuple2<Integer, Geometry> value = it.next();
            if ((Integer)value._1() >= minPartitionId) continue;
            minPartitionId = (Integer)value._1();
            minGeometry = (Geometry)value._2();
        }
        HashSet<Tuple2> out = new HashSet<Tuple2>();
        if (minGeometry != null) {
            out.add(new Tuple2((Object)minPartitionId, minGeometry));
        }
        return out.iterator();
    }

    @Override
    @Nullable
    public DedupParams getDedupParams() {
        throw new UnsupportedOperationException("Unique partitioner cannot deduplicate join results");
    }

    public int numPartitions() {
        return this.parent.numPartitions();
    }
}

