/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.fieldname;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.dbf.DbfParseUtil;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.dbf.FieldDescriptor;

public class FieldnameRecordReader
extends RecordReader<Long, String> {
    Path[] paths = null;
    long KEY_VALUE = 0L;
    FSDataInputStream inputStream = null;
    Configuration configuration = null;
    int id = -1;
    DbfParseUtil dbfParser = null;

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        CombineFileSplit split = (CombineFileSplit)inputSplit;
        this.paths = split.getPaths();
        this.configuration = taskAttemptContext.getConfiguration();
        this.id = -1;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        ++this.id;
        return this.id < this.paths.length;
    }

    public Long getCurrentKey() throws IOException, InterruptedException {
        return this.KEY_VALUE;
    }

    public String getCurrentValue() throws IOException, InterruptedException {
        FileSystem fs = this.paths[this.id].getFileSystem(this.configuration);
        this.inputStream = fs.open(this.paths[this.id]);
        this.dbfParser = new DbfParseUtil();
        this.dbfParser.parseFileHead((DataInputStream)this.inputStream);
        String fieldNames = "";
        List<FieldDescriptor> fieldDescriptors = this.dbfParser.getFieldDescriptors();
        for (int i = 0; i < fieldDescriptors.size(); ++i) {
            fieldNames = i == 0 ? fieldNames + fieldDescriptors.get(i).getFieldName() : fieldNames + "\t" + fieldDescriptors.get(i).getFieldName();
        }
        return fieldNames;
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.id / (float)this.paths.length;
    }

    public void close() throws IOException {
    }
}

