/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;

public enum DataType {
    BOOLEAN("boolean", 1, Boolean.TYPE, false),
    BYTE("byte", 1, Byte.TYPE, false),
    CHAR("char", 1, Character.TYPE, false),
    SHORT("short", 2, Short.TYPE, false),
    INT("int", 4, Integer.TYPE, false),
    LONG("long", 8, Long.TYPE, false),
    FLOAT("float", 4, Float.TYPE, false),
    DOUBLE("double", 8, Double.TYPE, false),
    SEQUENCE("Sequence", 4, StructureDataIterator.class, false),
    STRING("String", 4, String.class, false),
    STRUCTURE("Structure", 0, StructureData.class, false),
    ENUM1("enum1", 1, Byte.TYPE, false),
    ENUM2("enum2", 2, Short.TYPE, false),
    ENUM4("enum4", 4, Integer.TYPE, false),
    OPAQUE("opaque", 1, ByteBuffer.class, false),
    OBJECT("object", 1, Object.class, false),
    UBYTE("ubyte", 1, Byte.TYPE, true),
    USHORT("ushort", 2, Short.TYPE, true),
    UINT("uint", 4, Integer.TYPE, true),
    ULONG("ulong", 8, Long.TYPE, true);

    private final String niceName;
    private final int size;
    private final Class primitiveClass;
    private final Signedness signedness;

    private DataType(String s2, int size, Class primitiveClass, boolean isUnsigned) {
        this(s2, size, primitiveClass, isUnsigned ? Signedness.UNSIGNED : Signedness.SIGNED);
    }

    private DataType(String s2, int size, Class primitiveClass, Signedness signedness) {
        this.niceName = s2;
        this.size = size;
        this.primitiveClass = primitiveClass;
        this.signedness = signedness;
    }

    public String toString() {
        return this.niceName;
    }

    public int getSize() {
        return this.size;
    }

    public Class getPrimitiveClassType() {
        return this.primitiveClass;
    }

    public Signedness getSignedness() {
        return this.signedness;
    }

    public boolean isUnsigned() {
        return this.signedness == Signedness.UNSIGNED;
    }

    public boolean isString() {
        return this == STRING || this == CHAR;
    }

    public boolean isNumeric() {
        return this == FLOAT || this == DOUBLE || this.isIntegral();
    }

    public boolean isIntegral() {
        return this == BYTE || this == INT || this == SHORT || this == LONG || this == UBYTE || this == UINT || this == USHORT || this == ULONG;
    }

    public boolean isFloatingPoint() {
        return this == FLOAT || this == DOUBLE;
    }

    public boolean isEnum() {
        return this == ENUM1 || this == ENUM2 || this == ENUM4;
    }

    public DataType withSignedness(Signedness signedness) {
        switch (this) {
            case BYTE: 
            case UBYTE: {
                return signedness == Signedness.UNSIGNED ? UBYTE : BYTE;
            }
            case SHORT: 
            case USHORT: {
                return signedness == Signedness.UNSIGNED ? USHORT : SHORT;
            }
            case INT: 
            case UINT: {
                return signedness == Signedness.UNSIGNED ? UINT : INT;
            }
            case LONG: 
            case ULONG: {
                return signedness == Signedness.UNSIGNED ? ULONG : LONG;
            }
        }
        return this;
    }

    public boolean isEnumCompatible(DataType inferred) {
        if (inferred == null) {
            return false;
        }
        if (this == inferred) {
            return true;
        }
        switch (this) {
            case ENUM1: {
                return inferred == BYTE || inferred == STRING;
            }
            case ENUM2: {
                return inferred == SHORT || inferred == STRING;
            }
            case ENUM4: {
                return inferred == INT || inferred == STRING;
            }
        }
        return false;
    }

    public static DataType enumTypeize(DataType dt) {
        switch (dt) {
            case BYTE: 
            case UBYTE: {
                return ENUM1;
            }
            case SHORT: 
            case USHORT: {
                return ENUM2;
            }
            case INT: 
            case UINT: {
                return ENUM4;
            }
        }
        return dt;
    }

    public static DataType getType(String name) {
        if (name == null) {
            return null;
        }
        try {
            return DataType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static DataType getType(Array arr) {
        return DataType.getType(arr.getElementType(), arr.isUnsigned());
    }

    public static DataType getType(Class c, boolean isUnsigned) {
        if (c == Float.TYPE || c == Float.class) {
            return FLOAT;
        }
        if (c == Double.TYPE || c == Double.class) {
            return DOUBLE;
        }
        if (c == Short.TYPE || c == Short.class) {
            return isUnsigned ? USHORT : SHORT;
        }
        if (c == Integer.TYPE || c == Integer.class) {
            return isUnsigned ? UINT : INT;
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return isUnsigned ? UBYTE : BYTE;
        }
        if (c == Character.TYPE || c == Character.class) {
            return CHAR;
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return BOOLEAN;
        }
        if (c == Long.TYPE || c == Long.class) {
            return isUnsigned ? ULONG : LONG;
        }
        if (c == String.class) {
            return STRING;
        }
        if (c == StructureData.class) {
            return STRUCTURE;
        }
        if (c == StructureDataIterator.class) {
            return SEQUENCE;
        }
        if (c == ByteBuffer.class) {
            return OPAQUE;
        }
        return OBJECT;
    }

    public static Number widenNumber(Number number) {
        if (number instanceof Byte) {
            return DataType.unsignedByteToShort(number.byteValue());
        }
        if (number instanceof Short) {
            return DataType.unsignedShortToInt(number.shortValue());
        }
        if (number instanceof Integer) {
            return DataType.unsignedIntToLong(number.intValue());
        }
        if (number instanceof Long) {
            return DataType.unsignedLongToBigInt(number.longValue());
        }
        return number;
    }

    public static Number widenNumberIfNegative(Number number) {
        if (number instanceof Byte && number.byteValue() < 0) {
            return DataType.unsignedByteToShort(number.byteValue());
        }
        if (number instanceof Short && number.shortValue() < 0) {
            return DataType.unsignedShortToInt(number.shortValue());
        }
        if (number instanceof Integer && number.intValue() < 0) {
            return DataType.unsignedIntToLong(number.intValue());
        }
        if (number instanceof Long && number.longValue() < 0L) {
            return DataType.unsignedLongToBigInt(number.longValue());
        }
        return number;
    }

    public static BigInteger unsignedLongToBigInt(long l) {
        if (l >= 0L) {
            return BigInteger.valueOf(l);
        }
        int upper = (int)(l >>> 32);
        int lower = (int)l;
        return BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
    }

    public static long unsignedIntToLong(int i) {
        return Integer.toUnsignedLong(i);
    }

    public static int unsignedShortToInt(short s2) {
        return Short.toUnsignedInt(s2);
    }

    public static short unsignedByteToShort(byte b) {
        return (short)Byte.toUnsignedInt(b);
    }

    public static enum Signedness {
        SIGNED,
        UNSIGNED;

    }
}

