/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.apache.sedona.common.utils.GeomUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.linearref.LinearGeometryBuilder;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeometrySplitter {
    static final Logger logger = LoggerFactory.getLogger(GeometrySplitter.class);
    private final GeometryFactory geometryFactory;

    public GeometrySplitter(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public GeometryCollection split(Geometry input, Geometry blade) {
        GeometryCollection result = null;
        if (GeomUtils.geometryIsLineal(input)) {
            result = this.splitLines(input, blade);
        } else if (GeomUtils.geometryIsPolygonal(input)) {
            result = this.splitPolygons(input, blade);
        }
        return result;
    }

    public MultiLineString splitLines(Geometry input, Geometry blade) {
        MultiLineString result = null;
        if (GeomUtils.geometryIsPolygonal(blade)) {
            blade = blade.getBoundary();
        }
        if (GeomUtils.geometryIsPuntal(blade)) {
            result = this.splitLinesByPoints(input, blade);
        } else if (GeomUtils.geometryIsLineal(blade)) {
            result = this.splitLinesByLines(input, blade);
        }
        return result;
    }

    public MultiPolygon splitPolygons(Geometry input, Geometry blade) {
        MultiPolygon result = null;
        if (GeomUtils.geometryIsPolygonal(blade)) {
            blade = blade.getBoundary();
        }
        if (GeomUtils.geometryIsLineal(blade)) {
            result = this.splitPolygonsByLines(input, blade);
        }
        return result;
    }

    private MultiLineString splitLinesByPoints(Geometry lines, Geometry points) {
        Deque<Coordinate> pointCoords = this.getOrderedCoords(points);
        LinearGeometryBuilder lineBuilder = new LinearGeometryBuilder(this.geometryFactory);
        lineBuilder.setIgnoreInvalidLines(true);
        for (int lineIndex = 0; lineIndex < lines.getNumGeometries(); ++lineIndex) {
            this.splitLineStringAtCoordinates((LineString)lines.getGeometryN(lineIndex), pointCoords, lineBuilder);
        }
        MultiLineString result = (MultiLineString)this.ensureMultiGeometryOfDimensionN(lineBuilder.getGeometry(), 1);
        return result;
    }

    private MultiLineString splitLinesByLines(Geometry inputLines, Geometry blade) {
        Geometry diff = inputLines.difference(blade);
        if (diff instanceof MultiLineString) {
            return (MultiLineString)diff;
        }
        return this.geometryFactory.createMultiLineString(new LineString[]{(LineString)inputLines});
    }

    private MultiPolygon splitPolygonsByLines(Geometry polygons, Geometry blade) {
        ArrayList<Polygon> validResults = new ArrayList<Polygon>();
        for (int polygonIndex = 0; polygonIndex < polygons.getNumGeometries(); ++polygonIndex) {
            Geometry originalPolygon = polygons.getGeometryN(polygonIndex);
            Geometry candidatePolygons = this.generateCandidatePolygons(originalPolygon, blade);
            this.addValidPolygonsToList(candidatePolygons, originalPolygon, validResults);
        }
        return this.geometryFactory.createMultiPolygon(validResults.toArray(new Polygon[0]));
    }

    private Deque<Coordinate> getOrderedCoords(Geometry geometry) {
        Object[] pointCoords = geometry.getCoordinates();
        ArrayDeque<Coordinate> coordsDeque = new ArrayDeque<Coordinate>(pointCoords.length);
        Arrays.sort(pointCoords);
        coordsDeque.addAll(Arrays.asList(pointCoords));
        return coordsDeque;
    }

    private void splitLineStringAtCoordinates(LineString line, Deque<Coordinate> pointCoords, LinearGeometryBuilder lineBuilder) {
        Coordinate[] lineCoords = line.getCoordinates();
        if (lineCoords.length > 1) {
            lineBuilder.add(lineCoords[0]);
            for (int endCoordIndex = 1; endCoordIndex < lineCoords.length; ++endCoordIndex) {
                Coordinate endCoord = lineCoords[endCoordIndex];
                Iterator<Coordinate> coordIterator = this.getIteratorForSegmentDirection(pointCoords, lineBuilder.getLastCoordinate(), endCoord);
                this.applyCoordsToLineSegment(lineBuilder, coordIterator, endCoord);
            }
            lineBuilder.endLine();
        }
    }

    private Iterator<Coordinate> getIteratorForSegmentDirection(Deque<Coordinate> coords, Coordinate startCoord, Coordinate endCoord) {
        Iterator<Coordinate> coordIterator = endCoord.compareTo(startCoord) == -1 ? coords.descendingIterator() : coords.iterator();
        return coordIterator;
    }

    private void applyCoordsToLineSegment(LinearGeometryBuilder lineBuilder, Iterator<Coordinate> coordIterator, Coordinate endCoord) {
        while (coordIterator.hasNext()) {
            Coordinate lastCoord;
            Coordinate pointCoord = coordIterator.next();
            if (!this.coordIsOnLineSegment(pointCoord, lastCoord = lineBuilder.getLastCoordinate(), endCoord)) continue;
            this.splitOnCoord(lineBuilder, pointCoord);
        }
        lineBuilder.add(endCoord, false);
    }

    private boolean coordIsOnLineSegment(Coordinate coord, Coordinate startCoord, Coordinate endCoord) {
        boolean coordIsWithinVerticalRange;
        boolean result = false;
        boolean segmentIsVertical = startCoord.x == endCoord.x;
        boolean bl = coordIsWithinVerticalRange = Math.min(startCoord.y, endCoord.y) <= coord.y && coord.y <= Math.max(startCoord.y, endCoord.y);
        if (coordIsWithinVerticalRange) {
            if (segmentIsVertical) {
                if (coord.x == startCoord.x) {
                    result = true;
                }
            } else {
                double m3 = (startCoord.y - endCoord.y) / (startCoord.x - endCoord.x);
                double yInt = startCoord.y - startCoord.x * m3;
                if (coord.y == coord.x * m3 + yInt) {
                    result = true;
                }
            }
        }
        return result;
    }

    private void splitOnCoord(LinearGeometryBuilder lineBuilder, Coordinate coord) {
        lineBuilder.add(coord, false);
        lineBuilder.endLine();
        lineBuilder.add(coord, true);
    }

    private Geometry generateCandidatePolygons(Geometry polygons, Geometry blade) {
        Geometry bladeWithinPolygons = blade.intersection(polygons);
        Geometry totalLineWork = polygons.getBoundary().union(bladeWithinPolygons);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(totalLineWork);
        return polygonizer.getGeometry();
    }

    private void addValidPolygonsToList(Geometry polygons, Geometry original, List<Polygon> list) {
        for (int i = 0; i < polygons.getNumGeometries(); ++i) {
            Geometry candidateResult = polygons.getGeometryN(i);
            if (!(candidateResult instanceof Polygon) || !original.contains(candidateResult)) continue;
            list.add((Polygon)candidateResult);
        }
    }

    private GeometryCollection ensureMultiGeometryOfDimensionN(Geometry geometry, int dimension) {
        GeometryCollection result = null;
        if (geometry != null) {
            if (dimension == 0 && geometry instanceof MultiPoint) {
                result = (MultiPoint)geometry;
            } else if (dimension == 1 && geometry instanceof MultiLineString) {
                result = (MultiLineString)geometry;
            } else if (dimension == 2 && geometry instanceof MultiPolygon) {
                result = (MultiPolygon)geometry;
            } else {
                ArrayList<Geometry> validGeometries = new ArrayList<Geometry>();
                for (int n = 0; n < geometry.getNumGeometries(); ++n) {
                    Geometry candidateGeometry = geometry.getGeometryN(n);
                    if (candidateGeometry.getDimension() != dimension) continue;
                    validGeometries.add(candidateGeometry);
                }
                switch (dimension) {
                    case 0: {
                        result = this.geometryFactory.createMultiPoint(validGeometries.toArray(new Point[0]));
                        break;
                    }
                    case 1: {
                        result = this.geometryFactory.createMultiLineString(validGeometries.toArray(new LineString[0]));
                        break;
                    }
                    case 2: {
                        result = this.geometryFactory.createMultiPolygon(validGeometries.toArray(new Polygon[0]));
                    }
                }
            }
        }
        return result;
    }
}

