% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_rdd.R
\name{crs_transform}
\alias{crs_transform}
\title{Perform a CRS transformation.}
\usage{
crs_transform(x, src_epsg_crs_code, dst_epsg_crs_code, strict = FALSE)
}
\arguments{
\item{x}{The spatial RDD to be processed.}

\item{src_epsg_crs_code}{Coordinate reference system to transform from
(e.g., "epsg:4326", "epsg:3857", etc).}

\item{dst_epsg_crs_code}{Coordinate reference system to transform to.
(e.g., "epsg:4326", "epsg:3857", etc).}

\item{strict}{If FALSE (default), then ignore the "Bursa-Wolf Parameters
Required" error.}
}
\value{
The transformed SpatialRDD.
}
\description{
Transform data within a spatial RDD from one coordinate reference system to
another. This uses the lon/lat order since v1.5.0. Before, it used lat/lon
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  input_location <- "/dev/null" # replace it with the path to your input file
  rdd <- sedona_read_geojson_to_typed_rdd(
    sc,
    location = input_location, type = "polygon"
  )
  crs_transform(
    rdd,
    src_epsg_crs_code = "epsg:4326", dst_epsg_crs_code = "epsg:3857"
  )
}

}
