/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Polygon;
import com.google.common.geometry.S2Polyline;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.List;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.S2Geography.GeographyCollection;
import org.apache.sedona.common.S2Geography.MultiPolygonGeography;
import org.apache.sedona.common.S2Geography.PointGeography;
import org.apache.sedona.common.S2Geography.PolygonGeography;
import org.apache.sedona.common.S2Geography.PolylineGeography;
import org.apache.sedona.common.S2Geography.SinglePointGeography;
import org.apache.sedona.common.S2Geography.SinglePolylineGeography;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.Ordinate;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.OutputStreamOutStream;

public class WKBWriter {
    private EnumSet<Ordinate> outputOrdinates;
    private int outputDimension = 2;
    private int byteOrder;
    private boolean includeSRID = false;
    private ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
    private OutStream byteArrayOutStream = new OutputStreamOutStream((OutputStream)this.byteArrayOS);
    private byte[] buf = new byte[8];

    public static String bytesToHex(byte[] bytes) {
        return WKBWriter.toHex(bytes);
    }

    public static String toHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            buf.append(WKBWriter.toHexDigit(b >> 4 & 0xF));
            buf.append(WKBWriter.toHexDigit(b & 0xF));
        }
        return buf.toString();
    }

    private static char toHexDigit(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("Nibble value out of range: " + n);
        }
        if (n <= 9) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }

    public WKBWriter() {
        this(2, 1);
    }

    public WKBWriter(int outputDimension) {
        this(outputDimension, 1);
    }

    public WKBWriter(int outputDimension, boolean includeSRID) {
        this(outputDimension, 1, includeSRID);
    }

    public WKBWriter(int outputDimension, int byteOrder) {
        this(outputDimension, byteOrder, false);
    }

    public WKBWriter(int outputDimension, int byteOrder, boolean includeSRID) {
        this.outputDimension = outputDimension;
        this.byteOrder = byteOrder;
        this.includeSRID = includeSRID;
        if (outputDimension < 2 || outputDimension > 4) {
            throw new IllegalArgumentException("Output dimension must be 2 to 4");
        }
        this.outputOrdinates = EnumSet.of(Ordinate.X, Ordinate.Y);
        if (outputDimension > 2) {
            this.outputOrdinates.add(Ordinate.Z);
        }
        if (outputDimension > 3) {
            this.outputOrdinates.add(Ordinate.M);
        }
    }

    public void setOutputOrdinates(EnumSet<Ordinate> outputOrdinates) {
        this.outputOrdinates.remove(Ordinate.Z);
        this.outputOrdinates.remove(Ordinate.M);
        if (this.outputDimension == 3) {
            if (outputOrdinates.contains(Ordinate.Z)) {
                this.outputOrdinates.add(Ordinate.Z);
            } else if (outputOrdinates.contains(Ordinate.M)) {
                this.outputOrdinates.add(Ordinate.M);
            }
        }
        if (this.outputDimension == 4) {
            if (outputOrdinates.contains(Ordinate.Z)) {
                this.outputOrdinates.add(Ordinate.Z);
            }
            if (outputOrdinates.contains(Ordinate.M)) {
                this.outputOrdinates.add(Ordinate.M);
            }
        }
    }

    public EnumSet<Ordinate> getOutputOrdinates() {
        return this.outputOrdinates;
    }

    public byte[] write(Geography geog) {
        try {
            this.byteArrayOS.reset();
            this.write(geog, this.byteArrayOutStream);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IO exception: " + ex.getMessage());
        }
        return this.byteArrayOS.toByteArray();
    }

    public void write(Geography geogIn, OutStream os) throws IOException {
        Geography geog = geogIn;
        if (geog instanceof SinglePointGeography) {
            this.writePoint(1, (SinglePointGeography)geog, os);
        } else if (geog instanceof PointGeography) {
            this.writeMultiPoint(4, (PointGeography)geog, os);
        } else if (geog instanceof SinglePolylineGeography) {
            this.writePolyline(2, (SinglePolylineGeography)geog, os);
        } else if (geog instanceof PolylineGeography) {
            this.writeMultiPolyline(5, (PolylineGeography)geog, os);
        } else if (geog instanceof PolygonGeography) {
            this.writePolygon(3, (PolygonGeography)geog, os);
        } else if (geog instanceof MultiPolygonGeography) {
            this.writeMultiPolygon(6, (MultiPolygonGeography)geog, os);
        } else if (geog instanceof GeographyCollection) {
            this.writeGeographyCollection(7, (GeographyCollection)geog, os);
        }
    }

    private void writePoint(int geometryType, SinglePointGeography pt, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(geometryType, pt, os);
        if (pt.numShapes() == 0) {
            this.writeNaNs(this.outputDimension, os);
        } else {
            S2Point p = pt.getPoints().get(0);
            S2LatLng ll = new S2LatLng(p);
            double lon = ll.lngDegrees();
            double lat = ll.latDegrees();
            ByteOrderValues.putDouble((double)lon, (byte[])this.buf, (int)this.byteOrder);
            os.write(this.buf, 8);
            ByteOrderValues.putDouble((double)lat, (byte[])this.buf, (int)this.byteOrder);
            os.write(this.buf, 8);
        }
    }

    private void writeMultiPoint(int geometryType, PointGeography mp, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(4, mp, os);
        this.writeInt(mp.numShapes(), os);
        boolean oldIncludeSRID = this.includeSRID;
        this.includeSRID = false;
        for (int i = 0; i < mp.numShapes(); ++i) {
            S2Point p = mp.getPoints().get(i);
            S2LatLng ll = new S2LatLng(p);
            double lon = ll.lngDegrees();
            double lat = ll.latDegrees();
            this.writeByteOrder(os);
            this.writeGeometryType(1, mp, os);
            ByteOrderValues.putDouble((double)lon, (byte[])this.buf, (int)this.byteOrder);
            os.write(this.buf, 8);
            ByteOrderValues.putDouble((double)lat, (byte[])this.buf, (int)this.byteOrder);
            os.write(this.buf, 8);
        }
        this.includeSRID = oldIncludeSRID;
    }

    private void writePolyline(int geometryType, SinglePolylineGeography polyline, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(geometryType, polyline, os);
        List<S2Polyline> s2line = polyline.getPolylines();
        for (S2Polyline s2 : s2line) {
            List verts = s2.vertices();
            this.writeInt(verts.size(), os);
            for (S2Point p : verts) {
                S2LatLng ll = new S2LatLng(p);
                double lon = ll.lngDegrees();
                double lat = ll.latDegrees();
                ByteOrderValues.putDouble((double)lon, (byte[])this.buf, (int)this.byteOrder);
                os.write(this.buf, 8);
                ByteOrderValues.putDouble((double)lat, (byte[])this.buf, (int)this.byteOrder);
                os.write(this.buf, 8);
            }
        }
    }

    private void writeMultiPolyline(int geometryType, PolylineGeography polyline, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(5, polyline, os);
        List<S2Polyline> lines = polyline.getPolylines();
        this.writeInt(lines.size(), os);
        boolean oldIncludeSRID = this.includeSRID;
        this.includeSRID = false;
        for (S2Polyline s2line : lines) {
            List verts = s2line.vertices();
            this.writeByteOrder(os);
            this.writeGeometryType(2, polyline, os);
            this.writeInt(verts.size(), os);
            for (S2Point p : verts) {
                S2LatLng ll = new S2LatLng(p);
                double lon = ll.lngDegrees();
                double lat = ll.latDegrees();
                ByteOrderValues.putDouble((double)lon, (byte[])this.buf, (int)this.byteOrder);
                os.write(this.buf, 8);
                ByteOrderValues.putDouble((double)lat, (byte[])this.buf, (int)this.byteOrder);
                os.write(this.buf, 8);
            }
        }
        this.includeSRID = oldIncludeSRID;
    }

    private void writePolygon(int geometryType, PolygonGeography poly, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(geometryType, poly, os);
        S2Polygon s2poly = poly.polygon;
        List loops = s2poly.getLoops();
        this.writeInt(loops.size(), os);
        for (S2Loop loop : loops) {
            int n = loop.numVertices();
            this.writeInt(n, os);
            for (int i = 0; i < n; ++i) {
                S2LatLng ll = new S2LatLng(loop.vertex(i));
                double lon = ll.lngDegrees();
                double lat = ll.latDegrees();
                ByteOrderValues.putDouble((double)lon, (byte[])this.buf, (int)this.byteOrder);
                os.write(this.buf, 8);
                ByteOrderValues.putDouble((double)lat, (byte[])this.buf, (int)this.byteOrder);
                os.write(this.buf, 8);
            }
        }
    }

    private void writeMultiPolygon(int geometryType, MultiPolygonGeography multiPoly, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(6, multiPoly, os);
        List<Geography> polys = multiPoly.getFeatures();
        this.writeInt(polys.size(), os);
        boolean oldIncludeSRID = this.includeSRID;
        this.includeSRID = false;
        for (Geography pg : polys) {
            this.writeByteOrder(os);
            this.writeGeometryType(3, pg, os);
            PolygonGeography s2poly = (PolygonGeography)pg;
            List loops = s2poly.polygon.getLoops();
            this.writeInt(loops.size(), os);
            for (S2Loop loop : loops) {
                int n = loop.numVertices();
                this.writeInt(n, os);
                for (int i = 0; i < n; ++i) {
                    S2LatLng ll = new S2LatLng(loop.vertex(i));
                    double lon = ll.lngDegrees();
                    double lat = ll.latDegrees();
                    ByteOrderValues.putDouble((double)lon, (byte[])this.buf, (int)this.byteOrder);
                    os.write(this.buf, 8);
                    ByteOrderValues.putDouble((double)lat, (byte[])this.buf, (int)this.byteOrder);
                    os.write(this.buf, 8);
                }
            }
        }
        this.includeSRID = oldIncludeSRID;
    }

    private void writeGeographyCollection(int geometryType, GeographyCollection gc, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(geometryType, gc, os);
        this.writeInt(gc.numShapes(), os);
        boolean originalIncludeSRID = this.includeSRID;
        this.includeSRID = false;
        for (int i = 0; i < gc.numShapes(); ++i) {
            this.write(gc.getFeatures().get(i), os);
        }
        this.includeSRID = originalIncludeSRID;
    }

    private void writeByteOrder(OutStream os) throws IOException {
        this.buf[0] = this.byteOrder == 2 ? (byte)1 : 0;
        os.write(this.buf, 1);
    }

    private void writeGeometryType(int geometryType, Geography g, OutStream os) throws IOException {
        int ordinals = 0;
        if (this.outputOrdinates.contains(Ordinate.Z)) {
            ordinals |= Integer.MIN_VALUE;
        }
        if (this.outputOrdinates.contains(Ordinate.M)) {
            ordinals |= 0x40000000;
        }
        int flag3D = this.outputDimension > 2 ? ordinals : 0;
        int typeInt = geometryType | flag3D;
        this.writeInt(typeInt |= this.includeSRID ? 0x20000000 : 0, os);
        if (this.includeSRID) {
            this.writeInt(g.getSRID(), os);
        }
    }

    private void writeInt(int intValue, OutStream os) throws IOException {
        ByteOrderValues.putInt((int)intValue, (byte[])this.buf, (int)this.byteOrder);
        os.write(this.buf, 4);
    }

    private void writeCoordinateSequence(CoordinateSequence seq, boolean writeSize, OutStream os) throws IOException {
        if (writeSize) {
            this.writeInt(seq.size(), os);
        }
        for (int i = 0; i < seq.size(); ++i) {
            this.writeCoordinate(seq, i, os);
        }
    }

    private void writeCoordinate(CoordinateSequence seq, int index, OutStream os) throws IOException {
        double ordVal;
        ByteOrderValues.putDouble((double)seq.getX(index), (byte[])this.buf, (int)this.byteOrder);
        os.write(this.buf, 8);
        ByteOrderValues.putDouble((double)seq.getY(index), (byte[])this.buf, (int)this.byteOrder);
        os.write(this.buf, 8);
        if (this.outputDimension >= 3) {
            ordVal = seq.getOrdinate(index, 2);
            ByteOrderValues.putDouble((double)ordVal, (byte[])this.buf, (int)this.byteOrder);
            os.write(this.buf, 8);
        }
        if (this.outputDimension == 4) {
            ordVal = seq.getOrdinate(index, 3);
            ByteOrderValues.putDouble((double)ordVal, (byte[])this.buf, (int)this.byteOrder);
            os.write(this.buf, 8);
        }
    }

    private void writeNaNs(int numNaNs, OutStream os) throws IOException {
        for (int i = 0; i < numNaNs; ++i) {
            ByteOrderValues.putDouble((double)Double.NaN, (byte[])this.buf, (int)this.byteOrder);
            os.write(this.buf, 8);
        }
    }
}

