/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.joinJudgement;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.sedona.common.utils.GeomUtils;
import org.apache.sedona.common.utils.HalfOpenRectangle;
import org.apache.sedona.core.joinJudgement.DedupParams;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.broadcast.Broadcast;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class DuplicatesFilter<U extends Geometry, T extends Geometry>
implements Function2<Integer, Iterator<Pair<U, T>>, Iterator<Pair<U, T>>> {
    private static final Logger log = LogManager.getLogger(DuplicatesFilter.class);
    private final Broadcast<DedupParams> dedupParamsBroadcast;

    public DuplicatesFilter(Broadcast<DedupParams> dedupParamsBroadcast) {
        this.dedupParamsBroadcast = dedupParamsBroadcast;
    }

    public Iterator<Pair<U, T>> call(Integer partitionId, Iterator<Pair<U, T>> geometryPair) throws Exception {
        List<Envelope> partitionExtents = ((DedupParams)this.dedupParamsBroadcast.getValue()).getPartitionExtents();
        if (partitionId < partitionExtents.size()) {
            HalfOpenRectangle extent = new HalfOpenRectangle(partitionExtents.get(partitionId));
            return new FilterIterator(geometryPair, p -> !GeomUtils.isDuplicate((Geometry)((Geometry)((Pair)p).getLeft()), (Geometry)((Geometry)((Pair)p).getRight()), (HalfOpenRectangle)extent));
        }
        log.warn((Object)("Didn't find partition extent for this partition: " + partitionId));
        return geometryPair;
    }
}

