/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.osmpbf.iterators;

import java.io.IOException;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import org.apache.sedona.sql.datasources.osmpbf.TruncatedStream;
import org.apache.sedona.sql.datasources.osmpbf.iterators.BlobData;
import org.apache.sedona.sql.datasources.osmpbf.iterators.BlobIterator;
import org.apache.sedona.sql.datasources.osmpbf.iterators.PrimitiveGroupIterator;
import org.apache.sedona.sql.datasources.osmpbf.model.OSMEntity;

public class PbfIterator
implements Iterator<OSMEntity> {
    PrimitiveGroupIterator pmGroupIterator;
    BlobIterator osmEntitiesIterator;

    public PbfIterator(TruncatedStream pbfInputStream) throws DataFormatException, IOException {
        this.pmGroupIterator = new PrimitiveGroupIterator(pbfInputStream);
        this.osmEntitiesIterator = this.readNextBlock();
    }

    @Override
    public boolean hasNext() {
        return this.osmEntitiesIterator != null && (this.osmEntitiesIterator.hasNext() || this.pmGroupIterator.hasNext());
    }

    @Override
    public OSMEntity next() {
        OSMEntity nextEntity = this.osmEntitiesIterator.next();
        if (!this.osmEntitiesIterator.hasNext()) {
            try {
                this.osmEntitiesIterator = this.readNextBlock();
            }
            catch (IOException | DataFormatException e) {
                throw new RuntimeException(e);
            }
        }
        return nextEntity;
    }

    private BlobIterator readNextBlock() throws DataFormatException, IOException {
        BlobData next;
        if (this.pmGroupIterator.hasNext() && (next = this.pmGroupIterator.next()).getHeader().getType().equals("OSMData")) {
            return new BlobIterator(next.getBlob());
        }
        return null;
    }
}

