/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.UnsafeInput;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import com.google.common.geometry.PrimitiveArrays;
import com.google.common.geometry.S2Region;
import com.google.common.geometry.S2Shape;
import com.google.common.geometry.S2ShapeIndex;
import com.google.common.geometry.S2ShapeIndexRegion;
import com.google.common.geometry.VectorCoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.sedona.common.S2Geography.EncodeOptions;
import org.apache.sedona.common.S2Geography.EncodeTag;
import org.apache.sedona.common.S2Geography.Geography;

public class EncodedShapeIndexGeography
extends Geography {
    private static final Logger logger = Logger.getLogger(EncodedShapeIndexGeography.class.getName());
    public S2ShapeIndex shapeIndex = new S2ShapeIndex();

    public EncodedShapeIndexGeography() {
        super(Geography.GeographyKind.ENCODED_SHAPE_INDEX);
    }

    @Override
    public int dimension() {
        return -1;
    }

    @Override
    public int numShapes() {
        return this.shapeIndex.getShapes().size();
    }

    @Override
    public S2Shape shape(int id) {
        return (S2Shape)this.shapeIndex.getShapes().get(id);
    }

    @Override
    public S2Region region() {
        return new S2ShapeIndexRegion(this.shapeIndex);
    }

    public int addIndex(Geography geog) {
        int lastId = -1;
        int n = geog.numShapes();
        for (int i = 0; i < n; ++i) {
            this.shapeIndex.add(geog.shape(i));
            lastId = this.shapeIndex.getShapes().size() - 1;
        }
        return lastId;
    }

    public int addIndex(S2Shape shape) {
        this.shapeIndex.add(shape);
        return this.shapeIndex.getShapes().size() - 1;
    }

    @Override
    public void encode(UnsafeOutput os, EncodeOptions opts) throws IOException {
        throw new IOException("Encode() not implemented for EncodedShapeIndexGeography()");
    }

    public static EncodedShapeIndexGeography decode(Input in, EncodeTag tag) throws IOException {
        if (!(in instanceof UnsafeInput)) {
            throw new IllegalArgumentException("Expected UnsafeInput");
        }
        return EncodedShapeIndexGeography.decode((UnsafeInput)in, tag);
    }

    public static EncodedShapeIndexGeography decode(UnsafeInput in, EncodeTag tag) throws IOException {
        EncodedShapeIndexGeography encodedShapeIndexGeography = new EncodedShapeIndexGeography();
        if ((tag.getFlags() & 1) != 0) {
            logger.fine("Decoded empty EncodedShapeIndexGeography.");
            return encodedShapeIndexGeography;
        }
        tag.skipCovering(in);
        int length = in.readInt();
        if (length < 0) {
            throw new IOException("Invalid payload length: " + length);
        }
        final byte[] payload = new byte[length];
        in.readBytes(payload, 0, length);
        PrimitiveArrays.Bytes bytes = new PrimitiveArrays.Bytes(){

            public long length() {
                return payload.length;
            }

            public byte get(long i) {
                return payload[(int)i];
            }
        };
        List s2Shapes = new ArrayList();
        s2Shapes = tag.isCompact() ? (List)VectorCoder.COMPACT_SHAPE.decode(bytes) : (List)VectorCoder.FAST_SHAPE.decode(bytes);
        for (S2Shape shape : s2Shapes) {
            encodedShapeIndexGeography.addIndex(shape);
        }
        return encodedShapeIndexGeography;
    }
}

