/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStatusAccessItem
implements AccessLogItem<RoutingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpStatusAccessItem.class);
    public static final String EMPTY_RESULT = "-";

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        HttpServerResponse response = accessLogEvent.getRoutingContext().response();
        if (null == response) {
            builder.append(EMPTY_RESULT);
            return;
        }
        if (response.closed() && !response.ended()) {
            LOGGER.warn("Response is closed before sending any data. Please check idle connection timeout for provider is properly configured.");
            builder.append(EMPTY_RESULT);
            return;
        }
        builder.append(response.getStatusCode());
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent finishEvent, StringBuilder builder) {
        Response response = finishEvent.getResponse();
        if (null == response) {
            builder.append(EMPTY_RESULT);
            return;
        }
        builder.append(response.getStatusCode());
    }
}

