/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.produce;

import com.fasterxml.jackson.databind.JavaType;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;

public class ProduceJsonProcessor
implements ProduceProcessor {
    private Class<?> serializationView;

    @Override
    public String getSerializationView() {
        return this.serializationView == null ? ProduceProcessor.super.getSerializationView() : this.serializationView.getName();
    }

    @Override
    public void setSerializationView(Class<?> serializationView) {
        if (serializationView == null) {
            return;
        }
        this.serializationView = serializationView;
    }

    @Override
    public String getName() {
        return "application/json";
    }

    @Override
    public void doEncodeResponse(OutputStream output, Object result) throws Exception {
        if (this.serializationView == null) {
            RestObjectMapperFactory.getRestObjectMapper().writeValue(output, result);
            return;
        }
        RestObjectMapperFactory.getRestObjectMapper().writerWithView(this.serializationView).writeValue(output, result);
    }

    @Override
    public Object doDecodeResponse(InputStream input, JavaType type) throws Exception {
        if (this.serializationView == null) {
            return RestObjectMapperFactory.getRestObjectMapper().readValue(input, type);
        }
        return RestObjectMapperFactory.getRestObjectMapper().readerWithView(this.serializationView).forType(type).readValue(input);
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

