/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.model;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;

public class SwaggerOperation {
    private final OpenAPI swagger;
    private final String path;
    private final PathItem.HttpMethod httpMethod;
    private final Operation operation;

    public SwaggerOperation(OpenAPI swagger, String path, PathItem.HttpMethod httpMethod, Operation operation) {
        this.swagger = swagger;
        this.path = path;
        this.httpMethod = httpMethod;
        this.operation = operation;
    }

    public int parameterCount() {
        int result = 0;
        if (this.operation.getRequestBody() != null) {
            ++result;
        }
        if (this.operation.getParameters() != null) {
            result += this.operation.getParameters().size();
        }
        return result;
    }

    public OpenAPI getSwagger() {
        return this.swagger;
    }

    public String getPath() {
        return this.path;
    }

    public PathItem.HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getOperationId() {
        return this.operation.getOperationId();
    }
}

