/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.sql.parser.statement.core.segment.dml.outfile;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.SQLSegment;

import java.util.Map;
import java.util.Optional;

/**
 * Outfile segment.
 */
@RequiredArgsConstructor
@Getter
public final class OutfileSegment implements SQLSegment {
    
    private final int startIndex;
    
    private final int stopIndex;
    
    private final String filePath;
    
    private final String format;
    
    private final Map<String, String> properties;
    
    private final String characterSet;
    
    private final OutfileColumnsSegment columns;
    
    private final OutfileLinesSegment lines;
    
    /**
     * Get character set.
     *
     * @return character set
     */
    public Optional<String> getCharacterSet() {
        return Optional.ofNullable(characterSet);
    }
    
    /**
     * Get columns.
     *
     * @return columns
     */
    public Optional<OutfileColumnsSegment> getColumns() {
        return Optional.ofNullable(columns);
    }
    
    /**
     * Get lines.
     *
     * @return lines
     */
    public Optional<OutfileLinesSegment> getLines() {
        return Optional.ofNullable(lines);
    }
    
    /**
     * Get format.
     *
     * @return format
     */
    public Optional<String> getFormat() {
        return Optional.ofNullable(format);
    }
    
    /**
     * Get properties.
     *
     * @return properties
     */
    public Optional<Map<String, String>> getProperties() {
        return Optional.ofNullable(properties);
    }
}
