/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.web.webflux;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpCookie;
import org.springframework.util.MultiValueMap;
import org.thymeleaf.spring6.web.webflux.MultiValueMapUtil;
import org.thymeleaf.util.Validate;
import org.thymeleaf.web.IWebRequest;

public interface ISpringWebFluxWebRequest
extends IWebRequest {
    public URI getURI();

    default public String getScheme() {
        URI uri = this.getURI();
        return uri == null ? null : uri.getScheme();
    }

    default public String getServerName() {
        URI uri = this.getURI();
        return uri == null ? null : uri.getHost();
    }

    default public Integer getServerPort() {
        URI uri = this.getURI();
        return uri == null ? null : Integer.valueOf(uri.getPort());
    }

    default public String getQueryString() {
        URI uri = this.getURI();
        return uri == null ? null : uri.getRawQuery();
    }

    public MultiValueMap<String, String> getHeaderMultiValueMap();

    default public boolean containsHeader(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        MultiValueMap<String, String> headerMultiValueMap = this.getHeaderMultiValueMap();
        return headerMultiValueMap != null && headerMultiValueMap.containsKey((Object)name);
    }

    default public int getHeaderCount() {
        MultiValueMap<String, String> headerMultiValueMap = this.getHeaderMultiValueMap();
        return headerMultiValueMap == null ? 0 : headerMultiValueMap.size();
    }

    default public Set<String> getAllHeaderNames() {
        MultiValueMap<String, String> headerMultiValueMap = this.getHeaderMultiValueMap();
        return headerMultiValueMap == null ? Collections.emptySet() : headerMultiValueMap.keySet();
    }

    default public Map<String, String[]> getHeaderMap() {
        MultiValueMap<String, String> headerMultiValueMap = this.getHeaderMultiValueMap();
        if (headerMultiValueMap == null) {
            return Collections.emptyMap();
        }
        return MultiValueMapUtil.stringToStringArrayMultiMap(headerMultiValueMap);
    }

    default public String getHeaderValue(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        MultiValueMap<String, String> headerMultiValueMap = this.getHeaderMultiValueMap();
        return headerMultiValueMap == null ? null : (String)headerMultiValueMap.getFirst((Object)name);
    }

    default public String[] getHeaderValues(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        MultiValueMap<String, String> headerMultiValueMap = this.getHeaderMultiValueMap();
        if (headerMultiValueMap == null) {
            return MultiValueMapUtil.EMPTY_VALUES;
        }
        List headerValueList = (List)headerMultiValueMap.get((Object)name);
        if (headerValueList == null) {
            return MultiValueMapUtil.EMPTY_VALUES;
        }
        return headerValueList.toArray(new String[headerValueList.size()]);
    }

    public MultiValueMap<String, String> getParameterMultiValueMap();

    default public boolean containsParameter(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        MultiValueMap<String, String> parameterMultiValueMap = this.getParameterMultiValueMap();
        return parameterMultiValueMap != null && parameterMultiValueMap.containsKey((Object)name);
    }

    default public int getParameterCount() {
        MultiValueMap<String, String> parameterMultiValueMap = this.getParameterMultiValueMap();
        return parameterMultiValueMap == null ? 0 : parameterMultiValueMap.size();
    }

    default public Set<String> getAllParameterNames() {
        MultiValueMap<String, String> parameterMultiValueMap = this.getParameterMultiValueMap();
        return parameterMultiValueMap == null ? null : parameterMultiValueMap.keySet();
    }

    default public Map<String, String[]> getParameterMap() {
        MultiValueMap<String, String> parameterMultiValueMap = this.getParameterMultiValueMap();
        if (parameterMultiValueMap == null) {
            return Collections.emptyMap();
        }
        return MultiValueMapUtil.stringToStringArrayMultiMap(parameterMultiValueMap);
    }

    default public String getParameterValue(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        MultiValueMap<String, String> parameterMultiValueMap = this.getParameterMultiValueMap();
        return parameterMultiValueMap == null ? null : (String)parameterMultiValueMap.getFirst((Object)name);
    }

    default public String[] getParameterValues(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        MultiValueMap<String, String> parameterMultiValueMap = this.getParameterMultiValueMap();
        if (parameterMultiValueMap == null) {
            return MultiValueMapUtil.EMPTY_VALUES;
        }
        List parameterValueList = (List)parameterMultiValueMap.get((Object)name);
        if (parameterValueList == null) {
            return MultiValueMapUtil.EMPTY_VALUES;
        }
        return parameterValueList.toArray(new String[parameterValueList.size()]);
    }

    public MultiValueMap<String, HttpCookie> getCookieMultiValueMap();

    default public boolean containsCookie(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        MultiValueMap<String, HttpCookie> cookieMultiValueMap = this.getCookieMultiValueMap();
        return cookieMultiValueMap != null && cookieMultiValueMap.containsKey((Object)name);
    }

    default public int getCookieCount() {
        MultiValueMap<String, HttpCookie> cookieMultiValueMap = this.getCookieMultiValueMap();
        return cookieMultiValueMap == null ? 0 : cookieMultiValueMap.size();
    }

    default public Set<String> getAllCookieNames() {
        MultiValueMap<String, HttpCookie> cookieMultiValueMap = this.getCookieMultiValueMap();
        return cookieMultiValueMap == null ? Collections.emptySet() : cookieMultiValueMap.keySet();
    }

    default public Map<String, String[]> getCookieMap() {
        MultiValueMap<String, HttpCookie> cookieMultiValueMap = this.getCookieMultiValueMap();
        if (cookieMultiValueMap == null) {
            return Collections.emptyMap();
        }
        return MultiValueMapUtil.cookieToStringArrayMultiMap(cookieMultiValueMap);
    }

    default public String getCookieValue(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        MultiValueMap<String, HttpCookie> cookieMultiValueMap = this.getCookieMultiValueMap();
        if (cookieMultiValueMap == null) {
            return null;
        }
        HttpCookie cookie = (HttpCookie)cookieMultiValueMap.getFirst((Object)name);
        return cookie == null ? null : cookie.getValue();
    }

    default public String[] getCookieValues(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        MultiValueMap<String, HttpCookie> cookieMultiValueMap = this.getCookieMultiValueMap();
        if (cookieMultiValueMap == null) {
            return MultiValueMapUtil.EMPTY_VALUES;
        }
        List cookieList = (List)cookieMultiValueMap.get((Object)name);
        if (cookieList == null) {
            return MultiValueMapUtil.EMPTY_VALUES;
        }
        return (String[])cookieList.stream().map(HttpCookie::getValue).toArray(String[]::new);
    }

    public Object getNativeRequestObject();
}

