/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.configuration;

import com.tencent.polaris.api.config.configuration.ConfigFileConfig;
import com.tencent.polaris.api.config.configuration.ConfigFilterConfig;
import com.tencent.polaris.factory.config.configuration.ConfigFilterConfigImpl;
import com.tencent.polaris.factory.config.configuration.ConnectorConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;
import shade.polaris.com.fasterxml.jackson.annotation.JsonProperty;

public class ConfigFileConfigImpl
implements ConfigFileConfig {
    @JsonProperty
    private ConnectorConfigImpl serverConnector;
    @JsonProperty
    private ConfigFilterConfigImpl configFilter;
    @JsonProperty
    private int propertiesValueCacheSize;
    @JsonProperty
    private long propertiesValueExpireTime;

    @Override
    public void verify() {
        ConfigUtils.validateNull(this.serverConnector, "config server connector");
        this.serverConnector.verify();
        this.configFilter.verify();
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (defaultObject != null) {
            ConfigFileConfig sourceConfig = (ConfigFileConfig)defaultObject;
            if (this.serverConnector == null) {
                this.serverConnector = new ConnectorConfigImpl();
            }
            if (this.configFilter == null) {
                this.configFilter = new ConfigFilterConfigImpl();
            }
            this.serverConnector.setDefault(sourceConfig.getServerConnector());
            this.configFilter.setDefault(sourceConfig.getConfigFilterConfig());
            this.propertiesValueCacheSize = sourceConfig.getPropertiesValueCacheSize();
            this.propertiesValueExpireTime = sourceConfig.getPropertiesValueExpireTime();
        }
    }

    @Override
    public ConnectorConfigImpl getServerConnector() {
        return this.serverConnector;
    }

    @Override
    public ConfigFilterConfig getConfigFilterConfig() {
        return this.configFilter;
    }

    @Override
    public int getPropertiesValueCacheSize() {
        return this.propertiesValueCacheSize;
    }

    @Override
    public long getPropertiesValueExpireTime() {
        return this.propertiesValueExpireTime;
    }

    public void setServerConnector(ConnectorConfigImpl serverConnector) {
        this.serverConnector = serverConnector;
    }

    public void setPropertiesValueCacheSize(int propertiesValueCacheSize) {
        this.propertiesValueCacheSize = propertiesValueCacheSize;
    }

    public void setPropertiesValueExpireTime(long propertiesValueExpireTime) {
        this.propertiesValueExpireTime = propertiesValueExpireTime;
    }
}

