/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eventbus.impl;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.eventbus.impl.EventBatch;
import com.netflix.eventbus.impl.EventBusImpl;
import com.netflix.eventbus.spi.Subscribe;
import com.netflix.eventbus.spi.SubscriberConfigProvider;
import com.netflix.eventbus.utils.EventBusUtils;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AgeBatchingQueue
implements EventBusImpl.ConsumerQueueSupplier.ConsumerQueue {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AgeBatchingQueue.class);
    protected AtomicReference<AgeBatch> currentBatch;
    protected LinkedBlockingQueue<AgeBatch> oldBatches;
    protected AtomicBoolean oldBatchesQueueFull;
    protected ReentrantLock batchReapingLock;
    protected static Timer batchAgeChecker = new Timer("eventbus-consumer-current-batch-reaper", true);
    protected final String subscriberName;
    protected TimerTask reaper;
    protected Subscribe.BatchingStrategy batchingStrategy;
    protected AtomicLong queueSizeCounter;

    AgeBatchingQueue(Method subscriber, SubscriberConfigProvider.SubscriberConfig subscribe, AtomicLong queueSizeCounter) {
        this(subscriber, subscribe, true, queueSizeCounter);
    }

    @VisibleForTesting
    AgeBatchingQueue(Method subscriber, SubscriberConfigProvider.SubscriberConfig subscribe, boolean scheduleReaper, AtomicLong queueSizeCounter) {
        this.queueSizeCounter = queueSizeCounter;
        this.subscriberName = subscriber.toGenericString();
        this.batchingStrategy = subscribe.getBatchingStrategy();
        this.oldBatches = new LinkedBlockingQueue(EventBusUtils.getQueueSize(subscribe));
        this.currentBatch = new AtomicReference<AgeBatch>(this.createNewBatch(subscribe));
        this.oldBatchesQueueFull = new AtomicBoolean();
        this.batchReapingLock = new ReentrantLock();
        int batchAge = subscribe.getBatchAge();
        this.reaper = new ReaperTask();
        if (scheduleReaper) {
            batchAgeChecker.schedule(this.reaper, batchAge, (long)batchAge);
        }
    }

    @Override
    public boolean offer(Object event) {
        if (this.oldBatchesQueueFull.get() && !this.reapCurrentBatch("Offering Thread")) {
            return false;
        }
        return this.currentBatch.get().addEvent(event);
    }

    @Override
    public Object nonBlockingTake() {
        AgeBatch batch = this.oldBatches.poll();
        if (null != batch) {
            this.queueSizeCounter.decrementAndGet();
        }
        return batch;
    }

    @Override
    public Object blockingTake() throws InterruptedException {
        AgeBatch batch = this.oldBatches.take();
        this.queueSizeCounter.decrementAndGet();
        return batch;
    }

    @Override
    public void clear() {
        this.oldBatches.clear();
        this.currentBatch.get().clear();
        this.queueSizeCounter.set(0L);
    }

    @VisibleForTesting
    AgeBatch getCurrentBatch() {
        return this.currentBatch.get();
    }

    @VisibleForTesting
    AgeBatch blockingTakeWithTimeout(long timeoutInMillis) throws InterruptedException {
        return this.oldBatches.poll(timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    boolean invokeReaping() {
        return this.reapCurrentBatch("Test driven explicit reaping");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean reapCurrentBatch(String operatorName) {
        AgeBatch currentBatchRef = this.currentBatch.get();
        if (currentBatchRef.events.isEmpty()) {
            return true;
        }
        if (this.batchReapingLock.tryLock()) {
            try {
                if (this.oldBatches.offer(currentBatchRef)) {
                    this.currentBatch.getAndSet(this.createNewBatch(null));
                    this.queueSizeCounter.incrementAndGet();
                    LOGGER.debug(String.format("[Reaping source: %s , Batching strategy: %s ] Reaped the old batch with size %s for subscriber: %s", new Object[]{operatorName, this.batchingStrategy, currentBatchRef.events.size(), this.subscriberName}));
                    this.oldBatchesQueueFull.set(false);
                    boolean bl = true;
                    return bl;
                }
                this.oldBatchesQueueFull.set(true);
                LOGGER.info(String.format("[Reaping source: %s , Batching strategy: %s ] Old batches queue for subscriber %s is full. Not reaping the batch till we get space.", new Object[]{operatorName, this.batchingStrategy, this.subscriberName}));
            }
            finally {
                this.batchReapingLock.unlock();
            }
        } else {
            LOGGER.debug(String.format("[Reaping source: %s , Batching strategy: %s ] Subscriber: %s did not reap as there is another thread already reaping.", new Object[]{operatorName, this.batchingStrategy, this.subscriberName}));
        }
        return false;
    }

    protected AgeBatch createNewBatch(@Nullable SubscriberConfigProvider.SubscriberConfig subscribe) {
        return new AgeBatch();
    }

    private class ReaperTask
    extends TimerTask {
        private ReaperTask() {
        }

        @Override
        public void run() {
            try {
                AgeBatchingQueue.this.reapCurrentBatch("Reaper");
            }
            catch (Throwable th) {
                LOGGER.error(String.format("Reaper thread for subscriber: %s threw an error while reaping. Eating exception.", AgeBatchingQueue.this.subscriberName), th);
            }
        }
    }

    protected class AgeBatch
    implements EventBatch {
        @VisibleForTesting
        ConcurrentLinkedQueue events = new ConcurrentLinkedQueue();

        protected AgeBatch() {
        }

        protected boolean addEvent(Object event) {
            return this.events.add(event);
        }

        public Iterator iterator() {
            return this.events.iterator();
        }

        protected void clear() {
            this.events.clear();
        }
    }
}

