/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.selector;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;

public class SelectorChangedEvent
extends AdminDataModelChangedEvent {
    public SelectorChangedEvent(SelectorDO source, SelectorDO before, EventTypeEnum type, String operator) {
        super(source, before, type, operator);
    }

    @Override
    public String buildContext() {
        SelectorDO after = (SelectorDO)this.getAfter();
        if (Objects.isNull(this.getBefore())) {
            return String.format("the namespace [%s] selector [%s] is %s", after.getNamespaceId(), after.getSelectorName(), StringUtils.lowerCase((String)this.getType().getType().toString()));
        }
        return String.format("the namespace [%s] selector [%s] is %s : %s", after.getNamespaceId(), after.getSelectorName(), StringUtils.lowerCase((String)this.getType().getType().toString()), this.contrast());
    }

    private String contrast() {
        SelectorDO before = (SelectorDO)this.getBefore();
        Objects.requireNonNull(before);
        SelectorDO after = (SelectorDO)this.getAfter();
        Objects.requireNonNull(after);
        if (Objects.equals(before, after)) {
            return "it no change";
        }
        StringBuilder builder = new StringBuilder();
        if (!Objects.equals(before.getSelectorName(), after.getSelectorName())) {
            builder.append(String.format("name[%s => %s] ", before.getSelectorName(), after.getSelectorName()));
        }
        if (!Objects.equals(before.getHandle(), after.getHandle())) {
            builder.append(String.format("handle[%s => %s] ", before.getHandle(), after.getHandle()));
        }
        if (!Objects.equals(before.getSelectorType(), after.getSelectorType())) {
            builder.append(String.format("type[%s => %s] ", before.getSelectorType(), after.getSelectorType()));
        }
        if (!Objects.equals(before.getEnabled(), after.getEnabled())) {
            builder.append(String.format("enable[%s => %s] ", before.getEnabled(), after.getEnabled()));
        }
        if (!Objects.equals(before.getSortCode(), after.getSortCode())) {
            builder.append(String.format("sort[%s => %s] ", before.getSortCode(), after.getSortCode()));
        }
        if (!Objects.equals(before.getLoged(), after.getLoged())) {
            builder.append(String.format("loged[%s => %s] ", before.getLoged(), after.getLoged()));
        }
        if (!Objects.equals(before.getNamespaceId(), after.getNamespaceId())) {
            builder.append(String.format("namespaceId[%s => %s] ", before.getNamespaceId(), after.getNamespaceId()));
        }
        return builder.toString();
    }

    @Override
    public String eventName() {
        return "selector";
    }
}

