/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;

public final class UrlSecurityUtils {
    private UrlSecurityUtils() {
    }

    public static void validateUrlForSSRF(String url) {
        if (Objects.isNull(url) || url.trim().isEmpty()) {
            throw new IllegalArgumentException("URL cannot be empty");
        }
        try {
            URL parsedUrl = new URL(url);
            String protocol = parsedUrl.getProtocol();
            if (!"http".equals(protocol) && !"https".equals(protocol)) {
                throw new IllegalArgumentException("Only HTTP and HTTPS protocols are allowed");
            }
            UrlSecurityUtils.validateHostForSSRF(parsedUrl.getHost(), parsedUrl.getPort());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL format: " + e.getMessage());
        }
    }

    public static void validateHostForSSRF(String host, int port) {
        if (Objects.isNull(host) || host.trim().isEmpty()) {
            throw new IllegalArgumentException("Host cannot be empty");
        }
        String normalizedHost = host.toLowerCase().trim();
        if (UrlSecurityUtils.isLocalhost(normalizedHost)) {
            throw new IllegalArgumentException("Access to localhost is not allowed");
        }
        if (UrlSecurityUtils.isPrivateOrInternalIP(normalizedHost)) {
            throw new IllegalArgumentException("Access to private or internal IP addresses is not allowed");
        }
        if (UrlSecurityUtils.isSensitivePort(port)) {
            throw new IllegalArgumentException("Access to sensitive ports is not allowed");
        }
        try {
            InetAddress[] addresses;
            for (InetAddress address : addresses = InetAddress.getAllByName(normalizedHost)) {
                if (address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress() || address.isAnyLocalAddress()) {
                    throw new IllegalArgumentException("Resolved IP address is not allowed: " + address.getHostAddress());
                }
                if (!UrlSecurityUtils.isPrivateIPAddress(address.getHostAddress())) continue;
                throw new IllegalArgumentException("Resolved IP address is private: " + address.getHostAddress());
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Cannot resolve host: " + host);
        }
    }

    private static boolean isLocalhost(String host) {
        HashSet<String> localhostVariations = new HashSet<String>(Arrays.asList("localhost", "127.0.0.1", "::1", "0.0.0.0", "0000:0000:0000:0000:0000:0000:0000:0001"));
        return localhostVariations.contains(host);
    }

    private static boolean isPrivateOrInternalIP(String host) {
        if (host.matches("^10\\..*") || host.matches("^172\\.(1[6-9]|2[0-9]|3[0-1])\\..*") || host.matches("^192\\.168\\..*")) {
            return true;
        }
        if (host.startsWith("fc") || host.startsWith("fd") || host.startsWith("fe80") || "::1".equals(host)) {
            return true;
        }
        return host.matches("^169\\.254\\..*") || host.matches("^224\\..*") || host.matches("^255\\..*");
    }

    private static boolean isPrivateIPAddress(String ip) {
        try {
            InetAddress address = InetAddress.getByName(ip);
            return address.isSiteLocalAddress() || address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isAnyLocalAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private static boolean isSensitivePort(int port) {
        if (port == -1) {
            return false;
        }
        HashSet<Integer> sensitivePorts = new HashSet<Integer>(Arrays.asList(22, 23, 3389, 25, 53, 135, 139, 445, 5432, 3306, 1433, 6379, 11211, 5984, 9200, 2181, 9092, 9093, 8080, 8081, 9090, 9091, 2375, 2376, 25672, 5672, 15672, 4369));
        return sensitivePorts.contains(port);
    }
}

