/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Map;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.springframework.integration.dsl.EndpointSpec;
import org.springframework.integration.dsl.StandardIntegrationFlow;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.messaging.Message;
import reactor.core.publisher.Flux;

class PublisherIntegrationFlow<T>
extends StandardIntegrationFlow
implements Publisher<Message<T>> {
    private final Publisher<Message<T>> delegate;

    PublisherIntegrationFlow(Map<Object, String> integrationComponents, Publisher<Message<T>> publisher, boolean autoStartOnSubscribe) {
        super(integrationComponents);
        Flux flux = Flux.from(publisher).doOnCancel(this::stop).doOnTerminate(this::stop);
        if (autoStartOnSubscribe) {
            flux = flux.doOnSubscribe(sub -> this.start());
            for (Object component : integrationComponents.keySet()) {
                if (component instanceof EndpointSpec) {
                    EndpointSpec endpointSpec = (EndpointSpec)component;
                    endpointSpec.autoStartup(false);
                    continue;
                }
                if (!(component instanceof AbstractEndpoint)) continue;
                AbstractEndpoint endpoint = (AbstractEndpoint)component;
                endpoint.setAutoStartup(false);
            }
        }
        this.delegate = flux;
    }

    public void subscribe(Subscriber<? super Message<T>> subscriber) {
        this.delegate.subscribe(subscriber);
    }
}

