/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.labels;

import io.kubernetes.client.util.labels.LabelMatcher;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SetMatcher
implements LabelMatcher {
    private Operator operator;
    private String key;
    private String[] values;

    SetMatcher(String key, Operator operator) {
        this(key, operator, new String[0]);
    }

    SetMatcher(String key, Operator operator, String[] values) {
        this.key = key;
        this.operator = operator;
        this.values = values;
    }

    public static SetMatcher in(String key, String ... values) {
        return new SetMatcher(key, Operator.IN, values);
    }

    public static SetMatcher notIn(String key, String ... values) {
        return new SetMatcher(key, Operator.NOT_IN, values);
    }

    public static SetMatcher exists(String key) {
        return new SetMatcher(key, Operator.EXISTS);
    }

    public static SetMatcher notExists(String key) {
        return new SetMatcher(key, Operator.NOT_EXISTS);
    }

    public String toString() {
        switch (this.operator) {
            case IN: 
            case NOT_IN: {
                return this.key + " " + this.operator.name + " " + "(" + Arrays.stream(this.values).collect(Collectors.joining(",")) + ")";
            }
            case EXISTS: 
            case NOT_EXISTS: {
                return this.operator.name + this.key;
            }
        }
        throw new IllegalStateException("unknown operator " + this.operator.name);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean test(String s) {
        return this.operator.with(this.values).test(s);
    }

    private static enum Operator {
        IN("in", args -> v -> Operator.contains(args, v)),
        NOT_IN("notin", args -> v -> !Operator.contains(args, v)),
        EXISTS("", args -> v -> v != null),
        NOT_EXISTS("!", args -> v -> v == null);

        private final String name;
        private final Function<String[], Predicate<String>> matcherFunc;

        private Operator(String name, Function<String[], Predicate<String>> matcherFunc) {
            this.name = name;
            this.matcherFunc = matcherFunc;
        }

        public String getName() {
            return this.name;
        }

        Predicate<String> with(String ... values) {
            return this.matcherFunc.apply(values);
        }

        private static boolean contains(String[] strs, String s) {
            return Arrays.stream(strs).anyMatch(arg -> arg.equals(s));
        }
    }
}

