/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.sql.DataAccess;
import org.apache.sis.storage.sql.ResourceDefinition;
import org.apache.sis.storage.sql.SQLStore;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

public class SimpleFeatureStore
extends SQLStore {
    public SimpleFeatureStore(DataStoreProvider provider, StorageConnector connector, ResourceDefinition ... resources) throws DataStoreException {
        super(provider, connector);
        ArgumentChecks.ensureNonEmpty((String)"resources", (Object[])resources);
        this.setModelSources(resources);
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        Optional<ParameterValueGroup> opg = super.getOpenParameters();
        opg.ifPresent(pg -> {
            ResourceDefinition[] queries;
            GenericName[] tableNames = this.tableNames();
            if (tableNames.length != 0) {
                pg.parameter("tables").setValue((Object)tableNames);
            }
            if ((queries = this.queries()).length != 0) {
                LinkedHashMap<GenericName, String> m = new LinkedHashMap<GenericName, String>();
                for (ResourceDefinition query : queries) {
                    m.put(query.getName(), query.query);
                }
                pg.parameter("queries").setValue(m);
            }
        });
        return opg;
    }

    public Collection<FeatureSet> components() throws DataStoreException {
        return this.model().tables();
    }

    public FeatureSet findResource(String identifier) throws DataStoreException {
        return this.model().findTable(this, identifier);
    }

    @Override
    protected ResourceDefinition[] readResourceDefinitions(DataAccess dao) {
        GenericName[] tableNames = this.tableNames();
        ResourceDefinition[] queries = this.queries();
        ResourceDefinition[] definitions = new ResourceDefinition[tableNames.length + queries.length];
        for (int i = 0; i < tableNames.length; ++i) {
            definitions[i] = new ResourceDefinition(tableNames[i], null);
        }
        System.arraycopy(queries, 0, definitions, tableNames.length, queries.length);
        return definitions;
    }

    @Override
    public synchronized void refresh() {
        this.clearModel();
    }
}

