/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.provider.Wraparound;
import org.apache.sis.referencing.operation.transform.WraparoundTransform;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Numerics;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

final class WraparoundInEnvelope
extends WraparoundTransform {
    private static final long serialVersionUID = 4017870982753327584L;
    private double limit;
    private double minCycles;
    private double maxCycles;
    private boolean minChanged;
    private boolean maxChanged;

    private WraparoundInEnvelope(WraparoundTransform other) {
        super(other);
        this.maxCycles = this.limit = Math.rint(this.sourceMedian / this.period);
        this.minCycles = this.limit;
    }

    @Override
    protected final double shift(double x) {
        double n = Math.rint(x / this.period);
        if (x < this.sourceMedian) {
            if (n < this.limit) {
                if (n < this.minCycles) {
                    this.minCycles = n;
                    this.minChanged = true;
                }
                n = this.limit;
            }
        } else if (n > this.limit) {
            if (n > this.maxCycles) {
                this.maxCycles = n;
                this.maxChanged = true;
            }
            n = this.limit;
        }
        return x - n * this.period;
    }

    private boolean translate() {
        if (this.minChanged) {
            this.minChanged = false;
            this.limit = this.minCycles;
            return true;
        }
        if (this.maxChanged) {
            this.maxChanged = false;
            this.limit = this.maxCycles;
            return true;
        }
        return false;
    }

    private static final class State
    extends Parameters {
        private static volatile ParameterDescriptorGroup parameters;
        private final int wraparoundDimension;
        private final double period;
        private final double limit;
        private final State previous;

        State(WraparoundInEnvelope tr, State previous) {
            this.wraparoundDimension = tr.wraparoundDimension;
            this.period = tr.period;
            this.limit = tr.limit;
            this.previous = previous;
        }

        public int hashCode() {
            int hash = this.wraparoundDimension;
            State s1 = this;
            do {
                hash = 37 * hash + (31 * Double.hashCode(s1.limit) + Double.hashCode(s1.period));
            } while ((s1 = s1.previous) != null);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof State) {
                State s1 = this;
                State s2 = (State)obj;
                while (Numerics.equals((double)s1.limit, (double)s2.limit) && Numerics.equals((double)s1.period, (double)s2.period) && s1.wraparoundDimension == s2.wraparoundDimension) {
                    s1 = s1.previous;
                    s2 = s2.previous;
                    if (s1 == s2) {
                        return true;
                    }
                    if (s1 != null && s2 != null) continue;
                    break;
                }
            }
            return false;
        }

        public ParameterDescriptorGroup getDescriptor() {
            ParameterDescriptorGroup p = parameters;
            if (p == null) {
                ParameterBuilder builder = (ParameterBuilder)new ParameterBuilder().setCodeSpace(Citations.SIS, "SIS");
                ParameterDescriptor<Double> shift = ((ParameterBuilder)builder.addName("shift")).create(Double.NaN, null);
                parameters = p = ((ParameterBuilder)builder.addName("Wraparound state")).createGroup(new GeneralParameterDescriptor[]{Wraparound.WRAPAROUND_DIMENSION, shift});
            }
            return p;
        }

        public List<GeneralParameterValue> values() {
            return List.of(this.parameter("wraparound_dim"), this.parameter("shift"));
        }

        public ParameterValue<?> parameter(String name) {
            switch (name) {
                case "wraparound_dim": {
                    ParameterValue p = Wraparound.WRAPAROUND_DIMENSION.createValue();
                    p.setValue(this.wraparoundDimension);
                    return p;
                }
                case "shift": {
                    ParameterValue p = (ParameterValue)((GeneralParameterDescriptor)this.getDescriptor().descriptors().get(1)).createValue();
                    p.setValue(this.period * this.limit);
                    return p;
                }
            }
            throw new ParameterNotFoundException(null, name);
        }

        public List<ParameterValueGroup> groups(String name) {
            throw new ParameterNotFoundException(null, name);
        }

        public ParameterValueGroup addGroup(String name) {
            throw new ParameterNotFoundException(null, name);
        }
    }

    static final class Controller
    implements UnaryOperator<WraparoundTransform> {
        final MathTransform transform;
        private WraparoundInEnvelope[] wraparounds;

        Controller(MathTransform transform) {
            this.transform = WraparoundTransform.replace(transform, this);
        }

        @Override
        public WraparoundTransform apply(WraparoundTransform transform) {
            if (!Double.isFinite(transform.sourceMedian)) {
                return transform;
            }
            WraparoundInEnvelope w = new WraparoundInEnvelope(transform);
            this.wraparounds = this.wraparounds == null ? new WraparoundInEnvelope[]{w} : (WraparoundInEnvelope[])ArraysExt.append((Object[])this.wraparounds, (Object)w);
            return w;
        }

        final boolean translate() {
            boolean modified = false;
            if (this.wraparounds != null) {
                for (WraparoundInEnvelope tr : this.wraparounds) {
                    modified |= tr.translate();
                }
            }
            return modified;
        }

        final Parameters state() {
            State state = null;
            if (this.wraparounds != null) {
                for (WraparoundInEnvelope tr : this.wraparounds) {
                    state = new State(tr, state);
                }
            }
            return state;
        }
    }
}

