/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener;

import lombok.Generated;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.EndpointSourceBuilder;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.EndpointRelation;
import org.apache.skywalking.oap.server.core.source.Service;
import org.apache.skywalking.oap.server.core.source.ServiceInstance;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceRelation;
import org.apache.skywalking.oap.server.core.source.ServiceRelation;
import org.apache.skywalking.oap.server.library.util.StringUtil;

class RPCTrafficSourceBuilder
extends EndpointSourceBuilder {
    private String sourceServiceName;
    private Layer sourceLayer;
    private String sourceServiceInstanceName;
    private Layer sourceEndpointOwnerServiceLayer;
    private String sourceEndpointOwnerServiceName;
    private String sourceEndpointName;
    private int componentId;

    RPCTrafficSourceBuilder(NamingControl namingControl) {
        super(namingControl);
    }

    @Override
    void prepare() {
        this.sourceServiceName = this.namingControl.formatServiceName(this.sourceServiceName);
        this.sourceEndpointOwnerServiceName = this.namingControl.formatServiceName(this.sourceEndpointOwnerServiceName);
        this.sourceServiceInstanceName = this.namingControl.formatInstanceName(this.sourceServiceInstanceName);
        this.sourceEndpointName = this.namingControl.formatEndpointName(this.sourceServiceName, this.sourceEndpointName);
        super.prepare();
    }

    Service toService() {
        Service service = new Service();
        service.setName(this.destServiceName);
        service.setServiceInstanceName(this.destServiceInstanceName);
        service.setEndpointName(this.destEndpointName);
        service.setLayer(this.destLayer);
        service.setLatency(this.latency);
        service.setStatus(this.status);
        service.setHttpResponseStatusCode(this.httpResponseStatusCode);
        service.setRpcStatusCode(this.rpcStatusCode);
        service.setType(this.type);
        service.setTags(this.tags);
        service.setTimeBucket(this.timeBucket);
        service.setOriginalTags(this.originalTags);
        return service;
    }

    ServiceRelation toServiceRelation() {
        ServiceRelation serviceRelation = new ServiceRelation();
        serviceRelation.setSourceServiceName(this.sourceServiceName);
        serviceRelation.setSourceServiceInstanceName(this.sourceServiceInstanceName);
        serviceRelation.setSourceLayer(this.sourceLayer);
        serviceRelation.setDestServiceName(this.destServiceName);
        serviceRelation.setDestServiceInstanceName(this.destServiceInstanceName);
        serviceRelation.setDestLayer(this.destLayer);
        serviceRelation.setEndpoint(this.destEndpointName);
        serviceRelation.setComponentId(this.componentId);
        serviceRelation.setLatency(this.latency);
        serviceRelation.setStatus(this.status);
        serviceRelation.setHttpResponseStatusCode(this.httpResponseStatusCode);
        serviceRelation.setRpcStatusCode(this.rpcStatusCode);
        serviceRelation.setType(this.type);
        serviceRelation.setDetectPoint(this.detectPoint);
        serviceRelation.setTimeBucket(this.timeBucket);
        return serviceRelation;
    }

    ServiceInstance toServiceInstance() {
        ServiceInstance serviceInstance = new ServiceInstance();
        serviceInstance.setName(this.destServiceInstanceName);
        serviceInstance.setServiceName(this.destServiceName);
        serviceInstance.setServiceLayer(this.destLayer);
        serviceInstance.setEndpointName(this.destEndpointName);
        serviceInstance.setLatency(this.latency);
        serviceInstance.setStatus(this.status);
        serviceInstance.setHttpResponseStatusCode(this.httpResponseStatusCode);
        serviceInstance.setRpcStatusCode(this.rpcStatusCode);
        serviceInstance.setType(this.type);
        serviceInstance.setTags(this.tags);
        serviceInstance.setOriginalTags(this.originalTags);
        serviceInstance.setTimeBucket(this.timeBucket);
        return serviceInstance;
    }

    ServiceInstanceRelation toServiceInstanceRelation() {
        if (StringUtil.isEmpty((String)this.sourceServiceInstanceName) || StringUtil.isEmpty((String)this.destServiceInstanceName)) {
            return null;
        }
        ServiceInstanceRelation serviceInstanceRelation = new ServiceInstanceRelation();
        serviceInstanceRelation.setSourceServiceName(this.sourceServiceName);
        serviceInstanceRelation.setSourceServiceInstanceName(this.sourceServiceInstanceName);
        serviceInstanceRelation.setSourceServiceLayer(this.sourceLayer);
        serviceInstanceRelation.setDestServiceName(this.destServiceName);
        serviceInstanceRelation.setDestServiceInstanceName(this.destServiceInstanceName);
        serviceInstanceRelation.setDestServiceLayer(this.destLayer);
        serviceInstanceRelation.setEndpoint(this.destEndpointName);
        serviceInstanceRelation.setComponentId(this.componentId);
        serviceInstanceRelation.setLatency(this.latency);
        serviceInstanceRelation.setStatus(this.status);
        serviceInstanceRelation.setHttpResponseStatusCode(this.httpResponseStatusCode);
        serviceInstanceRelation.setRpcStatusCode(this.rpcStatusCode);
        serviceInstanceRelation.setType(this.type);
        serviceInstanceRelation.setDetectPoint(this.detectPoint);
        serviceInstanceRelation.setTimeBucket(this.timeBucket);
        return serviceInstanceRelation;
    }

    EndpointRelation toEndpointRelation() {
        if (StringUtil.isEmpty((String)this.sourceEndpointName) || StringUtil.isEmpty((String)this.destEndpointName)) {
            return null;
        }
        EndpointRelation endpointRelation = new EndpointRelation();
        endpointRelation.setEndpoint(this.sourceEndpointName);
        if (this.sourceEndpointOwnerServiceName == null) {
            endpointRelation.setServiceName(this.sourceServiceName);
            endpointRelation.setServiceLayer(this.sourceLayer);
        } else {
            endpointRelation.setServiceName(this.sourceEndpointOwnerServiceName);
            endpointRelation.setServiceLayer(this.sourceEndpointOwnerServiceLayer);
        }
        endpointRelation.setServiceInstanceName(this.sourceServiceInstanceName);
        endpointRelation.setChildEndpoint(this.destEndpointName);
        endpointRelation.setChildServiceName(this.destServiceName);
        endpointRelation.setChildServiceLayer(this.destLayer);
        endpointRelation.setChildServiceInstanceName(this.destServiceInstanceName);
        endpointRelation.setComponentId(this.componentId);
        endpointRelation.setRpcLatency(this.latency);
        endpointRelation.setStatus(this.status);
        endpointRelation.setHttpResponseStatusCode(this.httpResponseStatusCode);
        endpointRelation.setRpcStatusCode(this.rpcStatusCode);
        endpointRelation.setType(this.type);
        endpointRelation.setDetectPoint(this.detectPoint);
        endpointRelation.setTimeBucket(this.timeBucket);
        return endpointRelation;
    }

    @Generated
    public String getSourceServiceName() {
        return this.sourceServiceName;
    }

    @Generated
    public void setSourceServiceName(String sourceServiceName) {
        this.sourceServiceName = sourceServiceName;
    }

    @Generated
    public Layer getSourceLayer() {
        return this.sourceLayer;
    }

    @Generated
    public void setSourceLayer(Layer sourceLayer) {
        this.sourceLayer = sourceLayer;
    }

    @Generated
    public String getSourceServiceInstanceName() {
        return this.sourceServiceInstanceName;
    }

    @Generated
    public void setSourceServiceInstanceName(String sourceServiceInstanceName) {
        this.sourceServiceInstanceName = sourceServiceInstanceName;
    }

    @Generated
    public Layer getSourceEndpointOwnerServiceLayer() {
        return this.sourceEndpointOwnerServiceLayer;
    }

    @Generated
    public void setSourceEndpointOwnerServiceLayer(Layer sourceEndpointOwnerServiceLayer) {
        this.sourceEndpointOwnerServiceLayer = sourceEndpointOwnerServiceLayer;
    }

    @Generated
    public String getSourceEndpointOwnerServiceName() {
        return this.sourceEndpointOwnerServiceName;
    }

    @Generated
    public void setSourceEndpointOwnerServiceName(String sourceEndpointOwnerServiceName) {
        this.sourceEndpointOwnerServiceName = sourceEndpointOwnerServiceName;
    }

    @Generated
    public String getSourceEndpointName() {
        return this.sourceEndpointName;
    }

    @Generated
    public void setSourceEndpointName(String sourceEndpointName) {
        this.sourceEndpointName = sourceEndpointName;
    }

    @Generated
    public int getComponentId() {
        return this.componentId;
    }

    @Generated
    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }
}

