/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.data.MergableBufferedData;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricStreamKind;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.datacarrier.DataCarrier;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.BufferStrategy;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.QueueBuffer;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.BulkConsumePool;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.ConsumerPoolFactory;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.GaugeMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetricsAggregateWorker
extends AbstractWorker<Metrics> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsAggregateWorker.class);
    public final long l1FlushPeriod;
    private AbstractWorker<Metrics> nextWorker;
    private final DataCarrier<Metrics> dataCarrier;
    private final MergableBufferedData<Metrics> mergeDataCache;
    private CounterMetrics abandonCounter;
    private CounterMetrics aggregationCounter;
    private GaugeMetrics queuePercentageGauge;
    private long lastSendTime = 0L;
    private final int queueTotalSize;

    MetricsAggregateWorker(ModuleDefineHolder moduleDefineHolder, AbstractWorker<Metrics> nextWorker, String modelName, long l1FlushPeriod, MetricStreamKind kind, String poolName, int poolSize, boolean isSignalDrivenMode, int queueChannelSize, int queueBufferSize) {
        super(moduleDefineHolder);
        this.nextWorker = nextWorker;
        this.mergeDataCache = new MergableBufferedData();
        BulkConsumePool.Creator creator = new BulkConsumePool.Creator(poolName, poolSize, 200L, isSignalDrivenMode);
        this.dataCarrier = new DataCarrier("MetricsAggregateWorker." + modelName, poolName, queueChannelSize, queueBufferSize, BufferStrategy.IF_POSSIBLE);
        try {
            ConsumerPoolFactory.INSTANCE.createIfAbsent(poolName, (Callable)creator);
        }
        catch (Exception e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.dataCarrier.consume(ConsumerPoolFactory.INSTANCE.get(poolName), (IConsumer)new AggregatorConsumer());
        MetricsCreator metricsCreator = (MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class);
        this.abandonCounter = metricsCreator.createCounter("metrics_aggregator_abandon", "The abandon number of rows received in aggregation.", new MetricsTag.Keys(new String[]{"metricName", "level", "dimensionality"}), new MetricsTag.Values(new String[]{modelName, "1", "minute"}));
        this.aggregationCounter = metricsCreator.createCounter("metrics_aggregation", "The number of rows in aggregation.", new MetricsTag.Keys(new String[]{"metricName", "level", "dimensionality"}), new MetricsTag.Values(new String[]{modelName, "1", "minute"}));
        this.queuePercentageGauge = metricsCreator.createGauge("metrics_aggregation_queue_used_percentage", "The percentage of queue used in aggregation.", new MetricsTag.Keys(new String[]{"metricName", "level", "kind"}), new MetricsTag.Values(new String[]{modelName, "1", kind.name()}));
        this.l1FlushPeriod = l1FlushPeriod;
        this.queueTotalSize = Arrays.stream(this.dataCarrier.getChannels().getBufferChannels()).mapToInt(QueueBuffer::getBufferSize).sum();
    }

    @Override
    public void in(Metrics metrics) {
        if (!this.dataCarrier.produce((Object)metrics)) {
            this.abandonCounter.inc();
        }
    }

    private void onWork(List<Metrics> metricsList) {
        metricsList.forEach(metrics -> {
            this.aggregationCounter.inc();
            this.mergeDataCache.accept((Metrics)metrics);
        });
        this.flush();
    }

    private void flush() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSendTime > this.l1FlushPeriod) {
            this.mergeDataCache.read().forEach(data -> this.nextWorker.in((Metrics)data));
            this.lastSendTime = currentTime;
        }
    }

    protected class AggregatorConsumer
    implements IConsumer<Metrics> {
        protected AggregatorConsumer() {
        }

        public void consume(List<Metrics> data) {
            MetricsAggregateWorker.this.queuePercentageGauge.setValue((double)Math.round(100.0 * (double)data.size() / (double)MetricsAggregateWorker.this.queueTotalSize));
            MetricsAggregateWorker.this.onWork(data);
        }

        public void onError(List<Metrics> data, Throwable t) {
            log.error(t.getMessage(), t);
        }

        public void nothingToConsume() {
            MetricsAggregateWorker.this.flush();
        }
    }
}

