/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.asyncprofiler.storage;

import com.google.gson.Gson;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.analysis.worker.NoneStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@ScopeDeclaration(id=85, name="AsyncProfilerTask")
@Stream(name="async_profiler_task", scopeId=85, builder=Builder.class, processor=NoneStreamProcessor.class)
@BanyanDB.TimestampColumn(value="create_time")
@BanyanDB.Group(streamGroup=BanyanDB.StreamGroup.RECORDS)
public class AsyncProfilerTaskRecord
extends NoneStream {
    private static final Gson GSON = new Gson();
    public static final String INDEX_NAME = "async_profiler_task";
    public static final String TASK_ID = "task_id";
    public static final String SERVICE_ID = "service_id";
    public static final String SERVICE_INSTANCE_IDS = "service_instance_ids";
    public static final String CREATE_TIME = "create_time";
    public static final String EVENT_TYPES = "events";
    public static final String DURATION = "duration";
    public static final String EXEC_ARGS = "exec_args";
    @Column(name="service_id")
    @BanyanDB.SeriesID(index=0)
    private String serviceId;
    @Column(name="service_instance_ids")
    private String serviceInstanceIds;
    @Column(name="task_id")
    private String taskId;
    @ElasticSearch.EnableDocValues
    @Column(name="create_time")
    private long createTime;
    @Column(name="duration")
    private int duration;
    @Column(name="events")
    private String events;
    @Column(name="exec_args", storageOnly=true)
    private String execArgs;

    @Override
    public StorageID id() {
        return new StorageID().append(TASK_ID, this.taskId);
    }

    public void setServiceInstanceIdsFromList(List<String> serviceInstanceIds) {
        this.serviceInstanceIds = GSON.toJson(serviceInstanceIds);
    }

    public void setEventsFromList(List<String> events) {
        this.events = GSON.toJson(events);
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Generated
    public String getEvents() {
        return this.events;
    }

    @Generated
    public String getExecArgs() {
        return this.execArgs;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setServiceInstanceIds(String serviceInstanceIds) {
        this.serviceInstanceIds = serviceInstanceIds;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Generated
    public void setEvents(String events) {
        this.events = events;
    }

    @Generated
    public void setExecArgs(String execArgs) {
        this.execArgs = execArgs;
    }

    public static class Builder
    implements StorageBuilder<AsyncProfilerTaskRecord> {
        @Override
        public AsyncProfilerTaskRecord storage2Entity(Convert2Entity converter) {
            AsyncProfilerTaskRecord record = new AsyncProfilerTaskRecord();
            record.setServiceId((String)converter.get(AsyncProfilerTaskRecord.SERVICE_ID));
            record.setServiceInstanceIds((String)converter.get(AsyncProfilerTaskRecord.SERVICE_INSTANCE_IDS));
            record.setTaskId((String)converter.get(AsyncProfilerTaskRecord.TASK_ID));
            record.setCreateTime(((Number)converter.get(AsyncProfilerTaskRecord.CREATE_TIME)).longValue());
            record.setDuration(((Number)converter.get(AsyncProfilerTaskRecord.DURATION)).intValue());
            record.setEvents((String)converter.get(AsyncProfilerTaskRecord.EVENT_TYPES));
            record.setExecArgs((String)converter.get(AsyncProfilerTaskRecord.EXEC_ARGS));
            record.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return record;
        }

        @Override
        public void entity2Storage(AsyncProfilerTaskRecord storageData, Convert2Storage converter) {
            converter.accept(AsyncProfilerTaskRecord.SERVICE_ID, storageData.getServiceId());
            converter.accept(AsyncProfilerTaskRecord.SERVICE_INSTANCE_IDS, storageData.getServiceInstanceIds());
            converter.accept(AsyncProfilerTaskRecord.TASK_ID, storageData.getTaskId());
            converter.accept(AsyncProfilerTaskRecord.CREATE_TIME, storageData.getCreateTime());
            converter.accept(AsyncProfilerTaskRecord.DURATION, storageData.getDuration());
            converter.accept(AsyncProfilerTaskRecord.EVENT_TYPES, storageData.getEvents());
            converter.accept(AsyncProfilerTaskRecord.EXEC_ARGS, storageData.getExecArgs());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

